/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;

public class RegexEvalMetaTest {
    RowMetaInterface mockInputRowMeta;
    VariableSpace mockVariableSpace;

    @BeforeClass
    public static void setupClass() throws KettleException {
        ValueMetaPluginType.getInstance().searchPlugins();
    }

    @Before
    public void setup() {
        this.mockInputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.mockVariableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
    }

    @Test
    public void testGetFieldsReplacesResultFieldIfItExists() throws KettleStepException {
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        String resultField = "result";
        regexEvalMeta.setResultFieldName(resultField);
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(resultField)).thenReturn((Object)0);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)mockValueMeta.getName()).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).setValueMeta(Matchers.eq((int)0), (ValueMetaInterface)captor.capture());
        Assert.assertEquals((String)mockName, (String)((ValueMetaInterface)captor.getValue()).getName());
    }

    @Test
    public void testGetFieldsAddsResultFieldIfDoesntExist() throws KettleStepException {
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        String resultField = "result";
        regexEvalMeta.setResultFieldName(resultField);
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(resultField)).thenReturn((Object)-1);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)this.mockVariableSpace.environmentSubstitute(resultField)).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).addValueMeta((ValueMetaInterface)captor.capture());
        Assert.assertEquals((String)mockName, (String)((ValueMetaInterface)captor.getValue()).getName());
    }

    @Test
    public void testGetFieldsReplacesFieldIfItExists() throws KettleStepException {
        String fieldName;
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        regexEvalMeta.allocate(1);
        regexEvalMeta.getFieldName()[0] = fieldName = "fieldname";
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(fieldName)).thenReturn((Object)0);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)mockValueMeta.getName()).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.setAllowCaptureGroupsFlag(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).setValueMeta(Matchers.eq((int)0), (ValueMetaInterface)captor.capture());
        Assert.assertEquals((String)mockName, (String)((ValueMetaInterface)captor.getValue()).getName());
    }

    @Test
    public void testGetFieldsAddsFieldIfDoesntExist() throws KettleStepException {
        String fieldName;
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        String name = "TEST_NAME";
        regexEvalMeta.allocate(1);
        regexEvalMeta.getFieldName()[0] = fieldName = "fieldname";
        Mockito.when((Object)this.mockInputRowMeta.indexOfValue(fieldName)).thenReturn((Object)-1);
        ValueMetaInterface mockValueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        String mockName = "MOCK_NAME";
        Mockito.when((Object)this.mockVariableSpace.environmentSubstitute(fieldName)).thenReturn((Object)mockName);
        Mockito.when((Object)this.mockInputRowMeta.getValueMeta(0)).thenReturn((Object)mockValueMeta);
        regexEvalMeta.setReplacefields(true);
        regexEvalMeta.setAllowCaptureGroupsFlag(true);
        regexEvalMeta.getFields(this.mockInputRowMeta, name, null, null, this.mockVariableSpace, null, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ValueMetaInterface.class);
        ((RowMetaInterface)Mockito.verify((Object)this.mockInputRowMeta)).addValueMeta((ValueMetaInterface)captor.capture());
        Assert.assertEquals((String)fieldName, (String)((ValueMetaInterface)captor.getValue()).getName());
    }
}

