/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.prioritizestreams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreams;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreamsData;
import org.pentaho.di.trans.steps.prioritizestreams.PrioritizeStreamsMeta;

@RunWith(value=Parameterized.class)
public class PrioritizeStreamsExecutionIT {
    private String old_timeout_get;
    private static StepMockHelper<PrioritizeStreamsMeta, StepDataInterface> stepMockHelper;
    private static PrioritizeStreamsMeta meta;
    private TestData code;
    private static ExecutorService service;

    public PrioritizeStreamsExecutionIT(TestData code) {
        this.code = code;
    }

    @BeforeClass
    public static void setup() {
        stepMockHelper = new StepMockHelper<PrioritizeStreamsMeta, StepDataInterface>("Priority Streams Test", PrioritizeStreamsMeta.class, StepDataInterface.class);
        Mockito.when((Object)PrioritizeStreamsExecutionIT.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)PrioritizeStreamsExecutionIT.stepMockHelper.logChannelInterface);
        Mockito.when((Object)PrioritizeStreamsExecutionIT.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        meta = (PrioritizeStreamsMeta)Mockito.mock(PrioritizeStreamsMeta.class);
    }

    @AfterClass
    public static void tearDown() {
        stepMockHelper.cleanUp();
        service.shutdown();
    }

    @Before
    public void before() {
        this.old_timeout_get = System.getProperty("KETTLE_ROWSET_GET_TIMEOUT");
        System.setProperty("KETTLE_ROWSET_GET_TIMEOUT", "1000");
    }

    @After
    public void after() {
        if (this.old_timeout_get != null) {
            System.setProperty("KETTLE_ROWSET_GET_TIMEOUT", this.old_timeout_get);
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> primeNumbers() {
        TestData[] td = TestData.values();
        Object[][] ret = new Object[td.length][1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Object[]{td[i]};
        }
        return Arrays.asList(ret);
    }

    @Test
    public void testProcessRow() throws KettleException {
        PrioritizeStreamsData data = this.getTestData(this.code);
        PrioritizeStreamsInner ps = new PrioritizeStreamsInner(stepMockHelper);
        ps.first = false;
        for (int i = 0; i < 9; ++i) {
            ps.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        }
        Assert.assertEquals((String)("Output stream collect all rows: " + ps.toString()), (long)9L, (long)ps.output.size());
        Assert.assertEquals((String)"Stream output respect priority", (Object)this.code.toString(), (Object)ps.toString());
    }

    private PrioritizeStreamsData getTestData(TestData code) {
        PrioritizeStreamsData retData = new PrioritizeStreamsData();
        BlockingRowSet in1 = new BlockingRowSet(4);
        BlockingRowSet in2 = new BlockingRowSet(4);
        BlockingRowSet in3 = new BlockingRowSet(4);
        Object[][] data1 = new Object[][]{{"a"}, {"a"}, {"a"}};
        Object[][] data2 = new Object[][]{{"b"}, {"b"}, {"b"}};
        Object[][] data3 = new Object[][]{{"c"}, {"c"}, {"c"}};
        RowMeta rmi = new RowMeta();
        Runnable stream1 = this.getInputProduser((RowSet)in1, (RowMetaInterface)rmi, data1);
        Runnable stream2 = this.getInputProduser((RowSet)in2, (RowMetaInterface)rmi, data2);
        Runnable stream3 = this.getInputProduser((RowSet)in3, (RowMetaInterface)rmi, data3);
        retData.outputRowMeta = rmi;
        switch (code) {
            case ABC: {
                retData.rowSets = new RowSet[]{in1, in2, in3};
                break;
            }
            case BAC: {
                retData.rowSets = new RowSet[]{in2, in1, in3};
                break;
            }
            case BCA: {
                retData.rowSets = new RowSet[]{in2, in3, in1};
                break;
            }
            case CAB: {
                retData.rowSets = new RowSet[]{in3, in1, in2};
                break;
            }
            case CBA: {
                retData.rowSets = new RowSet[]{in3, in2, in1};
                break;
            }
            default: {
                Assert.fail((String)("This test data does not supported: " + code.toString()));
            }
        }
        retData.currentRowSet = retData.rowSets[0];
        retData.stepnr = 0;
        retData.stepnrs = 3;
        service.execute(stream1);
        service.execute(stream2);
        service.execute(stream3);
        return retData;
    }

    private Runnable getInputProduser(RowSet in, RowMetaInterface rmi, Object[][] data) {
        return new InputProducer(in, rmi, data);
    }

    static {
        service = Executors.newCachedThreadPool();
    }

    private class PrioritizeStreamsInner
    extends PrioritizeStreams {
        List<Object[]> output;

        public PrioritizeStreamsInner(StepMockHelper<PrioritizeStreamsMeta, StepDataInterface> stepMockHelper) {
            super(stepMockHelper.stepMeta, stepMockHelper.stepDataInterface, 0, stepMockHelper.transMeta, stepMockHelper.trans);
            this.output = new ArrayList<Object[]>();
        }

        public Object[] getRowFrom(RowSet rs) {
            return rs.getRow();
        }

        public void putRow(RowMetaInterface rmi, Object[] row) {
            this.output.add(row);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<Object[]> it = this.output.iterator();
            while (it.hasNext()) {
                String val = (String)String.class.cast(it.next()[0]);
                sb.append(val);
            }
            return sb.toString();
        }
    }

    private class InputProducer
    implements Runnable {
        private Queue<Object[]> data = new LinkedList<Object[]>();
        private RowSet rs;
        private RowMetaInterface rmi;
        private boolean first = true;

        InputProducer(RowSet in, RowMetaInterface rmi, Object[][] data) {
            this.data.addAll(Arrays.asList(data));
            this.rs = in;
            this.rmi = rmi;
        }

        @Override
        public void run() {
            while (this.data.peek() != null) {
                if (this.first) {
                    this.first = false;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Object[] putTo = this.data.poll();
                this.rs.putRowWait(this.rmi, putTo, 20L, TimeUnit.SECONDS);
            }
            this.rs.setDone();
        }
    }

    static enum TestData {
        ABC("aaabbbccc"),
        BAC("bbbaaaccc"),
        BCA("bbbcccaaa"),
        CAB("cccaaabbb"),
        CBA("cccbbbaaa");

        private String res;

        private TestData(String res) {
            this.res = res;
        }

        public String toString() {
            return this.res;
        }
    }
}

