/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mock;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class StepMockHelper<Meta extends StepMetaInterface, Data extends StepDataInterface> {
    public final StepMeta stepMeta;
    public final Data stepDataInterface;
    public final TransMeta transMeta;
    public final Trans trans;
    public final Meta initStepMetaInterface;
    public final Data initStepDataInterface;
    public final Meta processRowsStepMetaInterface;
    public final Data processRowsStepDataInterface;
    public final LogChannelInterface logChannelInterface;
    public final LogChannelInterfaceFactory logChannelInterfaceFactory;
    public final LogChannelInterfaceFactory originalLogChannelInterfaceFactory = KettleLogStore.getLogChannelInterfaceFactory();

    public StepMockHelper(String stepName, Class<Meta> stepMetaClass, Class<Data> stepDataClass) {
        this.logChannelInterfaceFactory = (LogChannelInterfaceFactory)Mockito.mock(LogChannelInterfaceFactory.class);
        this.logChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)this.logChannelInterfaceFactory);
        this.stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)this.stepMeta.getName()).thenReturn((Object)stepName);
        this.stepDataInterface = (StepDataInterface)Mockito.mock(stepDataClass);
        this.transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)this.transMeta.findStep(stepName)).thenReturn((Object)this.stepMeta);
        this.trans = (Trans)Mockito.mock(Trans.class);
        this.initStepMetaInterface = (StepMetaInterface)Mockito.mock(stepMetaClass);
        this.initStepDataInterface = (StepDataInterface)Mockito.mock(stepDataClass);
        this.processRowsStepDataInterface = (StepDataInterface)Mockito.mock(stepDataClass);
        this.processRowsStepMetaInterface = (StepMetaInterface)Mockito.mock(stepMetaClass);
    }

    public RowSet getMockInputRowSet(Object[] ... rows) {
        return this.getMockInputRowSet(StepMockHelper.asList(rows));
    }

    public RowSet getMockInputRowSet(final List<Object[]> rows) {
        final AtomicInteger index = new AtomicInteger(0);
        RowSet rowSet = (RowSet)Mockito.mock(RowSet.class, (Answer)Mockito.RETURNS_MOCKS);
        Answer<Object[]> answer = new Answer<Object[]>(){

            public Object[] answer(InvocationOnMock invocation) throws Throwable {
                int i = index.getAndIncrement();
                return i < rows.size() ? (Object[])rows.get(i) : null;
            }
        };
        Mockito.when((Object)rowSet.getRowWait(Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenAnswer((Answer)answer);
        Mockito.when((Object)rowSet.getRow()).thenAnswer((Answer)answer);
        Mockito.when((Object)rowSet.isDone()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                return index.get() >= rows.size();
            }
        });
        return rowSet;
    }

    public static List<Object[]> asList(Object[] ... objects) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Collections.addAll(result, objects);
        return result;
    }

    public void cleanUp() {
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)this.originalLogChannelInterfaceFactory);
    }

    public void redirectLog(final OutputStream out, LogLevel channelLogLevel) {
        final LogChannel log = (LogChannel)Mockito.spy((Object)new LogChannel((Object)this.getClass().getName(), true));
        log.setLogLevel(channelLogLevel);
        Mockito.when((Object)this.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)log);
        ((LogChannel)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                LogLevel channelLogLevel;
                Object[] args = invocation.getArguments();
                LogLevel logLevel = (LogLevel)args[1];
                if (!logLevel.isVisible(channelLogLevel = log.getLogLevel())) {
                    return null;
                }
                if (channelLogLevel.getLevel() >= logLevel.getLevel()) {
                    LogMessageInterface logMessage = (LogMessageInterface)args[0];
                    out.write(logMessage.getMessage().getBytes());
                    out.write(10);
                    out.write(13);
                    out.flush();
                    return true;
                }
                return false;
            }
        }).when((Object)log)).println((LogMessageInterface)Matchers.anyObject(), (LogLevel)Matchers.anyObject());
    }
}

