/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.metainject.MetaInject;
import org.pentaho.di.trans.steps.metainject.MetaInjectData;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;

public class MetaInjectTest {
    private static final String INJECTOR_STEP_NAME = "TEST_STEP_FOR_INJECTION";
    private static final String TEST_VALUE = "TEST_VALUE";
    private static final String TEST_VARIABLE = "TEST_VARIABLE";
    private static final String TEST_PARAMETER = "TEST_PARAMETER";
    private static final String TEST_TARGET_STEP_NAME = "TEST_TARGET_STEP_NAME";
    private static final String TEST_SOURCE_STEP_NAME = "TEST_SOURCE_STEP_NAME";
    private static final String TEST_ATTR_VALUE = "TEST_ATTR_VALUE";
    private static final String TEST_FIELD = "TEST_FIELD";
    private static final String UNAVAILABLE_STEP = "UNAVAILABLE_STEP";
    private static final TargetStepAttribute UNAVAILABLE_TARGET_STEP = new TargetStepAttribute("UNAVAILABLE_STEP", "TEST_ATTR_VALUE", false);
    private static final SourceStepField UNAVAILABLE_SOURCE_STEP = new SourceStepField("UNAVAILABLE_STEP", "TEST_FIELD");
    private MetaInject metaInject;
    private MetaInjectMeta meta;
    private MetaInjectData data;
    private TransMeta transMeta;
    private StepMetaInjectionInterface metaInjectionInterface;

    @Before
    public void before() throws Exception {
        this.metaInject = StepMockUtil.getStep(MetaInject.class, MetaInjectMeta.class, "MetaInjectTest");
        this.metaInject = (MetaInject)Mockito.spy((Object)this.metaInject);
        this.transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((MetaInject)Mockito.doReturn((Object)this.transMeta).when((Object)this.metaInject)).getTransMeta();
        this.meta = new MetaInjectMeta();
        this.data = new MetaInjectData();
        TransMeta internalTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        ((StepMeta)Mockito.doReturn((Object)INJECTOR_STEP_NAME).when((Object)stepMeta)).getName();
        ((TransMeta)Mockito.doReturn(Collections.singletonList(stepMeta)).when((Object)internalTransMeta)).getUsedSteps();
        StepMetaInterface stepMetaInterface = (StepMetaInterface)Mockito.mock(StepMetaInterface.class);
        ((StepMeta)Mockito.doReturn((Object)stepMetaInterface).when((Object)stepMeta)).getStepMetaInterface();
        this.metaInjectionInterface = (StepMetaInjectionInterface)Mockito.mock(StepMetaInjectionInterface.class);
        ((StepMetaInterface)Mockito.doReturn((Object)this.metaInjectionInterface).when((Object)stepMetaInterface)).getStepMetaInjectionInterface();
        ((MetaInject)Mockito.doReturn((Object)internalTransMeta).when((Object)this.metaInject)).loadTransformationMeta();
    }

    @Test
    public void injectMetaFromMultipleInputSteps() throws KettleException {
        LinkedHashMap<TargetStepAttribute, SourceStepField> targetSourceMapping = new LinkedHashMap<TargetStepAttribute, SourceStepField>();
        targetSourceMapping.put(new TargetStepAttribute(INJECTOR_STEP_NAME, "DATA_TYPE", true), new SourceStepField("TYPE_INPUT", "col_type"));
        targetSourceMapping.put(new TargetStepAttribute(INJECTOR_STEP_NAME, "NAME", true), new SourceStepField("NAME_INPUT", "col_name"));
        this.meta.setTargetSourceMapping(targetSourceMapping);
        ((TransMeta)Mockito.doReturn((Object)new String[]{"NAME_INPUT", "TYPE_INPUT"}).when((Object)this.transMeta)).getPrevStepNames((StepMeta)Matchers.any(StepMeta.class));
        RowSet nameInputRowSet = (RowSet)Mockito.mock(RowSet.class);
        RowMeta nameRowMeta = new RowMeta();
        nameRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col_name"));
        ((RowSet)Mockito.doReturn((Object)nameRowMeta).when((Object)nameInputRowSet)).getRowMeta();
        ((MetaInject)Mockito.doReturn((Object)nameInputRowSet).when((Object)this.metaInject)).findInputRowSet("NAME_INPUT");
        RowSet typeInputRowSet = (RowSet)Mockito.mock(RowSet.class);
        RowMeta typeRowMeta = new RowMeta();
        typeRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("col_type"));
        ((RowSet)Mockito.doReturn((Object)typeRowMeta).when((Object)typeInputRowSet)).getRowMeta();
        ((MetaInject)Mockito.doReturn((Object)typeInputRowSet).when((Object)this.metaInject)).findInputRowSet("TYPE_INPUT");
        ((MetaInject)Mockito.doReturn((Object)new Object[]{"FIRST_NAME"}).doReturn(null).when((Object)this.metaInject)).getRowFrom(nameInputRowSet);
        ((MetaInject)Mockito.doReturn((Object)new Object[]{"String"}).doReturn(null).when((Object)this.metaInject)).getRowFrom(typeInputRowSet);
        ArrayList<StepInjectionMetaEntry> injectionMetaEntryList = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fields = new StepInjectionMetaEntry("FIELDS", 0, "");
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry("FIELD", 0, "");
        fields.getDetails().add(fieldEntry);
        StepInjectionMetaEntry nameEntry = new StepInjectionMetaEntry("NAME", 2, "");
        fieldEntry.getDetails().add(nameEntry);
        StepInjectionMetaEntry dataEntry = new StepInjectionMetaEntry("DATA_TYPE", 2, "");
        fieldEntry.getDetails().add(dataEntry);
        injectionMetaEntryList.add(fields);
        ((StepMetaInjectionInterface)Mockito.doReturn(injectionMetaEntryList).when((Object)this.metaInjectionInterface)).getStepInjectionMetadataEntries();
        this.meta.setNoExecution(true);
        Assert.assertTrue((boolean)this.metaInject.init((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        this.metaInject.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        StepInjectionMetaEntry expectedNameEntry = new StepInjectionMetaEntry("NAME", (Object)"FIRST_NAME", 2, "");
        StepInjectionMetaEntry expectedDataEntry = new StepInjectionMetaEntry("DATA_TYPE", (Object)"String", 2, "");
        ((MetaInject)Mockito.verify((Object)this.metaInject, (VerificationMode)Mockito.atLeastOnce())).setEntryValueIfFieldExists((StepInjectionMetaEntry)Matchers.refEq((Object)expectedNameEntry, (String[])new String[0]), (RowMetaAndData)Matchers.any(RowMetaAndData.class), (SourceStepField)Matchers.any(SourceStepField.class));
        ((MetaInject)Mockito.verify((Object)this.metaInject, (VerificationMode)Mockito.atLeastOnce())).setEntryValueIfFieldExists((StepInjectionMetaEntry)Matchers.refEq((Object)expectedDataEntry, (String[])new String[0]), (RowMetaAndData)Matchers.any(RowMetaAndData.class), (SourceStepField)Matchers.any(SourceStepField.class));
    }

    @Test
    public void transVariablesPassedToChildTransformation() throws KettleException {
        ((MetaInject)Mockito.doReturn((Object)new String[]{TEST_VARIABLE}).when((Object)this.metaInject)).listVariables();
        ((MetaInject)Mockito.doReturn((Object)TEST_VALUE).when((Object)this.metaInject)).getVariable(TEST_VARIABLE);
        TransMeta transMeta = new TransMeta();
        ((MetaInject)Mockito.doReturn((Object)transMeta).when((Object)this.metaInject)).getTransMeta();
        TransMeta internalTransMeta = new TransMeta();
        ((MetaInject)Mockito.doReturn((Object)internalTransMeta).when((Object)this.metaInject)).loadTransformationMeta();
        Assert.assertTrue((boolean)this.metaInject.init((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Assert.assertEquals((Object)TEST_VALUE, (Object)internalTransMeta.getVariable(TEST_VARIABLE));
    }

    @Test
    public void transParametersPassedToChildTransformation() throws KettleException {
        TransMeta transMeta = new TransMeta();
        transMeta.addParameterDefinition(TEST_PARAMETER, "TEST_DEF_VALUE", "");
        transMeta.setParameterValue(TEST_PARAMETER, TEST_VALUE);
        ((MetaInject)Mockito.doReturn((Object)transMeta).when((Object)this.metaInject)).getTransMeta();
        TransMeta internalTransMeta = new TransMeta();
        ((MetaInject)Mockito.doReturn((Object)internalTransMeta).when((Object)this.metaInject)).loadTransformationMeta();
        Assert.assertTrue((boolean)this.metaInject.init((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Assert.assertEquals((Object)TEST_VALUE, (Object)internalTransMeta.getParameterValue(TEST_PARAMETER));
    }

    @Test
    public void getUnavailableSourceSteps() {
        TargetStepAttribute targetStep = new TargetStepAttribute(TEST_TARGET_STEP_NAME, TEST_ATTR_VALUE, false);
        SourceStepField unavailableSourceStep = new SourceStepField(UNAVAILABLE_STEP, TEST_FIELD);
        Map<TargetStepAttribute, SourceStepField> targetMap = Collections.singletonMap(targetStep, unavailableSourceStep);
        TransMeta sourceTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)new String[0]).when((Object)sourceTransMeta)).getPrevStepNames((StepMeta)Matchers.any(StepMeta.class));
        Set actualSet = MetaInject.getUnavailableSourceSteps(targetMap, (TransMeta)sourceTransMeta, (StepMeta)((StepMeta)Mockito.mock(StepMeta.class)));
        Assert.assertTrue((boolean)actualSet.contains(unavailableSourceStep));
    }

    @Test
    public void getUnavailableTargetSteps() {
        TargetStepAttribute unavailableTargetStep = new TargetStepAttribute(UNAVAILABLE_STEP, TEST_ATTR_VALUE, false);
        SourceStepField sourceStep = new SourceStepField(TEST_SOURCE_STEP_NAME, TEST_FIELD);
        Map<TargetStepAttribute, SourceStepField> targetMap = Collections.singletonMap(unavailableTargetStep, sourceStep);
        TransMeta injectedTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn(Collections.emptyList()).when((Object)injectedTransMeta)).getUsedSteps();
        Set actualSet = MetaInject.getUnavailableTargetSteps(targetMap, (TransMeta)injectedTransMeta);
        Assert.assertTrue((boolean)actualSet.contains(unavailableTargetStep));
    }

    @Test
    public void removeUnavailableStepsFromMapping_unavailable_source_step() {
        TargetStepAttribute unavailableTargetStep = new TargetStepAttribute(UNAVAILABLE_STEP, TEST_ATTR_VALUE, false);
        SourceStepField unavailableSourceStep = new SourceStepField(UNAVAILABLE_STEP, TEST_FIELD);
        HashMap<TargetStepAttribute, SourceStepField> targetMap = new HashMap<TargetStepAttribute, SourceStepField>();
        targetMap.put(unavailableTargetStep, unavailableSourceStep);
        Set<SourceStepField> unavailableSourceSteps = Collections.singleton(UNAVAILABLE_SOURCE_STEP);
        MetaInject.removeUnavailableStepsFromMapping(targetMap, unavailableSourceSteps, Collections.emptySet());
        Assert.assertTrue((boolean)targetMap.isEmpty());
    }

    @Test
    public void removeUnavailableStepsFromMapping_unavailable_target_step() {
        TargetStepAttribute unavailableTargetStep = new TargetStepAttribute(UNAVAILABLE_STEP, TEST_ATTR_VALUE, false);
        SourceStepField unavailableSourceStep = new SourceStepField(UNAVAILABLE_STEP, TEST_FIELD);
        HashMap<TargetStepAttribute, SourceStepField> targetMap = new HashMap<TargetStepAttribute, SourceStepField>();
        targetMap.put(unavailableTargetStep, unavailableSourceStep);
        Set<TargetStepAttribute> unavailableTargetSteps = Collections.singleton(UNAVAILABLE_TARGET_STEP);
        MetaInject.removeUnavailableStepsFromMapping(targetMap, Collections.emptySet(), unavailableTargetSteps);
        Assert.assertTrue((boolean)targetMap.isEmpty());
    }

    @Test
    public void removeUnavailableStepsFromMapping_unavailable_source_target_step() {
        TargetStepAttribute unavailableTargetStep = new TargetStepAttribute(UNAVAILABLE_STEP, TEST_ATTR_VALUE, false);
        SourceStepField unavailableSourceStep = new SourceStepField(UNAVAILABLE_STEP, TEST_FIELD);
        HashMap<TargetStepAttribute, SourceStepField> targetMap = new HashMap<TargetStepAttribute, SourceStepField>();
        targetMap.put(unavailableTargetStep, unavailableSourceStep);
        Set<TargetStepAttribute> unavailableTargetSteps = Collections.singleton(UNAVAILABLE_TARGET_STEP);
        Set<SourceStepField> unavailableSourceSteps = Collections.singleton(UNAVAILABLE_SOURCE_STEP);
        MetaInject.removeUnavailableStepsFromMapping(targetMap, unavailableSourceSteps, unavailableTargetSteps);
        Assert.assertTrue((boolean)targetMap.isEmpty());
    }

    @Test
    public void setEntryValue_string() throws KettleValueException {
        StepInjectionMetaEntry entry = (StepInjectionMetaEntry)Mockito.mock(StepInjectionMetaEntry.class);
        ((StepInjectionMetaEntry)Mockito.doReturn((Object)2).when((Object)entry)).getValueType();
        RowMetaAndData row = MetaInjectTest.createRowMetaAndData((ValueMetaInterface)new ValueMetaString(TEST_FIELD), TEST_VALUE);
        SourceStepField sourceField = new SourceStepField(TEST_SOURCE_STEP_NAME, TEST_FIELD);
        MetaInject.setEntryValue((StepInjectionMetaEntry)entry, (RowMetaAndData)row, (SourceStepField)sourceField);
        ((StepInjectionMetaEntry)Mockito.verify((Object)entry)).setValue((Object)TEST_VALUE);
    }

    @Test
    public void setEntryValue_boolean() throws KettleValueException {
        StepInjectionMetaEntry entry = (StepInjectionMetaEntry)Mockito.mock(StepInjectionMetaEntry.class);
        ((StepInjectionMetaEntry)Mockito.doReturn((Object)4).when((Object)entry)).getValueType();
        RowMetaAndData row = MetaInjectTest.createRowMetaAndData((ValueMetaInterface)new ValueMetaBoolean(TEST_FIELD), true);
        SourceStepField sourceField = new SourceStepField(TEST_SOURCE_STEP_NAME, TEST_FIELD);
        MetaInject.setEntryValue((StepInjectionMetaEntry)entry, (RowMetaAndData)row, (SourceStepField)sourceField);
        ((StepInjectionMetaEntry)Mockito.verify((Object)entry)).setValue((Object)true);
    }

    @Test
    public void setEntryValue_integer() throws KettleValueException {
        StepInjectionMetaEntry entry = (StepInjectionMetaEntry)Mockito.mock(StepInjectionMetaEntry.class);
        ((StepInjectionMetaEntry)Mockito.doReturn((Object)5).when((Object)entry)).getValueType();
        RowMetaAndData row = MetaInjectTest.createRowMetaAndData((ValueMetaInterface)new ValueMetaInteger(TEST_FIELD), new Long(1L));
        SourceStepField sourceField = new SourceStepField(TEST_SOURCE_STEP_NAME, TEST_FIELD);
        MetaInject.setEntryValue((StepInjectionMetaEntry)entry, (RowMetaAndData)row, (SourceStepField)sourceField);
        ((StepInjectionMetaEntry)Mockito.verify((Object)entry)).setValue((Object)1L);
    }

    @Test
    public void setEntryValue_number() throws KettleValueException {
        StepInjectionMetaEntry entry = (StepInjectionMetaEntry)Mockito.mock(StepInjectionMetaEntry.class);
        ((StepInjectionMetaEntry)Mockito.doReturn((Object)1).when((Object)entry)).getValueType();
        RowMetaAndData row = MetaInjectTest.createRowMetaAndData((ValueMetaInterface)new ValueMetaNumber(TEST_FIELD), new Double(1.0));
        SourceStepField sourceField = new SourceStepField(TEST_SOURCE_STEP_NAME, TEST_FIELD);
        MetaInject.setEntryValue((StepInjectionMetaEntry)entry, (RowMetaAndData)row, (SourceStepField)sourceField);
        ((StepInjectionMetaEntry)Mockito.verify((Object)entry)).setValue((Object)1.0);
    }

    @Test
    public void setEntryValue_date() throws KettleValueException {
        StepInjectionMetaEntry entry = (StepInjectionMetaEntry)Mockito.mock(StepInjectionMetaEntry.class);
        ((StepInjectionMetaEntry)Mockito.doReturn((Object)3).when((Object)entry)).getValueType();
        RowMetaAndData row = MetaInjectTest.createRowMetaAndData((ValueMetaInterface)new ValueMetaDate(TEST_FIELD), null);
        SourceStepField sourceField = new SourceStepField(TEST_SOURCE_STEP_NAME, TEST_FIELD);
        MetaInject.setEntryValue((StepInjectionMetaEntry)entry, (RowMetaAndData)row, (SourceStepField)sourceField);
        ((StepInjectionMetaEntry)Mockito.verify((Object)entry)).setValue(null);
    }

    @Test
    public void setEntryValue_bignumber() throws KettleValueException {
        StepInjectionMetaEntry entry = (StepInjectionMetaEntry)Mockito.mock(StepInjectionMetaEntry.class);
        ((StepInjectionMetaEntry)Mockito.doReturn((Object)6).when((Object)entry)).getValueType();
        RowMetaAndData row = MetaInjectTest.createRowMetaAndData((ValueMetaInterface)new ValueMetaBigNumber(TEST_FIELD), new BigDecimal(1));
        SourceStepField sourceField = new SourceStepField(TEST_SOURCE_STEP_NAME, TEST_FIELD);
        MetaInject.setEntryValue((StepInjectionMetaEntry)entry, (RowMetaAndData)row, (SourceStepField)sourceField);
        ((StepInjectionMetaEntry)Mockito.verify((Object)entry)).setValue((Object)new BigDecimal(1));
    }

    @Test
    public void convertToUpperCaseSet_null_array() {
        Set actualResult = MetaInject.convertToUpperCaseSet(null);
        Assert.assertNotNull((Object)actualResult);
        Assert.assertTrue((boolean)actualResult.isEmpty());
    }

    @Test
    public void convertToUpperCaseSet() {
        String[] input = new String[]{"Test_Step", "test_step1"};
        Set actualResult = MetaInject.convertToUpperCaseSet((String[])input);
        HashSet<String> expectedResult = new HashSet<String>();
        expectedResult.add("TEST_STEP");
        expectedResult.add("TEST_STEP1");
        Assert.assertEquals(expectedResult, (Object)actualResult);
    }

    private static RowMetaAndData createRowMetaAndData(ValueMetaInterface valueMeta, Object data) {
        RowMetaAndData row = new RowMetaAndData();
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta(valueMeta);
        row.setRowMeta((RowMetaInterface)rowMeta);
        row.setData(new Object[]{data});
        return row;
    }
}

