/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.metastore.api.IMetaStore;

public class MetaInjectMetaTest {
    private static final String TEST_FILE_NAME = "TEST_FILE_NAME";
    private static final String EXPORTED_FILE_NAME = "${Internal.Transformation.Filename.Directory}/TEST_FILE_NAME";
    private MetaInjectMeta metaInjectMeta;

    @Before
    public void before() {
        this.metaInjectMeta = new MetaInjectMeta();
    }

    @Test
    public void getResourceDependencies() {
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        List actualResult = this.metaInjectMeta.getResourceDependencies(transMeta, stepMeta);
        Assert.assertEquals((long)1L, (long)actualResult.size());
        ResourceReference reference = (ResourceReference)actualResult.iterator().next();
        Assert.assertEquals((long)0L, (long)reference.getEntries().size());
    }

    @Test
    public void getResourceDependencies_with_defined_fileName() {
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        this.metaInjectMeta.setFileName("FILE_NAME");
        ((TransMeta)Mockito.doReturn((Object)"FILE_NAME_WITH_SUBSTITUTIONS").when((Object)transMeta)).environmentSubstitute("FILE_NAME");
        List actualResult = this.metaInjectMeta.getResourceDependencies(transMeta, stepMeta);
        Assert.assertEquals((long)1L, (long)actualResult.size());
        ResourceReference reference = (ResourceReference)actualResult.iterator().next();
        Assert.assertEquals((long)1L, (long)reference.getEntries().size());
    }

    @Test
    public void getResourceDependencies_with_defined_transName() {
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        this.metaInjectMeta.setTransName("TRANS_NAME");
        ((TransMeta)Mockito.doReturn((Object)"TRANS_NAME_WITH_SUBSTITUTIONS").when((Object)transMeta)).environmentSubstitute("TRANS_NAME");
        List actualResult = this.metaInjectMeta.getResourceDependencies(transMeta, stepMeta);
        Assert.assertEquals((long)1L, (long)actualResult.size());
        ResourceReference reference = (ResourceReference)actualResult.iterator().next();
        Assert.assertEquals((long)1L, (long)reference.getEntries().size());
    }

    @Test
    public void exportResources() throws KettleException {
        VariableSpace variableSpace = (VariableSpace)Mockito.mock(VariableSpace.class);
        ResourceNamingInterface resourceNamingInterface = (ResourceNamingInterface)Mockito.mock(ResourceNamingInterface.class);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        MetaInjectMeta injectMetaSpy = (MetaInjectMeta)Mockito.spy((Object)this.metaInjectMeta);
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Map definitions = Collections.emptyMap();
        ((TransMeta)Mockito.doReturn((Object)TEST_FILE_NAME).when((Object)transMeta)).exportResources((VariableSpace)transMeta, definitions, resourceNamingInterface, repository, metaStore);
        ((MetaInjectMeta)Mockito.doReturn((Object)transMeta).when((Object)injectMetaSpy)).loadTransformationMeta(repository, variableSpace);
        String actualExportedFileName = injectMetaSpy.exportResources(variableSpace, definitions, resourceNamingInterface, repository, metaStore);
        Assert.assertEquals((Object)TEST_FILE_NAME, (Object)actualExportedFileName);
        Assert.assertEquals((Object)EXPORTED_FILE_NAME, (Object)injectMetaSpy.getFileName());
        ((TransMeta)Mockito.verify((Object)transMeta)).exportResources((VariableSpace)transMeta, definitions, resourceNamingInterface, repository, metaStore);
    }
}

