/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappinginput;

import java.util.Collections;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappinginput.MappingInputData;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.validator.Validator;
import org.pentaho.di.trans.steps.validator.ValidatorData;

public class MappingInputTest {
    private String stepName = "MAPPING INPUT";
    private StepMockHelper<MappingInputMeta, MappingInputData> stepMockHelper;
    private volatile boolean processRowEnded;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<MappingInputMeta, MappingInputData>(this.stepName, MappingInputMeta.class, MappingInputData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        this.setProcessRowEnded(false);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper = null;
    }

    @Test
    public void testSetConnectorSteps() throws Exception {
        Mockito.when((Object)this.stepMockHelper.transMeta.getSizeRowset()).thenReturn((Object)1);
        MappingInputData mappingInputData = new MappingInputData();
        MappingInput mappingInput = new MappingInput(this.stepMockHelper.stepMeta, (StepDataInterface)mappingInputData, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        mappingInput.init(this.stepMockHelper.initStepMetaInterface, (StepDataInterface)mappingInputData);
        ValidatorData validatorData = new ValidatorData();
        Validator previousStep = new Validator(this.stepMockHelper.stepMeta, (StepDataInterface)validatorData, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        Mockito.when((Object)this.stepMockHelper.stepMeta.isDoingErrorHandling()).thenReturn((Object)true);
        StepErrorMeta stepErrorMeta = (StepErrorMeta)Mockito.mock(StepErrorMeta.class);
        Mockito.when((Object)stepErrorMeta.getTargetStep()).thenReturn((Object)this.stepMockHelper.stepMeta);
        Mockito.when((Object)this.stepMockHelper.stepMeta.getName()).thenReturn((Object)this.stepName);
        Mockito.when((Object)this.stepMockHelper.stepMeta.getStepErrorMeta()).thenReturn((Object)stepErrorMeta);
        StepInterface[] si = new StepInterface[]{previousStep};
        mappingInput.setConnectorSteps(si, Collections.emptyList(), this.stepName);
        Assert.assertEquals((int)previousStep.getOutputRowSets().size(), (int)0);
    }

    @Test
    public void testSetConnectorStepsWithNullArguments() throws Exception {
        try {
            final MappingInputData mappingInputData = new MappingInputData();
            final MappingInput mappingInput = new MappingInput(this.stepMockHelper.stepMeta, (StepDataInterface)mappingInputData, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
            mappingInput.init(this.stepMockHelper.initStepMetaInterface, (StepDataInterface)mappingInputData);
            int timeOut = 1000;
            int junitMaxTimeOut = 40000;
            mappingInput.setTimeOut(timeOut);
            final MappingInputTest mit = this;
            Thread processRow = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        mappingInput.processRow(((MappingInputTest)MappingInputTest.this).stepMockHelper.initStepMetaInterface, (StepDataInterface)mappingInputData);
                        mit.setProcessRowEnded(true);
                    }
                    catch (KettleException e) {
                        mit.setProcessRowEnded(true);
                    }
                }
            });
            processRow.start();
            boolean exception = false;
            try {
                mappingInput.setConnectorSteps(null, Collections.emptyList(), "");
            }
            catch (IllegalArgumentException ex1) {
                try {
                    mappingInput.setConnectorSteps(new StepInterface[0], null, "");
                }
                catch (IllegalArgumentException ex3) {
                    try {
                        mappingInput.setConnectorSteps(new StepInterface[]{(StepInterface)Mockito.mock(StepInterface.class)}, Collections.emptyList(), null);
                    }
                    catch (IllegalArgumentException ignored) {
                        exception = true;
                    }
                }
            }
            processRow.join(40000L);
            Assert.assertTrue((String)"not enough IllegalArgumentExceptions", (boolean)exception);
            Assert.assertTrue((String)"Process wasn`t stopped at null", (boolean)this.isProcessRowEnded());
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"Null values are not suitable");
        }
    }

    public void setProcessRowEnded(boolean processRowEnded) {
        this.processRowEnded = processRowEnded;
    }

    public boolean isProcessRowEnded() {
        return this.processRowEnded;
    }
}

