/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.job.entries.getpop.MailConnectionMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailinput.MailInput;
import org.pentaho.di.trans.steps.mailinput.MailInputData;
import org.pentaho.di.trans.steps.mailinput.MailInputMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class MailInputTest {
    private StepMockHelper<MailInputMeta, MailInputData> mockHelper;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<MailInputMeta, MailInputData>("MailInput", MailInputMeta.class, MailInputData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @Test
    public void testInitSetGetFirstForIMAP() {
        MailInput step = new MailInput(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        MailInputData data = new MailInputData();
        MailInputMeta meta = (MailInputMeta)Mockito.mock(MailInputMeta.class);
        Mockito.when((Object)meta.isDynamicFolder()).thenReturn((Object)false);
        Mockito.when((Object)meta.getProtocol()).thenReturn((Object)"IMAP");
        Mockito.when((Object)meta.getFirstIMAPMails()).thenReturn((Object)"2");
        Mockito.when((Object)meta.getFirstMails()).thenReturn((Object)"3");
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((String)"Row Limit is set up to 2 rows.", (long)2L, (long)data.rowlimit);
    }

    @Test
    public void testInitSetGetFirstForPOP3() {
        MailInput step = new MailInput(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        MailInputData data = new MailInputData();
        MailInputMeta meta = (MailInputMeta)Mockito.mock(MailInputMeta.class);
        Mockito.when((Object)meta.isDynamicFolder()).thenReturn((Object)false);
        Mockito.when((Object)meta.getProtocol()).thenReturn((Object)"POP3");
        Mockito.when((Object)meta.getFirstIMAPMails()).thenReturn((Object)"2");
        Mockito.when((Object)meta.getFirstMails()).thenReturn((Object)"3");
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((String)"Row Limit is set up to 3 rows.", (long)3L, (long)data.rowlimit);
    }

    @Test
    public void testInitSetGetFirstLimitOverride() {
        MailInput step = new MailInput(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        MailInputData data = new MailInputData();
        MailInputMeta meta = (MailInputMeta)Mockito.mock(MailInputMeta.class);
        Mockito.when((Object)meta.isDynamicFolder()).thenReturn((Object)false);
        Mockito.when((Object)meta.getProtocol()).thenReturn((Object)"POP3");
        Mockito.when((Object)meta.getFirstIMAPMails()).thenReturn((Object)"2");
        Mockito.when((Object)meta.getFirstMails()).thenReturn((Object)"3");
        Mockito.when((Object)meta.getRowLimit()).thenReturn((Object)"5");
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((String)"Row Limit is set up to 5 rows as the Limit has priority.", (long)5L, (long)data.rowlimit);
    }

    @Test
    public void testInitSetGetFirstForMBOXIgnored() {
        MailInput step = new MailInput(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        MailInputData data = new MailInputData();
        MailInputMeta meta = (MailInputMeta)Mockito.mock(MailInputMeta.class);
        Mockito.when((Object)meta.isDynamicFolder()).thenReturn((Object)false);
        Mockito.when((Object)meta.getProtocol()).thenReturn((Object)MailConnectionMeta.PROTOCOL_STRING_MBOX);
        Mockito.when((Object)meta.getFirstIMAPMails()).thenReturn((Object)"2");
        Mockito.when((Object)meta.getFirstMails()).thenReturn((Object)"3");
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((String)"Row Limit is set up to 0 rows as the Limit has priority.", (long)0L, (long)data.rowlimit);
    }
}

