/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.trans.steps.mailinput.BatchFolderIterator;

public class BatchFolderIteratorName {
    static Folder folder = null;

    @BeforeClass
    public static void setUp() throws MessagingException {
        folder = (Folder)Mockito.mock(Folder.class);
        Mockito.when((Object)folder.getName()).thenReturn((Object)"INBOX");
        Mockito.when((Object)folder.getMessages(Matchers.anyInt(), Matchers.anyInt())).thenAnswer((Answer)new Answer<Message[]>(){

            public Message[] answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                int start = (Integer)args[0];
                int end = (Integer)args[1];
                return new Message[end - start + 1];
            }
        });
    }

    @Test
    public void testBatchSize2() {
        BatchFolderIterator bfi = new BatchFolderIterator(folder, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2));
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertFalse((boolean)bfi.hasNext());
    }

    @Test
    public void testBatchSize1x2() {
        BatchFolderIterator bfi = new BatchFolderIterator(folder, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(2));
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertFalse((boolean)bfi.hasNext());
    }

    @Test
    public void testBatchSize1() {
        BatchFolderIterator bfi = new BatchFolderIterator(folder, Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(1));
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertFalse((boolean)bfi.hasNext());
    }

    @Test
    public void testBatchSize2x2() {
        BatchFolderIterator bfi = new BatchFolderIterator(folder, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(4));
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertFalse((boolean)bfi.hasNext());
    }

    @Test
    public void testBatchSize2x3() {
        BatchFolderIterator bfi = new BatchFolderIterator(folder, Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(5));
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertTrue((boolean)bfi.hasNext());
        bfi.next();
        Assert.assertFalse((boolean)bfi.hasNext());
    }
}

