/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadsave;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.AbstractRepository;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.IRepositoryImporter;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;

public class MemoryRepository
extends AbstractRepository {
    private final Map<ObjectId, Map<Integer, Map<String, String>>> stepAttributeMap = new HashMap<ObjectId, Map<Integer, Map<String, String>>>();
    private final Map<ObjectId, Map<Integer, Map<String, String>>> jobAttributeMap = new HashMap<ObjectId, Map<Integer, Map<String, String>>>();

    public MemoryRepository() {
    }

    private void populateMap(Map<ObjectId, Map<Integer, Map<String, String>>> attributeMap, JSONObject jsonObject) {
        for (Object objectId : jsonObject.keySet()) {
            JSONObject nrsObject = (JSONObject)jsonObject.get(objectId);
            for (Object nrKey : nrsObject.keySet()) {
                JSONObject nrObject = (JSONObject)nrsObject.get(nrKey);
                for (Object stringKey : nrObject.keySet()) {
                    this.setAttribute(attributeMap, (ObjectId)new StringObjectId(objectId.toString()), Integer.valueOf(nrKey.toString()), stringKey.toString(), nrObject.get(stringKey).toString());
                }
            }
        }
    }

    public MemoryRepository(String json) throws ParseException {
        Object repoObj = new JSONParser().parse(json);
        JSONObject jsonRepoObj = (JSONObject)repoObj;
        this.populateMap(this.stepAttributeMap, (JSONObject)jsonRepoObj.get((Object)"step"));
        this.populateMap(this.jobAttributeMap, (JSONObject)jsonRepoObj.get((Object)"job"));
    }

    private String getAttribute(Map<ObjectId, Map<Integer, Map<String, String>>> attributeMap, ObjectId id, int nr, String code, String def) {
        Map<String, String> numberMap;
        String value = null;
        Map<Integer, Map<String, String>> stepMap = attributeMap.get(id);
        if (stepMap != null && (numberMap = stepMap.get(nr)) != null) {
            value = numberMap.get(code);
        }
        return value == null ? def : value;
    }

    private void setAttribute(Map<ObjectId, Map<Integer, Map<String, String>>> attributeMap, ObjectId id, int nr, String code, String value) {
        Map<String, String> numberMap;
        Map<Integer, Map<String, String>> stepMap = attributeMap.get(id);
        if (stepMap == null) {
            stepMap = new HashMap<Integer, Map<String, String>>();
            attributeMap.put(id, stepMap);
        }
        if ((numberMap = stepMap.get(nr)) == null) {
            numberMap = new HashMap<String, String>();
            stepMap.put(nr, numberMap);
        }
        numberMap.put(code, value);
    }

    private String getStepAttribute(ObjectId id_step, int nr, String code, String def) {
        return this.getAttribute(this.stepAttributeMap, id_step, nr, code, def);
    }

    private void setStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, String value) {
        this.setAttribute(this.stepAttributeMap, id_step, nr, code, value);
    }

    private String getJobAttribute(ObjectId id_job, int nr, String code, String def) {
        return this.getAttribute(this.jobAttributeMap, id_job, nr, code, def);
    }

    private void setJobAttribute(ObjectId id_job, int nr, String code, String value) {
        this.setAttribute(this.jobAttributeMap, id_job, nr, code, value);
    }

    public String getName() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public RepositoryMeta getRepositoryMeta() {
        return null;
    }

    public IUser getUserInfo() {
        return null;
    }

    public RepositorySecurityProvider getSecurityProvider() {
        return null;
    }

    public RepositorySecurityManager getSecurityManager() {
        return null;
    }

    public LogChannelInterface getLog() {
        return null;
    }

    public void connect(String username, String password) throws KettleException, KettleSecurityException {
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return false;
    }

    public void init(RepositoryMeta repositoryMeta) {
    }

    public boolean exists(String name, RepositoryDirectoryInterface repositoryDirectory, RepositoryObjectType objectType) throws KettleException {
        return false;
    }

    public ObjectId getTransformationID(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        return null;
    }

    public ObjectId getJobId(String name, RepositoryDirectoryInterface repositoryDirectory) throws KettleException {
        return null;
    }

    public void save(RepositoryElementInterface repositoryElement, String versionComment, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
    }

    public void save(RepositoryElementInterface repositoryElement, String versionComment, Calendar versionDate, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
    }

    public RepositoryDirectoryInterface getDefaultSaveDirectory(RepositoryElementInterface repositoryElement) throws KettleException {
        return null;
    }

    public RepositoryDirectoryInterface getUserHomeDirectory() throws KettleException {
        return null;
    }

    public void clearSharedObjectCache() {
    }

    public TransMeta loadTransformation(String transname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor, boolean setInternalVariables, String revision) throws KettleException {
        return null;
    }

    public TransMeta loadTransformation(ObjectId id_transformation, String versionLabel) throws KettleException {
        return null;
    }

    public SharedObjects readTransSharedObjects(TransMeta transMeta) throws KettleException {
        return null;
    }

    public ObjectId renameTransformation(ObjectId id_transformation, RepositoryDirectoryInterface newDirectory, String newName) throws KettleException {
        return null;
    }

    public ObjectId renameTransformation(ObjectId id_transformation, String versionComment, RepositoryDirectoryInterface newDirectory, String newName) throws KettleException {
        return null;
    }

    public void deleteTransformation(ObjectId id_transformation) throws KettleException {
    }

    public JobMeta loadJob(String jobname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor, String revision) throws KettleException {
        return null;
    }

    public JobMeta loadJob(ObjectId id_job, String versionLabel) throws KettleException {
        return null;
    }

    public SharedObjects readJobMetaSharedObjects(JobMeta jobMeta) throws KettleException {
        return null;
    }

    public ObjectId renameJob(ObjectId id_job, RepositoryDirectoryInterface newDirectory, String newName) throws KettleException {
        return null;
    }

    public ObjectId renameJob(ObjectId id_job, String versionComment, RepositoryDirectoryInterface newDirectory, String newName) throws KettleException {
        return null;
    }

    public void deleteJob(ObjectId id_job) throws KettleException {
    }

    public DatabaseMeta loadDatabaseMeta(ObjectId id_database, String revision) throws KettleException {
        return null;
    }

    public void deleteDatabaseMeta(String databaseName) throws KettleException {
    }

    public ObjectId[] getDatabaseIDs(boolean includeDeleted) throws KettleException {
        return null;
    }

    public String[] getDatabaseNames(boolean includeDeleted) throws KettleException {
        return null;
    }

    public List<DatabaseMeta> readDatabases() throws KettleException {
        return null;
    }

    public ObjectId getDatabaseID(String name) throws KettleException {
        return null;
    }

    public ClusterSchema loadClusterSchema(ObjectId id_cluster_schema, List<SlaveServer> slaveServers, String versionLabel) throws KettleException {
        return null;
    }

    public ObjectId[] getClusterIDs(boolean includeDeleted) throws KettleException {
        return null;
    }

    public String[] getClusterNames(boolean includeDeleted) throws KettleException {
        return null;
    }

    public ObjectId getClusterID(String name) throws KettleException {
        return null;
    }

    public void deleteClusterSchema(ObjectId id_cluster) throws KettleException {
    }

    public SlaveServer loadSlaveServer(ObjectId id_slave_server, String versionLabel) throws KettleException {
        return null;
    }

    public ObjectId[] getSlaveIDs(boolean includeDeleted) throws KettleException {
        return null;
    }

    public String[] getSlaveNames(boolean includeDeleted) throws KettleException {
        return null;
    }

    public List<SlaveServer> getSlaveServers() throws KettleException {
        return null;
    }

    public ObjectId getSlaveID(String name) throws KettleException {
        return null;
    }

    public void deleteSlave(ObjectId id_slave) throws KettleException {
    }

    public PartitionSchema loadPartitionSchema(ObjectId id_partition_schema, String versionLabel) throws KettleException {
        return null;
    }

    public ObjectId[] getPartitionSchemaIDs(boolean includeDeleted) throws KettleException {
        return null;
    }

    public String[] getPartitionSchemaNames(boolean includeDeleted) throws KettleException {
        return null;
    }

    public ObjectId getPartitionSchemaID(String name) throws KettleException {
        return null;
    }

    public void deletePartitionSchema(ObjectId id_partition_schema) throws KettleException {
    }

    public RepositoryDirectoryInterface loadRepositoryDirectoryTree() throws KettleException {
        return null;
    }

    public RepositoryDirectoryInterface findDirectory(String directory) throws KettleException {
        return null;
    }

    public RepositoryDirectoryInterface findDirectory(ObjectId directory) throws KettleException {
        return null;
    }

    public void saveRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
    }

    public void deleteRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
    }

    public ObjectId renameRepositoryDirectory(ObjectId id, RepositoryDirectoryInterface newParentDir, String newName) throws KettleException {
        return null;
    }

    public RepositoryDirectoryInterface createRepositoryDirectory(RepositoryDirectoryInterface parentDirectory, String directoryPath) throws KettleException {
        return null;
    }

    public String[] getTransformationNames(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return null;
    }

    public List<RepositoryElementMetaInterface> getJobObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return null;
    }

    public List<RepositoryElementMetaInterface> getTransformationObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return null;
    }

    public List<RepositoryElementMetaInterface> getJobAndTransformationObjects(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return null;
    }

    public String[] getJobNames(ObjectId id_directory, boolean includeDeleted) throws KettleException {
        return null;
    }

    public String[] getDirectoryNames(ObjectId id_directory) throws KettleException {
        return null;
    }

    public ObjectId insertLogEntry(String description) throws KettleException {
        return null;
    }

    public void insertStepDatabase(ObjectId id_transformation, ObjectId id_step, ObjectId id_database) throws KettleException {
    }

    public void insertJobEntryDatabase(ObjectId id_job, ObjectId id_jobentry, ObjectId id_database) throws KettleException {
    }

    public void saveConditionStepAttribute(ObjectId id_transformation, ObjectId id_step, String code, Condition condition) throws KettleException {
    }

    public Condition loadConditionFromStepAttribute(ObjectId id_step, String code) throws KettleException {
        return null;
    }

    public boolean getStepAttributeBoolean(ObjectId id_step, int nr, String code, boolean def) throws KettleException {
        return "Y".equalsIgnoreCase(this.getStepAttribute(id_step, nr, code, def ? "Y" : "N"));
    }

    public long getStepAttributeInteger(ObjectId id_step, int nr, String code) throws KettleException {
        return Long.valueOf(this.getStepAttribute(id_step, nr, code, "0"));
    }

    public String getStepAttributeString(ObjectId id_step, int nr, String code) throws KettleException {
        return this.getStepAttribute(id_step, nr, code, null);
    }

    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, String value) throws KettleException {
        this.setStepAttribute(id_transformation, id_step, nr, code, value);
    }

    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, boolean value) throws KettleException {
        this.setStepAttribute(id_transformation, id_step, nr, code, value ? "Y" : "N");
    }

    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, long value) throws KettleException {
        this.setStepAttribute(id_transformation, id_step, nr, code, Long.toString(value));
    }

    public void saveStepAttribute(ObjectId id_transformation, ObjectId id_step, int nr, String code, double value) throws KettleException {
        this.setStepAttribute(id_transformation, id_step, nr, code, Double.toString(value));
    }

    public int countNrStepAttributes(ObjectId id_step, String code) throws KettleException {
        Map<Integer, Map<String, String>> stepMap = this.stepAttributeMap.get(id_step);
        int count = 0;
        if (stepMap != null) {
            for (Map.Entry<Integer, Map<String, String>> entry : stepMap.entrySet()) {
                Map<String, String> value = entry.getValue();
                if (value == null || value.get(code) == null) continue;
                ++count;
            }
        }
        return count;
    }

    public int countNrJobEntryAttributes(ObjectId id_jobentry, String code) throws KettleException {
        Map<Integer, Map<String, String>> jobMap = this.jobAttributeMap.get(id_jobentry);
        int count = 0;
        if (jobMap != null) {
            for (Map.Entry<Integer, Map<String, String>> entry : jobMap.entrySet()) {
                Map<String, String> value = entry.getValue();
                if (value == null || value.get(code) == null) continue;
                ++count;
            }
        }
        return count;
    }

    public long getJobEntryAttributeInteger(ObjectId id_jobentry, int nr, String code) throws KettleException {
        return Long.parseLong(this.getJobAttribute(id_jobentry, nr, code, "0"));
    }

    public String getJobEntryAttributeString(ObjectId id_jobentry, int nr, String code) throws KettleException {
        return this.getJobAttribute(id_jobentry, nr, code, null);
    }

    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, String value) throws KettleException {
        this.setJobAttribute(id_jobentry, nr, code, value);
    }

    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, boolean value) throws KettleException {
        this.setJobAttribute(id_jobentry, nr, code, value ? "Y" : "N");
    }

    public void saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String code, long value) throws KettleException {
        this.setJobAttribute(id_jobentry, nr, code, Long.toString(value));
    }

    public DatabaseMeta loadDatabaseMetaFromStepAttribute(ObjectId id_step, String code, List<DatabaseMeta> databases) throws KettleException {
        return null;
    }

    public void saveDatabaseMetaStepAttribute(ObjectId id_transformation, ObjectId id_step, String code, DatabaseMeta database) throws KettleException {
    }

    public DatabaseMeta loadDatabaseMetaFromJobEntryAttribute(ObjectId id_jobentry, String nameCode, int nr, String idCode, List<DatabaseMeta> databases) throws KettleException {
        return null;
    }

    public void saveDatabaseMetaJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, int nr, String nameCode, String idCode, DatabaseMeta database) throws KettleException {
    }

    public void undeleteObject(RepositoryElementMetaInterface repositoryObject) throws KettleException {
    }

    public List<Class<? extends IRepositoryService>> getServiceInterfaces() throws KettleException {
        return null;
    }

    public IRepositoryService getService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return null;
    }

    public boolean hasService(Class<? extends IRepositoryService> clazz) throws KettleException {
        return false;
    }

    public RepositoryObject getObjectInformation(ObjectId objectId, RepositoryObjectType objectType) throws KettleException {
        return null;
    }

    public String getConnectMessage() {
        return null;
    }

    public String[] getJobsUsingDatabase(ObjectId id_database) throws KettleException {
        return null;
    }

    public String[] getTransformationsUsingDatabase(ObjectId id_database) throws KettleException {
        return null;
    }

    public IRepositoryImporter getImporter() {
        return null;
    }

    public IRepositoryExporter getExporter() {
        return null;
    }

    public IMetaStore getMetaStore() {
        return null;
    }

    public boolean getJobEntryAttributeBoolean(ObjectId id_jobentry, int nr, String code, boolean def) throws KettleException {
        return "Y".equalsIgnoreCase(this.getJobAttribute(id_jobentry, nr, code, def ? "Y" : "N"));
    }
}

