/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldapinput.LDAPInput;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputData;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputField;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputMeta;
import org.pentaho.di.trans.steps.ldapinput.LdapMockProtocol;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class LDAPInputTest {
    private static StepMockHelper<LDAPInputMeta, LDAPInputData> stepMockHelper;

    @BeforeClass
    public static void setup() {
        stepMockHelper = new StepMockHelper<LDAPInputMeta, LDAPInputData>("LDAP INPUT TEST", LDAPInputMeta.class, LDAPInputData.class);
        Mockito.when((Object)LDAPInputTest.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)LDAPInputTest.stepMockHelper.logChannelInterface);
        Mockito.when((Object)LDAPInputTest.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    private LDAPInputMeta mockMeta() {
        LDAPInputMeta meta = (LDAPInputMeta)Mockito.mock(LDAPInputMeta.class);
        return meta;
    }

    @AfterClass
    public static void tearDown() {
        stepMockHelper.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowProcessing() throws Exception {
        LDAPInput ldapInput = new LDAPInput(LDAPInputTest.stepMockHelper.stepMeta, LDAPInputTest.stepMockHelper.stepDataInterface, 0, LDAPInputTest.stepMockHelper.transMeta, LDAPInputTest.stepMockHelper.trans);
        LDAPInputData data = new LDAPInputData();
        LDAPInputMeta meta = this.mockMeta();
        LDAPInputField[] fields = new LDAPInputField[]{new LDAPInputField("dn"), new LDAPInputField("cn"), new LDAPInputField("role")};
        int sortedField = 1;
        fields[sortedField].setSortedKey(true);
        Mockito.when((Object)meta.getInputFields()).thenReturn((Object)fields);
        Mockito.when((Object)meta.getProtocol()).thenReturn((Object)LdapMockProtocol.getName());
        Mockito.when((Object)meta.getHost()).thenReturn((Object)"host.mock");
        Mockito.when((Object)meta.getDerefAliases()).thenReturn((Object)"never");
        Mockito.when((Object)meta.getReferrals()).thenReturn((Object)"ignore");
        LdapMockProtocol.setup();
        try {
            Assert.assertTrue((String)"Input Initialization Failed", (boolean)ldapInput.init((StepMetaInterface)meta, (StepDataInterface)data));
            Assert.assertEquals((String)"Field not marked as sorted", (long)1L, (long)data.connection.getSortingAttributes().size());
            Assert.assertEquals((String)"Field not marked as sorted", (Object)data.attrReturned[sortedField], data.connection.getSortingAttributes().get(0));
            Assert.assertNotNull((Object)data.attrReturned[sortedField]);
        }
        finally {
            LdapMockProtocol.cleanup();
        }
    }
}

