/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.groupby;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.groupby.GroupBy;
import org.pentaho.di.trans.steps.groupby.GroupByData;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.metastore.api.IMetaStore;

public class GroupByTest
extends TestCase {
    private StepMockHelper<GroupByMeta, GroupByData> mockHelper;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<GroupByMeta, GroupByData>("Group By", GroupByMeta.class, GroupByData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() throws Exception {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testProcessRow() throws KettleException {
        GroupByMeta groupByMeta = (GroupByMeta)Mockito.mock(GroupByMeta.class);
        GroupByData groupByData = (GroupByData)Mockito.mock(GroupByData.class);
        GroupBy groupBySpy = (GroupBy)Mockito.spy((Object)new GroupBy(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans));
        ((GroupBy)Mockito.doReturn(null).when((Object)groupBySpy)).getRow();
        ((GroupBy)Mockito.doReturn(null).when((Object)groupBySpy)).getInputRowMeta();
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ROWNR", 5));
        ArrayList<BlockingRowSet> outputRowSets = new ArrayList<BlockingRowSet>();
        BlockingRowSet rowSet = new BlockingRowSet(1);
        rowSet.putRow((RowMetaInterface)rowMeta, new Object[]{new Long(0L)});
        outputRowSets.add(rowSet);
        groupBySpy.setOutputRowSets(outputRowSets);
        String[] sub = new String[]{"b"};
        ((GroupByMeta)Mockito.doReturn((Object)sub).when((Object)groupByMeta)).getSubjectField();
        String[] groupField = new String[]{"a"};
        ((GroupByMeta)Mockito.doReturn((Object)groupField).when((Object)groupByMeta)).getGroupField();
        String[] aggFields = new String[]{"b_g"};
        ((GroupByMeta)Mockito.doReturn((Object)aggFields).when((Object)groupByMeta)).getAggregateField();
        int[] aggType = new int[]{8};
        ((GroupByMeta)Mockito.doReturn((Object)aggType).when((Object)groupByMeta)).getAggregateType();
        Mockito.when((Object)this.mockHelper.transMeta.getPrevStepFields(this.mockHelper.stepMeta)).thenReturn((Object)new RowMeta());
        groupBySpy.processRow((StepMetaInterface)groupByMeta, (StepDataInterface)groupByData);
        GroupByTest.assertTrue((boolean)((RowSet)groupBySpy.getOutputRowSets().get(0)).isDone());
    }

    @Test
    public void testGetFields() {
        RowMeta outputFields = new RowMeta();
        outputFields.addValueMeta((ValueMetaInterface)new ValueMetaString("group_by_field"));
        outputFields.addValueMeta((ValueMetaInterface)new ValueMetaInteger("raw_integer"));
        outputFields.addValueMeta((ValueMetaInterface)new ValueMetaString("raw_string"));
        GroupByMeta meta = new GroupByMeta();
        meta.allocate(1, 8);
        meta.setGroupField(new String[]{"group_by_field"});
        meta.setAggregateField(new String[]{"perc_field", "stddev_field", "median_field", "count_distinct_field", "count_any_field", "count_all_field", "concat_comma_field", "concat_custom_field"});
        meta.setSubjectField(new String[]{"raw_integer", "raw_integer", "raw_integer", "raw_integer", "raw_integer", "raw_integer", "raw_string", "raw_string"});
        meta.setAggregateType(new int[]{4, 15, 3, 17, 18, 7, 8, 16});
        meta.getFields((RowMetaInterface)outputFields, "Group By Step", (RowMetaInterface[])null, (StepMeta)null, (VariableSpace)((Variables)null), (Repository)null, (IMetaStore)null);
        GroupByTest.assertEquals((int)outputFields.getValueMetaList().size(), (int)9);
        GroupByTest.assertTrue((outputFields.getValueMeta(0).getType() == 2 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(0).getName().equals("group_by_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(1).getType() == 1 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(1).getName().equals("perc_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(2).getType() == 1 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(2).getName().equals("stddev_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(3).getType() == 1 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(3).getName().equals("median_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(4).getType() == 5 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(4).getName().equals("count_distinct_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(5).getType() == 5 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(5).getName().equals("count_any_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(6).getType() == 5 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(6).getName().equals("count_all_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(7).getType() == 2 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(7).getName().equals("concat_comma_field"));
        GroupByTest.assertTrue((outputFields.getValueMeta(8).getType() == 2 ? 1 : 0) != 0);
        GroupByTest.assertTrue((boolean)outputFields.getValueMeta(8).getName().equals("concat_custom_field"));
    }
}

