/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getsubfolders;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.steps.getsubfolders.GetSubFoldersMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class GetSubFoldersMetaTest {
    @Test
    public void getFieldsTest() throws KettleStepException {
        GetSubFoldersMeta stepMeta = new GetSubFoldersMeta();
        String stepName = UUID.randomUUID().toString();
        RowMeta rowMeta = new RowMeta();
        stepMeta.getFields((RowMetaInterface)rowMeta, stepName, null, null, (VariableSpace)new Variables(), null, null);
        Assert.assertFalse((boolean)stepMeta.includeRowNumber());
        Assert.assertEquals((long)10L, (long)rowMeta.size());
        Assert.assertEquals((Object)"folderName", (Object)rowMeta.getValueMeta(0).getName());
        Assert.assertEquals((Object)"short_folderName", (Object)rowMeta.getValueMeta(1).getName());
        Assert.assertEquals((Object)"path", (Object)rowMeta.getValueMeta(2).getName());
        Assert.assertEquals((Object)"ishidden", (Object)rowMeta.getValueMeta(3).getName());
        Assert.assertEquals((Object)"isreadable", (Object)rowMeta.getValueMeta(4).getName());
        Assert.assertEquals((Object)"iswriteable", (Object)rowMeta.getValueMeta(5).getName());
        Assert.assertEquals((Object)"lastmodifiedtime", (Object)rowMeta.getValueMeta(6).getName());
        Assert.assertEquals((Object)"uri", (Object)rowMeta.getValueMeta(7).getName());
        Assert.assertEquals((Object)"rooturi", (Object)rowMeta.getValueMeta(8).getName());
        Assert.assertEquals((Object)"childrens", (Object)rowMeta.getValueMeta(9).getName());
        stepMeta.setIncludeRowNumber(true);
        rowMeta = new RowMeta();
        stepMeta.getFields((RowMetaInterface)rowMeta, stepName, null, null, (VariableSpace)new Variables(), null, null);
        Assert.assertTrue((boolean)stepMeta.includeRowNumber());
        Assert.assertEquals((long)11L, (long)rowMeta.size());
        Assert.assertEquals((Object)"folderName", (Object)rowMeta.getValueMeta(0).getName());
        Assert.assertEquals((Object)"short_folderName", (Object)rowMeta.getValueMeta(1).getName());
        Assert.assertEquals((Object)"path", (Object)rowMeta.getValueMeta(2).getName());
        Assert.assertEquals((Object)"ishidden", (Object)rowMeta.getValueMeta(3).getName());
        Assert.assertEquals((Object)"isreadable", (Object)rowMeta.getValueMeta(4).getName());
        Assert.assertEquals((Object)"iswriteable", (Object)rowMeta.getValueMeta(5).getName());
        Assert.assertEquals((Object)"lastmodifiedtime", (Object)rowMeta.getValueMeta(6).getName());
        Assert.assertEquals((Object)"uri", (Object)rowMeta.getValueMeta(7).getName());
        Assert.assertEquals((Object)"rooturi", (Object)rowMeta.getValueMeta(8).getName());
        Assert.assertEquals((Object)"childrens", (Object)rowMeta.getValueMeta(9).getName());
        Assert.assertEquals(null, (Object)rowMeta.getValueMeta(10).getName());
        stepMeta.setRowNumberField("MyRowNumber");
        rowMeta = new RowMeta();
        stepMeta.getFields((RowMetaInterface)rowMeta, stepName, null, null, (VariableSpace)new Variables(), null, null);
        Assert.assertEquals((Object)"MyRowNumber", (Object)stepMeta.getRowNumberField());
        Assert.assertEquals((long)11L, (long)rowMeta.size());
        Assert.assertEquals((Object)"MyRowNumber", (Object)rowMeta.getValueMeta(10).getName());
    }

    @Test
    public void loadSaveTest() throws KettleException {
        List<String> attributes = Arrays.asList("rownum", "foldername_dynamic", "rownum_field", "foldername_field", "limit", "name", "file_required");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("rownum", "includeRowNumber");
        getterMap.put("foldername_dynamic", "isFoldernameDynamic");
        getterMap.put("foldername_field", "getDynamicFoldernameField");
        getterMap.put("rownum_field", "getRowNumberField");
        getterMap.put("limit", "getRowLimit");
        getterMap.put("name", "getFolderName");
        getterMap.put("file_required", "getFolderRequired");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("rownum", "setIncludeRowNumber");
        setterMap.put("foldername_dynamic", "setFolderField");
        setterMap.put("foldername_field", "setDynamicFoldernameField");
        setterMap.put("rownum_field", "setRowNumberField");
        setterMap.put("limit", "setRowLimit");
        setterMap.put("name", "setFolderName");
        setterMap.put("file_required", "setFolderRequired");
        HashMap fieldLoadSaveValidatorAttributeMap = new HashMap();
        fieldLoadSaveValidatorAttributeMap.put("file_required", new ArrayLoadSaveValidator<String>(new FileRequiredFieldLoadSaveValidator(), 50));
        HashMap fieldLoadSaveValidatorTypeMap = new HashMap();
        fieldLoadSaveValidatorTypeMap.put(String[].class.getCanonicalName(), new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 50));
        LoadSaveTester tester = new LoadSaveTester(GetSubFoldersMeta.class, attributes, getterMap, setterMap, fieldLoadSaveValidatorAttributeMap, fieldLoadSaveValidatorTypeMap);
        tester.testRepoRoundTrip();
        tester.testXmlRoundTrip();
    }

    public class FileRequiredFieldLoadSaveValidator
    implements FieldLoadSaveValidator<String> {
        @Override
        public String getTestObject() {
            return GetSubFoldersMeta.RequiredFoldersCode[new Random().nextInt(GetSubFoldersMeta.RequiredFoldersCode.length)];
        }

        @Override
        public boolean validateTestObject(String testObject, Object actual) {
            return testObject.equals(actual);
        }
    }
}

