/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import java.util.Date;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fileinput.text.TextFileFilter;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInput;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputData;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class PDI_2875_Test {
    private static StepMockHelper<TextFileInputMeta, TextFileInputData> smh;
    private final String VAR_NAME = "VAR";
    private final String EXPRESSION = "${VAR}";

    @BeforeClass
    public static void setUp() throws KettleException {
        KettleEnvironment.init();
        smh = new StepMockHelper<TextFileInputMeta, TextFileInputData>("CsvInputTest", TextFileInputMeta.class, TextFileInputData.class);
        Mockito.when((Object)PDI_2875_Test.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)PDI_2875_Test.smh.logChannelInterface);
        Mockito.when((Object)PDI_2875_Test.smh.trans.isRunning()).thenReturn((Object)true);
    }

    private TextFileInputMeta getMeta() {
        TextFileInputMeta meta = new TextFileInputMeta();
        meta.allocateFiles(2);
        meta.setFileName(new String[]{"file1.txt", "file2.txt"});
        meta.inputFiles.includeSubFolders = new String[]{"n", "n"};
        meta.setFilter(new TextFileFilter[0]);
        meta.content.fileFormat = "unix";
        meta.content.fileType = "CSV";
        meta.errorHandling.lineNumberFilesDestinationDirectory = "${VAR}";
        meta.errorHandling.errorFilesDestinationDirectory = "${VAR}";
        meta.errorHandling.warningFilesDestinationDirectory = "${VAR}";
        return meta;
    }

    @Test
    public void testVariableSubstitution() {
        ((Trans)Mockito.doReturn((Object)new Date()).when((Object)PDI_2875_Test.smh.trans)).getCurrentDate();
        TextFileInput step = (TextFileInput)Mockito.spy((Object)new TextFileInput(PDI_2875_Test.smh.stepMeta, PDI_2875_Test.smh.stepDataInterface, 0, PDI_2875_Test.smh.transMeta, PDI_2875_Test.smh.trans));
        TextFileInputData data = new TextFileInputData();
        step.setVariable("VAR", "value");
        step.init((StepMetaInterface)this.getMeta(), (StepDataInterface)data);
        ((TextFileInput)Mockito.verify((Object)step, (VerificationMode)Mockito.times((int)2))).environmentSubstitute("${VAR}");
    }
}

