/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputField;

@Ignore(value="No tests in abstract base class")
public abstract class BaseParsingTest<Meta extends StepMetaInterface, Data extends StepDataInterface, Step extends BaseStep> {
    protected LogChannelInterface log = new LogChannel((Object)"junit");
    protected FileSystemManager fs;
    protected String inPrefix;
    protected Meta meta;
    protected Data data;
    protected Step step;
    protected StepMeta stepMeta;
    protected TransMeta transMeta;
    protected Trans trans;
    protected List<Object[]> rows = new ArrayList<Object[]>();
    protected int errorsCount;
    protected RowListener rowListener = new RowListener(){

        public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            BaseParsingTest.this.rows.add(Arrays.copyOf(row, rowMeta.size()));
        }

        public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            System.out.println();
        }

        public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            ++BaseParsingTest.this.errorsCount;
        }
    };

    @Before
    public final void beforeCommon() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
        this.stepMeta = new StepMeta();
        this.stepMeta.setName("test");
        this.trans = new Trans();
        this.trans.setLog(this.log);
        this.trans.setRunning(true);
        this.transMeta = new TransMeta(){

            public StepMeta findStep(String name) {
                return BaseParsingTest.this.stepMeta;
            }
        };
        this.fs = VFS.getManager();
        this.inPrefix = '/' + this.getClass().getPackage().getName().replace('.', '/') + "/files/";
    }

    protected FileObject getFile(String filename) throws Exception {
        URL res = this.getClass().getResource(this.inPrefix + filename);
        Assert.assertNotNull((String)"There is no file", (Object)res);
        FileObject file = this.fs.resolveFile(res.toExternalForm());
        Assert.assertNotNull((String)"There is no file", (Object)file);
        return file;
    }

    protected abstract void setFields(BaseFileInputField ... var1) throws Exception;

    protected void process() throws Exception {
        while (this.step.processRow(this.meta, this.data)) {
        }
    }

    protected void check(Object[][] expected) throws Exception {
        Assert.assertEquals((String)"There are errors", (long)0L, (long)this.errorsCount);
        Assert.assertEquals((String)"There are step errors", (long)0L, (long)this.step.getErrors());
        Assert.assertEquals((String)"Wrong rows count", (long)expected.length, (long)this.rows.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertArrayEquals((String)("Wrong row: " + Arrays.asList(this.rows.get(i))), (Object[])expected[i], (Object[])this.rows.get(i));
        }
    }
}

