/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fieldsplitter;

import java.util.Arrays;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitter;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterData;
import org.pentaho.di.trans.steps.fieldsplitter.FieldSplitterMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.test.util.FieldAccessor;

public class FieldSplitter_EmptyStringVsNull_Test {
    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void emptyAndNullsAreNotDifferent() throws Exception {
        List<Object[]> expected = Arrays.asList({"a", "", "a"}, {"b", null, "b"}, {null});
        this.doTestEmptyStringVsNull(false, expected);
    }

    @Test
    public void emptyAndNullsAreDifferent() throws Exception {
        List<Object[]> expected = Arrays.asList({"a", "", "a"}, {"b", "", "b"}, {null});
        this.doTestEmptyStringVsNull(true, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestEmptyStringVsNull(boolean diffProperty, List<Object[]> expected) throws Exception {
        FieldAccessor.ensureEmptyStringIsNotNull(diffProperty);
        try {
            this.executeAndAssertResults(expected);
        }
        finally {
            FieldAccessor.resetEmptyStringIsNotNull();
        }
    }

    private void executeAndAssertResults(List<Object[]> expected) throws Exception {
        FieldSplitterMeta meta = new FieldSplitterMeta();
        meta.allocate(3);
        meta.setFieldName(new String[]{"s1", "s2", "s3"});
        meta.setFieldType(new int[]{2, 2, 2});
        meta.setSplitField("string");
        meta.setDelimiter(",");
        FieldSplitterData data = new FieldSplitterData();
        FieldSplitter step = this.createAndInitStep(meta, data);
        RowMeta input = new RowMeta();
        input.addValueMeta((ValueMetaInterface)new ValueMetaString("string"));
        step.setInputRowMeta((RowMetaInterface)input);
        step = (FieldSplitter)Mockito.spy((Object)step);
        ((FieldSplitter)Mockito.doReturn((Object)new String[]{"a, ,a"}).doReturn((Object)new String[]{"b,,b"}).doReturn((Object)new String[]{null}).when((Object)step)).getRow();
        List<Object[]> actual = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 3, false);
        TransTestingUtil.assertResult(expected, actual);
    }

    private FieldSplitter createAndInitStep(FieldSplitterMeta meta, FieldSplitterData data) throws Exception {
        StepMockHelper<FieldSplitterMeta, StepDataInterface> helper = StepMockUtil.getStepMockHelper(FieldSplitterMeta.class, "FieldSplitter_EmptyStringVsNull_Test");
        Mockito.when((Object)helper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        FieldSplitter step = new FieldSplitter(helper.stepMeta, (StepDataInterface)data, 0, helper.transMeta, helper.trans);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        return step;
    }
}

