/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.staxpoi;

import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KCellType;
import org.pentaho.di.trans.steps.excelinput.staxpoi.StaxPoiSheet;

public class StaxPoiSheetTest {
    private static final String BP_SHEET = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">%s</worksheet>";
    private static final String SHEET_DATE_NO_V = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">%s</worksheet>", " <dimension ref=\"A1:A3\"/> <sheetData>   <row r=\"1\" spans=\"1:1\">     <c r=\"A1\" s=\"1\" t=\"s\"><v>0</v></c>   </row>   <row r=\"2\" spans=\"1:1\">     <c r=\"A2\" s=\"2\"><v>42248</v></c>   </row>   <row r=\"3\" spans=\"1:1\">     <c r=\"A3\" s=\"2\"/>   </row> </sheetData>");
    private static final String SHEET_1 = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">%s</worksheet>", " <dimension ref=\"B2:F5\"/> <sheetData>  <row r=\"2\" spans=\"2:6\"><c r=\"B2\" t=\"s\"><v>0</v></c><c r=\"C2\" t=\"s\"><v>1</v></c>    <c r=\"D2\" t=\"s\"><v>2</v></c><c r=\"E2\" t=\"s\"><v>3</v></c><c r=\"F2\" t=\"s\"><v>4</v></c></row>  <row r=\"3\" spans=\"2:6\"><c r=\"B3\" t=\"s\"><v>5</v></c><c r=\"C3\" s=\"1\"><v>40428</v></c>    <c r=\"D3\"><v>75</v></c><c r=\"E3\" t=\"b\"><v>1</v></c><c r=\"F3\"><f>D3</f><v>75</v></c></row>  <row r=\"4\" spans=\"2:6\"><c r=\"B4\" t=\"s\"><v>6</v></c><c r=\"C4\" s=\"1\"><v>40429</v></c>    <c r=\"D4\"><v>42</v></c><c r=\"E4\" t=\"b\"><v>0</v></c><c r=\"F4\"><f>F3+D4</f><v>117</v></c></row>  <row r=\"5\" spans=\"2:6\"><c r=\"B5\" t=\"s\"><v>7</v></c><c r=\"C5\" s=\"1\"><v>40430</v></c>    <c r=\"D5\"><v>93</v></c><c r=\"E5\" t=\"b\"><v>1</v></c><c r=\"F5\"><f>F4+D5</f><v>210</v></c></row> </sheetData>");
    private static final String SHEET_EMPTY = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">%s</worksheet>", "<dimension ref=\"A1\"/><sheetData/>");

    @Test
    public void testNullDateCell() throws Exception {
        String sheetId = "1";
        String sheetName = "Sheet 1";
        XSSFReader reader = this.mockXSSFReader("1", SHEET_DATE_NO_V, this.mockSharedStringsTable("Some Date"), this.mockStylesTable(Collections.singletonMap(2, 165), Collections.singletonMap(165, "M/D/YYYY")));
        StaxPoiSheet spSheet = new StaxPoiSheet(reader, "Sheet 1", "1");
        KCell cell = spSheet.getRow(1)[0];
        Assert.assertNotNull((Object)cell);
        Assert.assertEquals((Object)KCellType.DATE, (Object)cell.getType());
        cell = spSheet.getRow(2)[0];
        Assert.assertNull((String)"cell must be null", (Object)cell);
    }

    @Test
    public void testEmptySheet() throws Exception {
        XSSFReader reader = this.mockXSSFReader("sheet1", SHEET_EMPTY, (SharedStringsTable)Mockito.mock(SharedStringsTable.class), (StylesTable)Mockito.mock(StylesTable.class));
        StaxPoiSheet sheet = new StaxPoiSheet(reader, "empty", "sheet1");
        for (int j = 0; j < sheet.getRows(); ++j) {
            sheet.getRow(j);
        }
    }

    @Test
    public void testReadSameRow() throws Exception {
        StaxPoiSheet sheet1 = this.getSampleSheet();
        KCell[] row = sheet1.getRow(3);
        Assert.assertEquals((Object)"Two", (Object)row[1].getValue());
        row = sheet1.getRow(3);
        Assert.assertEquals((Object)"Two", (Object)row[1].getValue());
    }

    @Test
    public void testReadRowRA() throws Exception {
        StaxPoiSheet sheet1 = this.getSampleSheet();
        KCell[] row = sheet1.getRow(4);
        Assert.assertEquals((Object)"Three", (Object)row[1].getValue());
        row = sheet1.getRow(2);
        Assert.assertEquals((Object)"One", (Object)row[1].getValue());
    }

    @Test
    public void testReadEmptyRow() throws Exception {
        StaxPoiSheet sheet1 = this.getSampleSheet();
        KCell[] row = sheet1.getRow(0);
        Assert.assertEquals((String)"empty row expected", (long)0L, (long)row.length);
    }

    @Test
    public void testReadCells() throws Exception {
        StaxPoiSheet sheet = this.getSampleSheet();
        KCell cell = sheet.getCell(1, 2);
        Assert.assertEquals((Object)"One", (Object)cell.getValue());
        Assert.assertEquals((Object)KCellType.LABEL, (Object)cell.getType());
        cell = sheet.getCell(2, 2);
        Assert.assertEquals((Object)KCellType.DATE, (Object)cell.getType());
        Assert.assertEquals((Object)new Date(1283817600000L), (Object)cell.getValue());
        cell = sheet.getCell(1, 3);
        Assert.assertEquals((Object)"Two", (Object)cell.getValue());
        Assert.assertEquals((Object)KCellType.LABEL, (Object)cell.getType());
    }

    @Test
    public void testReadData() throws Exception {
        StaxPoiSheet sheet1 = this.getSampleSheet();
        Assert.assertEquals((long)5L, (long)sheet1.getRows());
        KCell[] row = sheet1.getRow(2);
        Assert.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        Assert.assertEquals((Object)"One", (Object)row[1].getValue());
        Assert.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        Assert.assertEquals((Object)new Date(1283817600000L), (Object)row[2].getValue());
        Assert.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        Assert.assertEquals((Object)Double.valueOf("75"), (Object)row[3].getValue());
        Assert.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)row[4].getValue());
        Assert.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        Assert.assertEquals((Object)Double.valueOf("75"), (Object)row[5].getValue());
        row = sheet1.getRow(3);
        Assert.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        Assert.assertEquals((Object)"Two", (Object)row[1].getValue());
        Assert.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        Assert.assertEquals((Object)new Date(1283904000000L), (Object)row[2].getValue());
        Assert.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        Assert.assertEquals((Object)Double.valueOf("42"), (Object)row[3].getValue());
        Assert.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)row[4].getValue());
        Assert.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        Assert.assertEquals((Object)Double.valueOf("117"), (Object)row[5].getValue());
        row = sheet1.getRow(4);
        Assert.assertEquals((Object)KCellType.LABEL, (Object)row[1].getType());
        Assert.assertEquals((Object)"Three", (Object)row[1].getValue());
        Assert.assertEquals((Object)KCellType.DATE, (Object)row[2].getType());
        Assert.assertEquals((Object)new Date(1283990400000L), (Object)row[2].getValue());
        Assert.assertEquals((Object)KCellType.NUMBER, (Object)row[3].getType());
        Assert.assertEquals((Object)Double.valueOf("93"), (Object)row[3].getValue());
        Assert.assertEquals((Object)KCellType.BOOLEAN, (Object)row[4].getType());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)row[4].getValue());
        Assert.assertEquals((Object)KCellType.NUMBER_FORMULA, (Object)row[5].getType());
        Assert.assertEquals((Object)Double.valueOf("210"), (Object)row[5].getValue());
        try {
            row = sheet1.getRow(5);
            Assert.fail((String)"No out of bounds exception thrown when expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private StaxPoiSheet getSampleSheet() throws Exception {
        String sheetId = "sheet1";
        XSSFReader reader = this.mockXSSFReader(sheetId, SHEET_1, this.mockSharedStringsTable("Col1Label", "Col2Date", "Col3Number", "Col4Boolean", "Col5NumFormula", "One", "Two", "Three"), this.mockStylesTable(Collections.singletonMap(1, 14), Collections.emptyMap()));
        return new StaxPoiSheet(reader, "Sheet 1", sheetId);
    }

    private XSSFReader mockXSSFReader(String sheetId, final String sheetContent, SharedStringsTable sst, StylesTable styles) throws Exception {
        XSSFReader reader = (XSSFReader)Mockito.mock(XSSFReader.class);
        Mockito.when((Object)reader.getSharedStringsTable()).thenReturn((Object)sst);
        Mockito.when((Object)reader.getStylesTable()).thenReturn((Object)styles);
        Mockito.when((Object)reader.getSheet(sheetId)).thenAnswer((Answer)new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocation) throws Throwable {
                return IOUtils.toInputStream((String)sheetContent, (String)"UTF-8");
            }
        });
        return reader;
    }

    private StylesTable mockStylesTable(final Map<Integer, Integer> styleToNumFmtId, final Map<Integer, String> numFmts) {
        StylesTable styles = (StylesTable)Mockito.mock(StylesTable.class);
        Mockito.when((Object)styles.getCellXfAt(((Integer)Mockito.any(Integer.class)).intValue())).then((Answer)new Answer<CTXf>(){

            public CTXf answer(InvocationOnMock invocation) throws Throwable {
                int style = (Integer)invocation.getArguments()[0];
                Integer numFmtId = (Integer)styleToNumFmtId.get(style);
                if (numFmtId != null) {
                    CTXf ctxf = CTXf.Factory.newInstance();
                    ctxf.setNumFmtId((long)numFmtId.intValue());
                    return ctxf;
                }
                return null;
            }
        });
        Mockito.when((Object)styles.getNumberFormatAt(((Integer)Mockito.any(Integer.class)).intValue())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)numFmts.get((Integer)invocation.getArguments()[0]);
            }
        });
        return styles;
    }

    private SharedStringsTable mockSharedStringsTable(String ... strings) {
        SharedStringsTable sst = new SharedStringsTable();
        for (String str : strings) {
            CTRst st = CTRst.Factory.newInstance();
            st.setT(str);
            sst.addEntry(st);
        }
        return sst;
    }
}

