/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;
import org.pentaho.di.trans.steps.excelinput.SpreadSheetType;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;

public class ExcelInputMetaTest {
    LoadSaveTester loadSaveTester;

    @Before
    public void setUp() throws Exception {
        List<String> attributes = Arrays.asList("fileName", "fileMask", "excludeFileMask", "fileRequired", "includeSubFolders", "field", "sheetName", "startRow", "startColumn", "spreadSheetType", "fileField", "sheetField", "sheetRowNumberField", "rowNumberField", "shortFileFieldName", "extensionFieldName", "pathFieldName", "sizeFieldName", "hiddenFieldName", "lastModificationTimeFieldName", "uriNameFieldName", "rootUriNameFieldName");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("excludeFileMask", "getExludeFileMask");
                this.put("shortFileFieldName", "getShortFileNameField");
                this.put("extensionFieldName", "getExtensionField");
                this.put("pathFieldName", "getPathField");
                this.put("sizeFieldName", "getSizeField");
                this.put("hiddenFieldName", "isHiddenField");
                this.put("lastModificationTimeFieldName", "getLastModificationDateField");
                this.put("uriNameFieldName", "getUriField");
                this.put("rootUriNameFieldName", "getRootUriField");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("shortFileFieldName", "setShortFileNameField");
                this.put("extensionFieldName", "setExtensionField");
                this.put("pathFieldName", "setPathField");
                this.put("sizeFieldName", "setSizeField");
                this.put("hiddenFieldName", "setIsHiddenField");
                this.put("lastModificationTimeFieldName", "setLastModificationDateField");
                this.put("uriNameFieldName", "setUriField");
                this.put("rootUriNameFieldName", "setRootUriField");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 1);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fileName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("sheetName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("excludeFileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileRequired", stringArrayLoadSaveValidator);
        attrValidatorMap.put("includeSubFolders", stringArrayLoadSaveValidator);
        attrValidatorMap.put("field", new ExcelInputFieldFieldLoadSaveValidator());
        attrValidatorMap.put("spreadSheetType", new SpreadSheetTypeFieldLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        typeValidatorMap.put(int[].class.getCanonicalName(), new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(), 1));
        this.loadSaveTester = new LoadSaveTester(ExcelInputMeta.class, attributes, (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testLoadSaveXML() throws KettleException {
        this.loadSaveTester.testXmlRoundTrip();
    }

    @Test
    public void testLoadSaveRepo() throws KettleException {
        this.loadSaveTester.testRepoRoundTrip();
    }

    public class SpreadSheetTypeFieldLoadSaveValidator
    implements FieldLoadSaveValidator<SpreadSheetType> {
        @Override
        public SpreadSheetType getTestObject() {
            return SpreadSheetType.POI;
        }

        @Override
        public boolean validateTestObject(SpreadSheetType testObject, Object actual) {
            return true;
        }
    }

    public class ExcelInputFieldFieldLoadSaveValidator
    implements FieldLoadSaveValidator<ExcelInputField[]> {
        @Override
        public ExcelInputField[] getTestObject() {
            return new ExcelInputField[0];
        }

        @Override
        public boolean validateTestObject(ExcelInputField[] testObject, Object actual) {
            return true;
        }
    }
}

