/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dimensionlookup;

import java.sql.Timestamp;
import org.junit.Test;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.trans.steps.dimensionlookup.DimensionCache;

public class DimensionCacheTest {
    @Test
    public void testCompareDateInterval() {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaTimestamp("DATE_FROM"));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaTimestamp("DATE_TO"));
        int[] keyIndexes = new int[]{};
        int fromDateIndex = 0;
        int toDateIndex = 1;
        DimensionCache dc = new DimensionCache((RowMetaInterface)rowMeta, keyIndexes, fromDateIndex, toDateIndex);
        long t0 = 1425300000000L;
        Timestamp D1 = new Timestamp(t0);
        Timestamp D2 = new Timestamp(t0 + 3600000L);
        Timestamp D3 = new Timestamp(t0 + 0x6DDD00L);
        Timestamp D4 = new Timestamp(t0 + 10800000L);
        Timestamp D5 = new Timestamp(t0 + 14400000L);
        DimensionCacheTest.assertCompareDateInterval(dc, null, null, null, null, 0);
        DimensionCacheTest.assertCompareDateInterval(dc, null, null, D1, null, -1);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, null, null, null, 1);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, null, D1, null, 1);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, null, D2, null, 0);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, null, D3, null, -1);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, D4, null, null, 1);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, D4, D1, null, 1);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, D4, D2, null, 0);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, D4, D3, null, 0);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, D4, D4, null, -1);
        DimensionCacheTest.assertCompareDateInterval(dc, D2, D4, D5, null, -1);
        DimensionCacheTest.assertCompareDateInterval(dc, null, D4, null, null, 0);
        DimensionCacheTest.assertCompareDateInterval(dc, null, D4, D3, null, 0);
        DimensionCacheTest.assertCompareDateInterval(dc, null, D4, D4, null, -1);
        DimensionCacheTest.assertCompareDateInterval(dc, null, D4, D5, null, -1);
    }

    private static void assertCompareDateInterval(DimensionCache dc, Object from1, Object to1, Object from2, Object to2, int expectedValue) {
        int actualValue = dc.compare(new Object[]{from1, to1}, new Object[]{from2, to2});
        boolean success = expectedValue == 0 && actualValue == 0 || expectedValue < 0 && actualValue < 0 || expectedValue > 0 && actualValue > 0;
        Assert.assertTrue((boolean)success, (String)"{0} expected, {1} actual. compare( [({2}), ({3})], [({4}), ({5})] )", (Object[])new Object[]{expectedValue, actualValue, from1, to1, from2, to2});
    }
}

