/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.datagrid;

import java.util.Arrays;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.datagrid.DataGrid;
import org.pentaho.di.trans.steps.datagrid.DataGridData;
import org.pentaho.di.trans.steps.datagrid.DataGridMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.test.util.FieldAccessor;

public class DataGrid_EmptyStringVsNull_Test {
    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Test
    public void emptyAndNullsAreNotDifferent() throws Exception {
        List<Object[]> expected = Arrays.asList({"", "", null}, {null, "", null}, {null, "", null});
        this.doTestEmptyStringVsNull(false, expected);
    }

    @Test
    public void emptyAndNullsAreDifferent() throws Exception {
        List<Object[]> expected = Arrays.asList({"", "", null}, {"", "", null}, {null, "", null});
        this.doTestEmptyStringVsNull(true, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestEmptyStringVsNull(boolean diffProperty, List<Object[]> expected) throws Exception {
        FieldAccessor.ensureEmptyStringIsNotNull(diffProperty);
        try {
            this.executeAndAssertResults(expected);
        }
        finally {
            FieldAccessor.resetEmptyStringIsNotNull();
        }
    }

    private void executeAndAssertResults(List<Object[]> expected) throws Exception {
        String stringType = ValueMetaFactory.getValueMetaName((int)2);
        String numberType = ValueMetaFactory.getValueMetaName((int)1);
        DataGridMeta meta = new DataGridMeta();
        meta.allocate(3);
        meta.setFieldName(new String[]{"string", "string-setEmpty", "number"});
        meta.setFieldType(new String[]{stringType, stringType, numberType});
        meta.setEmptyString(new boolean[]{false, true, false});
        List<List> dataRows = Arrays.asList(Arrays.asList(" ", " ", " "), Arrays.asList("", "", ""), Arrays.asList(null, null, null));
        meta.setDataLines(dataRows);
        DataGridData data = new DataGridData();
        DataGrid step = this.createAndInitStep(meta, data);
        List<Object[]> actual = TransTestingUtil.execute((BaseStep)step, (StepMetaInterface)meta, (StepDataInterface)data, 3, true);
        TransTestingUtil.assertResult(expected, actual);
    }

    private DataGrid createAndInitStep(DataGridMeta meta, DataGridData data) {
        StepMockHelper<DataGridMeta, StepDataInterface> helper = StepMockUtil.getStepMockHelper(DataGridMeta.class, "DataGrid_EmptyStringVsNull_Test");
        Mockito.when((Object)helper.stepMeta.getStepMetaInterface()).thenReturn((Object)meta);
        DataGrid step = new DataGrid(helper.stepMeta, (StepDataInterface)data, 0, helper.transMeta, helper.trans);
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        return step;
    }
}

