/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.trans.steps.databaselookup.readallcache.SearchingContext;

public class SearchingContextTest {
    @Test
    public void returnsClearWorkingSet() {
        SearchingContext ctx = new SearchingContext();
        ctx.init(4);
        ctx.getWorkingSet().set(1);
        Assert.assertEquals((String)"Should return cleared object", (long)-1L, (long)ctx.getWorkingSet().nextSetBit(0));
    }

    @Test
    public void intersectionDetectsBecomingEmpty() {
        SearchingContext ctx = new SearchingContext();
        ctx.init(4);
        BitSet set = ctx.getWorkingSet();
        set.set(1);
        set.set(2);
        ctx.intersect(set, false);
        Assert.assertFalse((boolean)ctx.isEmpty());
        set = ctx.getWorkingSet();
        ctx.intersect(set, false);
        Assert.assertTrue((boolean)ctx.isEmpty());
    }
}

