/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup.readallcache;

import java.util.BitSet;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.readallcache.GtIndex;
import org.pentaho.di.trans.steps.databaselookup.readallcache.IndexTestBase;

@RunWith(value=Parameterized.class)
public class LeIndexTest
extends IndexTestBase<GtIndex> {
    @Parameterized.Parameters
    public static List<Object[]> createSampleData() {
        return IndexTestBase.createSampleData();
    }

    public LeIndexTest(Long[][] rows) {
        super(GtIndex.class, rows);
    }

    @Override
    void doAssertMatches(BitSet candidates, long lookupValue, long actualValue) {
        if (actualValue > lookupValue) {
            Assert.fail((String)String.format("All found values are expected to be less than [%d] or equal to it, but got [%d] among %s", lookupValue, actualValue, candidates));
        }
    }

    @Override
    GtIndex createIndexInstance(int column, ValueMetaInterface meta, int rowsAmount) throws Exception {
        return (GtIndex)GtIndex.lessOrEqualCache((int)column, (ValueMetaInterface)meta, (int)rowsAmount);
    }

    @Override
    public void lookupFor_MinusOne() {
        this.testFindsNothing(-1L);
    }

    @Override
    public void lookupFor_Zero() {
        this.testFindsCorrectly(0L, 1);
    }

    @Override
    public void lookupFor_One() {
        this.testFindsCorrectly(1L, 2);
    }

    @Override
    public void lookupFor_Two() {
        this.testFindsCorrectly(2L, 4);
    }

    @Override
    public void lookupFor_Three() {
        this.testFindsCorrectly(3L, 5);
    }

    @Override
    public void lookupFor_Hundred() {
        this.testFindsCorrectly(100L, 5);
    }
}

