/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.databaselookup;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookup;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupData;
import org.pentaho.di.trans.steps.databaselookup.DatabaseLookupMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.metastore.api.IMetaStore;

public class PDI5436Test {
    private StepMockHelper<DatabaseLookupMeta, DatabaseLookupData> smh;

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<DatabaseLookupMeta, DatabaseLookupData>("Database Lookup", DatabaseLookupMeta.class, DatabaseLookupData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    private RowMeta mockInputRowMeta() {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaString nameMeta = new ValueMetaString("name");
        nameMeta.setStorageType(1);
        nameMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("name"));
        inputRowMeta.addValueMeta((ValueMetaInterface)nameMeta);
        ValueMetaString idMeta = new ValueMetaString("id");
        idMeta.setStorageType(1);
        idMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("id"));
        inputRowMeta.addValueMeta((ValueMetaInterface)idMeta);
        return inputRowMeta;
    }

    private RowSet mockInputRowSet() {
        RowSet inputRowSet = this.smh.getMockInputRowSet(new Object[][]{{"name".getBytes(), "1".getBytes()}});
        inputRowSet.setRowMeta((RowMetaInterface)this.mockInputRowMeta());
        return inputRowSet;
    }

    private DatabaseLookupMeta mockStepMeta() throws KettleStepException {
        DatabaseLookupMeta stepMeta = (DatabaseLookupMeta)this.smh.initStepMetaInterface;
        ((DatabaseLookupMeta)Mockito.doReturn((Object)Mockito.mock(DatabaseMeta.class)).when((Object)stepMeta)).getDatabaseMeta();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new String[]{"="}).when((Object)stepMeta)).getKeyCondition();
        ((DatabaseLookupMeta)Mockito.doCallRealMethod().when((Object)stepMeta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Mockito.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new String[]{"value"}).when((Object)stepMeta)).getReturnValueNewName();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new int[]{2}).when((Object)stepMeta)).getReturnValueDefaultType();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)true).when((Object)stepMeta)).isCached();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)true).when((Object)stepMeta)).isLoadingAllDataInCache();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new String[]{"id"}).when((Object)stepMeta)).getStreamKeyField1();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new String[]{null}).when((Object)stepMeta)).getStreamKeyField2();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new String[]{"id"}).when((Object)stepMeta)).getTableKeyField();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new String[]{"value"}).when((Object)stepMeta)).getReturnValueField();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new String[]{""}).when((Object)stepMeta)).getReturnValueDefault();
        ((DatabaseLookupMeta)Mockito.doReturn((Object)new int[]{2}).when((Object)stepMeta)).getReturnValueDefaultType();
        Mockito.when((Object)stepMeta.getStreamKeyField2()).thenReturn((Object)new String[]{"a", "b", "c"});
        return stepMeta;
    }

    private Database mockDatabase() throws KettleDatabaseException {
        Database databaseMock = (Database)Mockito.mock(Database.class);
        RowMeta databaseRowMeta = new RowMeta();
        databaseRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("id"));
        databaseRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("value"));
        ((Database)Mockito.doReturn((Object)databaseRowMeta).when((Object)databaseMock)).getTableFields(Mockito.anyString());
        ((Database)Mockito.doReturn(Arrays.asList(new Object[][]{{"1", "value"}})).when((Object)databaseMock)).getRows(Mockito.anyString(), Mockito.anyInt());
        ((Database)Mockito.doReturn((Object)databaseRowMeta).when((Object)databaseMock)).getReturnRowMeta();
        return databaseMock;
    }

    @Test
    public void testCacheAllTable() throws KettleException {
        KettleEnvironment.init();
        DatabaseLookup stepSpy = (DatabaseLookup)Mockito.spy((Object)new DatabaseLookup(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans));
        ((DatabaseLookup)Mockito.doReturn((Object)this.mockDatabase()).when((Object)stepSpy)).getDatabase((DatabaseMeta)Matchers.any(DatabaseMeta.class));
        stepSpy.getInputRowSets().add(this.mockInputRowSet());
        stepSpy.setInputRowMeta((RowMetaInterface)this.mockInputRowMeta());
        QueueRowSet outputRowSet = new QueueRowSet();
        stepSpy.getOutputRowSets().add(outputRowSet);
        DatabaseLookupMeta meta = this.mockStepMeta();
        Object data = this.smh.initStepDataInterface;
        Assert.assertTrue((String)"Step init failed", (boolean)stepSpy.init((StepMetaInterface)meta, data));
        Assert.assertTrue((String)"Error processing row", (boolean)stepSpy.processRow((StepMetaInterface)meta, data));
        Assert.assertEquals((String)"Cache lookup failed", (Object)"value", (Object)outputRowSet.getRow()[2]);
    }
}

