/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputUnicodeTest
extends CsvInputUnitTestBase {
    private static final String UTF8 = "UTF-8";
    private static final String UTF16LE = "UTF-16LE";
    private static final String UTF16LEBOM = "x-UTF-16LE-BOM";
    private static final String UTF16BE = "UTF-16LE";
    private static final String TEST_DATA = "Header1\tHeader2\nValue\tValue\nValue\tValue\n";
    private static StepMockHelper<?, ?> stepMockHelper;

    @BeforeClass
    public static void setUp() throws KettleException {
        stepMockHelper = new StepMockHelper<CsvInputMeta, CsvInputData>("CsvInputTest", CsvInputMeta.class, CsvInputData.class);
        Mockito.when((Object)CsvInputUnicodeTest.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)CsvInputUnicodeTest.stepMockHelper.logChannelInterface);
        Mockito.when((Object)CsvInputUnicodeTest.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @Test
    public void testUTF16LE() throws Exception {
        this.doTest("UTF-16LE", "UTF-16LE", TEST_DATA);
    }

    @Test
    public void testUTF16BE() throws Exception {
        this.doTest("UTF-16LE", "UTF-16LE", TEST_DATA);
    }

    @Test
    public void testUTF16LEBOM() throws Exception {
        this.doTest(UTF16LEBOM, "UTF-16LE", TEST_DATA);
    }

    @Test
    public void testUTF8() throws Exception {
        this.doTest(UTF8, UTF8, TEST_DATA);
    }

    private void doTest(String fileEncoding, String stepEncoding, String testData) throws Exception {
        boolean haveRowsToRead;
        String testFilePath = this.createTestFile(fileEncoding, testData).getAbsolutePath();
        CsvInputMeta meta = this.createStepMeta(testFilePath, stepEncoding);
        CsvInputData data = new CsvInputData();
        CsvInput csvInput = new CsvInput(CsvInputUnicodeTest.stepMockHelper.stepMeta, CsvInputUnicodeTest.stepMockHelper.stepDataInterface, 0, CsvInputUnicodeTest.stepMockHelper.transMeta, CsvInputUnicodeTest.stepMockHelper.trans);
        csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
        csvInput.addRowListener((RowListener)new RowAdapter(){

            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                for (int i = 0; i < rowMeta.size(); ++i) {
                    Assert.assertEquals((Object)"Value", (Object)row[i]);
                }
            }
        });
        while (!(haveRowsToRead = !csvInput.processRow((StepMetaInterface)meta, (StepDataInterface)data))) {
        }
        csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        Assert.assertEquals((long)2L, (long)csvInput.getLinesWritten());
    }

    private CsvInputMeta createStepMeta(String testFilePath, String encoding) {
        CsvInputMeta meta = new CsvInputMeta();
        meta.setFilename(testFilePath);
        meta.setDelimiter("\t");
        meta.setEncoding(encoding);
        meta.setEnclosure("\"");
        meta.setBufferSize("50000");
        meta.setInputFields(this.getInputFileFields());
        meta.setHeaderPresent(true);
        return meta;
    }

    private TextFileInputField[] getInputFileFields() {
        return this.createInputFileFields("Field1", "Field2");
    }
}

