/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.trans.TransTestingUtil;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputRowNumberTest
extends CsvInputUnitTestBase {
    private CsvInput csvInput;

    @Before
    public void setUp() throws Exception {
        StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "CsvInputRowNumberTest");
        this.csvInput = new CsvInput(stepMockHelper.stepMeta, stepMockHelper.stepDataInterface, 0, stepMockHelper.transMeta, stepMockHelper.trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void hasNotEnclosures_HasNotNewLine() throws Exception {
        File tmp = this.createTestFile("utf-8", "a,b\na,");
        try {
            this.doTest(tmp);
        }
        finally {
            tmp.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(File file) throws Exception {
        List<Object[]> actual;
        CsvInputData data = new CsvInputData();
        CsvInputMeta meta = this.createMeta(file, this.createInputFileFields("a", "b"));
        try {
            this.csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
            actual = TransTestingUtil.execute((BaseStep)this.csvInput, (StepMetaInterface)meta, (StepDataInterface)data, 2, false);
        }
        finally {
            this.csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
        }
        List<Object[]> expected = Arrays.asList({"a", "b", 1L}, {"a", null, 2L});
        TransTestingUtil.assertResult(expected, actual);
    }

    private CsvInputMeta createMeta(File file, TextFileInputField[] fields) {
        CsvInputMeta meta = new CsvInputMeta();
        meta.setFilename(file.getAbsolutePath());
        meta.setDelimiter(",");
        meta.setEncoding("utf-8");
        meta.setBufferSize("1024");
        meta.setInputFields(fields);
        meta.setHeaderPresent(false);
        meta.setRowNumField("rownum");
        return meta;
    }
}

