/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputData;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.csvinput.CsvInputUnitTestBase;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputEnclosureTest
extends CsvInputUnitTestBase {
    private CsvInput csvInput;

    @Before
    public void setUp() throws Exception {
        StepMockHelper<CsvInputMeta, StepDataInterface> stepMockHelper = StepMockUtil.getStepMockHelper(CsvInputMeta.class, "CsvInputEnclosureTest");
        this.csvInput = new CsvInput(stepMockHelper.stepMeta, stepMockHelper.stepDataInterface, 0, stepMockHelper.transMeta, stepMockHelper.trans);
    }

    @Test
    public void hasEnclosures_HasNewLine() throws Exception {
        this.doTest("\"value1\";\"value2\"\n");
    }

    @Test
    public void hasEnclosures_HasNotNewLine() throws Exception {
        this.doTest("\"value1\";\"value2\"");
    }

    @Test
    public void hasNotEnclosures_HasNewLine() throws Exception {
        this.doTest("value1;value2\n");
    }

    @Test
    public void hasNotEnclosures_HasNotNewLine() throws Exception {
        this.doTest("value1;value2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest(String content) throws Exception {
        QueueRowSet output = new QueueRowSet();
        File tmp = this.createTestFile("utf-8", content);
        try {
            CsvInputMeta meta = this.createMeta(tmp, this.createInputFileFields("f1", "f2"));
            CsvInputData data = new CsvInputData();
            this.csvInput.init((StepMetaInterface)meta, (StepDataInterface)data);
            this.csvInput.getOutputRowSets().add(output);
            try {
                this.csvInput.processRow((StepMetaInterface)meta, (StepDataInterface)data);
            }
            finally {
                this.csvInput.dispose((StepMetaInterface)meta, (StepDataInterface)data);
            }
        }
        finally {
            tmp.delete();
        }
        Object[] row = output.getRowImmediate();
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"value1", (Object)row[0]);
        Assert.assertEquals((Object)"value2", (Object)row[1]);
        Assert.assertNull((Object)output.getRowImmediate());
    }

    private CsvInputMeta createMeta(File file, TextFileInputField[] fields) {
        CsvInputMeta meta = new CsvInputMeta();
        meta.setFilename(file.getAbsolutePath());
        meta.setDelimiter(";");
        meta.setEncoding("utf-8");
        meta.setEnclosure("\"");
        meta.setBufferSize("1024");
        meta.setInputFields(fields);
        meta.setHeaderPresent(false);
        return meta;
    }
}

