/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.csvinput;

import org.junit.Test;
import org.pentaho.di.trans.steps.csvinput.BaseCsvParsingTest;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;

public class CsvInputContentParsingTest
extends BaseCsvParsingTest {
    @Test
    public void testDefaultOptions() throws Exception {
        this.init("default.csv");
        this.setFields(new TextFileInputField(), new TextFileInputField(), new TextFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }

    @Test
    public void testSemicolonOptions() throws Exception {
        ((CsvInputMeta)this.meta).setDelimiter(";");
        this.init("semicolon.csv");
        this.setFields(new TextFileInputField(), new TextFileInputField(), new TextFileInputField());
        this.process();
        this.check(new Object[][]{{"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}, {"\u043d\u0435-\u043b\u0430\u0446\u0456\u043d\u043a\u0430(non-latin)", "4", "4"}});
    }

    @Test
    public void testNoHeaderOptions() throws Exception {
        ((CsvInputMeta)this.meta).setHeaderPresent(false);
        this.init("default.csv");
        this.setFields(new TextFileInputField(), new TextFileInputField(), new TextFileInputField());
        this.process();
        this.check(new Object[][]{{"Field 1", "Field 2", "Field 3"}, {"first", "1", "1.1"}, {"second", "2", "2.2"}, {"third", "3", "3.3"}});
    }
}

