/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.concatfields;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.concatfields.ConcatFields;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsData;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;

public class ConcatFieldsTest {
    private StepMockHelper<ConcatFieldsMeta, ConcatFieldsData> stepMockHelper;
    private TextFileField textFileField = new TextFileField("Name", 2, "", 10, 20, "", "", "", "");
    private TextFileField textFileField2 = new TextFileField("Surname", 2, "", 10, 20, "", "", "", "");
    private TextFileField[] textFileFields = new TextFileField[]{this.textFileField, this.textFileField2};

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<ConcatFieldsMeta, ConcatFieldsData>("CONCAT FIELDS TEST", ConcatFieldsMeta.class, ConcatFieldsData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testPrepareOutputRow() throws Exception {
        ConcatFieldsHandler concatFields = new ConcatFieldsHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        Object[] row = new Object[]{"one", "two"};
        String[] fieldNames = new String[]{"one", "two"};
        concatFields.setRow(row);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)inputRowMeta.size()).thenReturn((Object)2);
        Mockito.when((Object)inputRowMeta.getFieldNames()).thenReturn((Object)fieldNames);
        Mockito.when((Object)((ConcatFieldsMeta)this.stepMockHelper.processRowsStepMetaInterface).getOutputFields()).thenReturn((Object)this.textFileFields);
        Mockito.when((Object)((ConcatFieldsMeta)this.stepMockHelper.processRowsStepMetaInterface).isFastDump()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)((ConcatFieldsMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileAppended()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)((ConcatFieldsMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileNameInField()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)((ConcatFieldsMeta)this.stepMockHelper.processRowsStepMetaInterface).isHeaderEnabled()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)((ConcatFieldsMeta)this.stepMockHelper.processRowsStepMetaInterface).isRemoveSelectedFields()).thenReturn((Object)Boolean.TRUE);
        concatFields.setInputRowMeta(inputRowMeta);
        try {
            concatFields.processRow((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)this.stepMockHelper.processRowsStepDataInterface);
            concatFields.prepareOutputRow(row);
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"NullPointerException issue PDI-8870 still reproduced ");
        }
    }

    private class ConcatFieldsHandler
    extends ConcatFields {
        private Object[] row;

        public ConcatFieldsHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        }

        public Object[] getRow() throws KettleException {
            return this.row;
        }

        public void setRow(Object[] row) {
            this.row = row;
        }

        protected Object[] putRowFastDataDump(Object[] r) throws KettleStepException {
            return null;
        }

        protected boolean writeHeader() {
            return true;
        }

        Object[] putRowFromStream(Object[] r) throws KettleStepException {
            return this.prepareOutputRow(r);
        }
    }
}

