/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.calculator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.calculator.Calculator;
import org.pentaho.di.trans.steps.calculator.CalculatorData;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class CalculatorUnitTest {
    private StepMockHelper<CalculatorMeta, CalculatorData> smh;

    @BeforeClass
    public static void init() throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<CalculatorMeta, CalculatorData>("Calculator", CalculatorMeta.class, CalculatorData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @Test
    public void testReturnDigitsOnly() throws KettleException {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaString nameMeta = new ValueMetaString("Name");
        inputRowMeta.addValueMeta((ValueMetaInterface)nameMeta);
        ValueMetaString valueMeta = new ValueMetaString("Value");
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        RowSet inputRowSet = this.smh.getMockInputRowSet({"name1", "qwe123asd456zxc"}, {"name2", null});
        inputRowSet.setRowMeta((RowMetaInterface)inputRowMeta);
        Calculator calculator = new Calculator(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        calculator.getInputRowSets().add(inputRowSet);
        calculator.setInputRowMeta((RowMetaInterface)inputRowMeta);
        calculator.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(new CalculatorMetaFunction[]{new CalculatorMetaFunction("digits", 54, "Value", null, null, 2, 0, 0, false, "", "", "", "")});
        try {
            calculator.addRowListener((RowListener)new RowAdapter(){

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    CalculatorUnitTest.assertEquals("123456", row[2]);
                }
            });
            calculator.processRow((StepMetaInterface)meta, (StepDataInterface)new CalculatorData());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void calculatorShouldClearDataInstance() throws Exception {
        RowMeta inputRowMeta = new RowMeta();
        ValueMetaInteger valueMeta = new ValueMetaInteger("Value");
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        RowSet inputRowSet = this.smh.getMockInputRowSet(new Object[][]{{-1L}});
        inputRowSet.setRowMeta((RowMetaInterface)inputRowMeta);
        Calculator calculator = new Calculator(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        calculator.getInputRowSets().add(inputRowSet);
        calculator.setInputRowMeta((RowMetaInterface)inputRowMeta);
        calculator.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(new CalculatorMetaFunction[]{new CalculatorMetaFunction("test", 41, "Value", null, null, 2, 0, 0, false, "", "", "", "")});
        CalculatorData data = new CalculatorData();
        data = (CalculatorData)Mockito.spy((Object)data);
        calculator.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        ((CalculatorData)Mockito.verify((Object)data)).getValueMetaFor(Matchers.eq((int)valueMeta.getType()), Matchers.anyString());
        calculator.processRow((StepMetaInterface)meta, (StepDataInterface)data);
        ((CalculatorData)Mockito.verify((Object)data)).clearValuesMetaMapping();
    }

    @Test
    public void testRound1() throws KettleException {
        this.assertRound1(1.0, 1.2);
        this.assertRound1(2.0, 1.5);
        this.assertRound1(2.0, 1.7);
        this.assertRound1(2.0, 2.2);
        this.assertRound1(3.0, 2.5);
        this.assertRound1(3.0, 2.7);
        this.assertRound1(-1.0, -1.2);
        this.assertRound1(-1.0, -1.5);
        this.assertRound1(-2.0, -1.7);
        this.assertRound1(-2.0, -2.2);
        this.assertRound1(-2.0, -2.5);
        this.assertRound1(-3.0, -2.7);
        this.assertRound1(1.0, 1.0);
        this.assertRound1(2.0, 2.0);
        this.assertRound1(-3.0, -3.0);
    }

    @Test
    public void testRound2() throws KettleException {
        this.assertRound2(1.0, 1.2, 0L);
        this.assertRound2(2.0, 1.5, 0L);
        this.assertRound2(2.0, 1.7, 0L);
        this.assertRound2(2.0, 2.2, 0L);
        this.assertRound2(3.0, 2.5, 0L);
        this.assertRound2(3.0, 2.7, 0L);
        this.assertRound2(-1.0, -1.2, 0L);
        this.assertRound2(-1.0, -1.5, 0L);
        this.assertRound2(-2.0, -1.7, 0L);
        this.assertRound2(-2.0, -2.2, 0L);
        this.assertRound2(-2.0, -2.5, 0L);
        this.assertRound2(-3.0, -2.7, 0L);
        this.assertRound2(1.0, 1.0, 0L);
        this.assertRound2(2.0, 2.0, 0L);
        this.assertRound2(-3.0, -3.0, 0L);
        this.assertRound2(0.01, 0.012, 2L);
        this.assertRound2(0.02, 0.015, 2L);
        this.assertRound2(0.02, 0.017, 2L);
        this.assertRound2(0.02, 0.022, 2L);
        this.assertRound2(0.03, 0.025, 2L);
        this.assertRound2(0.03, 0.027, 2L);
        this.assertRound2(-0.01, -0.012, 2L);
        this.assertRound2(-0.01, -0.015, 2L);
        this.assertRound2(-0.02, -0.017, 2L);
        this.assertRound2(-0.02, -0.022, 2L);
        this.assertRound2(-0.02, -0.025, 2L);
        this.assertRound2(-0.03, -0.027, 2L);
        this.assertRound2(0.01, 0.01, 2L);
        this.assertRound2(0.02, 0.02, 2L);
        this.assertRound2(-0.03, -0.03, 2L);
        this.assertRound2(100, 120, -2L);
        this.assertRound2(200, 150, -2L);
        this.assertRound2(200, 170, -2L);
        this.assertRound2(200, 220, -2L);
        this.assertRound2(300, 250, -2L);
        this.assertRound2(300, 270, -2L);
        this.assertRound2(-100, -120, -2L);
        this.assertRound2(-100, -150, -2L);
        this.assertRound2(-200, -170, -2L);
        this.assertRound2(-200, -220, -2L);
        this.assertRound2(-200, -250, -2L);
        this.assertRound2(-300, -270, -2L);
        this.assertRound2(100, 100, -2L);
        this.assertRound2(200, 200, -2L);
        this.assertRound2(-300, -300, -2L);
    }

    @Test
    public void testRoundStd1() throws KettleException {
        this.assertRoundStd1(1.0, 1.2);
        this.assertRoundStd1(2.0, 1.5);
        this.assertRoundStd1(2.0, 1.7);
        this.assertRoundStd1(2.0, 2.2);
        this.assertRoundStd1(3.0, 2.5);
        this.assertRoundStd1(3.0, 2.7);
        this.assertRoundStd1(-1.0, -1.2);
        this.assertRoundStd1(-2.0, -1.5);
        this.assertRoundStd1(-2.0, -1.7);
        this.assertRoundStd1(-2.0, -2.2);
        this.assertRoundStd1(-3.0, -2.5);
        this.assertRoundStd1(-3.0, -2.7);
        this.assertRoundStd1(1.0, 1.0);
        this.assertRoundStd1(2.0, 2.0);
        this.assertRoundStd1(-3.0, -3.0);
    }

    @Test
    public void testRoundStd2() throws KettleException {
        this.assertRoundStd2(1.0, 1.2, 0L);
        this.assertRoundStd2(2.0, 1.5, 0L);
        this.assertRoundStd2(2.0, 1.7, 0L);
        this.assertRoundStd2(2.0, 2.2, 0L);
        this.assertRoundStd2(3.0, 2.5, 0L);
        this.assertRoundStd2(3.0, 2.7, 0L);
        this.assertRoundStd2(-1.0, -1.2, 0L);
        this.assertRoundStd2(-2.0, -1.5, 0L);
        this.assertRoundStd2(-2.0, -1.7, 0L);
        this.assertRoundStd2(-2.0, -2.2, 0L);
        this.assertRoundStd2(-3.0, -2.5, 0L);
        this.assertRoundStd2(-3.0, -2.7, 0L);
    }

    @Test
    public void testRoundCustom1() throws KettleException {
        this.assertRoundCustom1(2.0, 1.2, 0L);
        this.assertRoundCustom1(1.0, 1.2, 1L);
        this.assertRoundCustom1(2.0, 1.2, 2L);
        this.assertRoundCustom1(1.0, 1.2, 3L);
        this.assertRoundCustom1(1.0, 1.2, 4L);
        this.assertRoundCustom1(1.0, 1.2, 5L);
        this.assertRoundCustom1(1.0, 1.2, 6L);
        this.assertRoundCustom1(1.0, 1.2, -1L);
        this.assertRoundCustom1(2.0, 1.5, 0L);
        this.assertRoundCustom1(1.0, 1.5, 1L);
        this.assertRoundCustom1(2.0, 1.5, 2L);
        this.assertRoundCustom1(1.0, 1.5, 3L);
        this.assertRoundCustom1(2.0, 1.5, 4L);
        this.assertRoundCustom1(1.0, 1.5, 5L);
        this.assertRoundCustom1(2.0, 1.5, 6L);
        this.assertRoundCustom1(2.0, 1.5, -1L);
        this.assertRoundCustom1(2.0, 1.7, 0L);
        this.assertRoundCustom1(1.0, 1.7, 1L);
        this.assertRoundCustom1(2.0, 1.7, 2L);
        this.assertRoundCustom1(1.0, 1.7, 3L);
        this.assertRoundCustom1(2.0, 1.7, 4L);
        this.assertRoundCustom1(2.0, 1.7, 5L);
        this.assertRoundCustom1(2.0, 1.7, 6L);
        this.assertRoundCustom1(2.0, 1.7, -1L);
        this.assertRoundCustom1(3.0, 2.2, 0L);
        this.assertRoundCustom1(2.0, 2.2, 1L);
        this.assertRoundCustom1(3.0, 2.2, 2L);
        this.assertRoundCustom1(2.0, 2.2, 3L);
        this.assertRoundCustom1(2.0, 2.2, 4L);
        this.assertRoundCustom1(2.0, 2.2, 5L);
        this.assertRoundCustom1(2.0, 2.2, 6L);
        this.assertRoundCustom1(2.0, 2.2, -1L);
        this.assertRoundCustom1(3.0, 2.5, 0L);
        this.assertRoundCustom1(2.0, 2.5, 1L);
        this.assertRoundCustom1(3.0, 2.5, 2L);
        this.assertRoundCustom1(2.0, 2.5, 3L);
        this.assertRoundCustom1(3.0, 2.5, 4L);
        this.assertRoundCustom1(2.0, 2.5, 5L);
        this.assertRoundCustom1(2.0, 2.5, 6L);
        this.assertRoundCustom1(3.0, 2.5, -1L);
        this.assertRoundCustom1(3.0, 2.7, 0L);
        this.assertRoundCustom1(2.0, 2.7, 1L);
        this.assertRoundCustom1(3.0, 2.7, 2L);
        this.assertRoundCustom1(2.0, 2.7, 3L);
        this.assertRoundCustom1(3.0, 2.7, 4L);
        this.assertRoundCustom1(3.0, 2.7, 5L);
        this.assertRoundCustom1(3.0, 2.7, 6L);
        this.assertRoundCustom1(3.0, 2.7, -1L);
        this.assertRoundCustom1(-2.0, -1.2, 0L);
        this.assertRoundCustom1(-1.0, -1.2, 1L);
        this.assertRoundCustom1(-1.0, -1.2, 2L);
        this.assertRoundCustom1(-2.0, -1.2, 3L);
        this.assertRoundCustom1(-1.0, -1.2, 4L);
        this.assertRoundCustom1(-1.0, -1.2, 5L);
        this.assertRoundCustom1(-1.0, -1.2, 6L);
        this.assertRoundCustom1(-1.0, -1.2, -1L);
        this.assertRoundCustom1(-2.0, -1.5, 0L);
        this.assertRoundCustom1(-1.0, -1.5, 1L);
        this.assertRoundCustom1(-1.0, -1.5, 2L);
        this.assertRoundCustom1(-2.0, -1.5, 3L);
        this.assertRoundCustom1(-2.0, -1.5, 4L);
        this.assertRoundCustom1(-1.0, -1.5, 5L);
        this.assertRoundCustom1(-2.0, -1.5, 6L);
        this.assertRoundCustom1(-1.0, -1.5, -1L);
        this.assertRoundCustom1(-2.0, -1.7, 0L);
        this.assertRoundCustom1(-1.0, -1.7, 1L);
        this.assertRoundCustom1(-1.0, -1.7, 2L);
        this.assertRoundCustom1(-2.0, -1.7, 3L);
        this.assertRoundCustom1(-2.0, -1.7, 4L);
        this.assertRoundCustom1(-2.0, -1.7, 5L);
        this.assertRoundCustom1(-2.0, -1.7, 6L);
        this.assertRoundCustom1(-2.0, -1.7, -1L);
        this.assertRoundCustom1(-3.0, -2.2, 0L);
        this.assertRoundCustom1(-2.0, -2.2, 1L);
        this.assertRoundCustom1(-2.0, -2.2, 2L);
        this.assertRoundCustom1(-3.0, -2.2, 3L);
        this.assertRoundCustom1(-2.0, -2.2, 4L);
        this.assertRoundCustom1(-2.0, -2.2, 5L);
        this.assertRoundCustom1(-2.0, -2.2, 6L);
        this.assertRoundCustom1(-2.0, -2.2, -1L);
        this.assertRoundCustom1(-3.0, -2.5, 0L);
        this.assertRoundCustom1(-2.0, -2.5, 1L);
        this.assertRoundCustom1(-2.0, -2.5, 2L);
        this.assertRoundCustom1(-3.0, -2.5, 3L);
        this.assertRoundCustom1(-3.0, -2.5, 4L);
        this.assertRoundCustom1(-2.0, -2.5, 5L);
        this.assertRoundCustom1(-2.0, -2.5, 6L);
        this.assertRoundCustom1(-2.0, -2.5, -1L);
        this.assertRoundCustom1(-3.0, -2.7, 0L);
        this.assertRoundCustom1(-2.0, -2.7, 1L);
        this.assertRoundCustom1(-2.0, -2.7, 2L);
        this.assertRoundCustom1(-3.0, -2.7, 3L);
        this.assertRoundCustom1(-3.0, -2.7, 4L);
        this.assertRoundCustom1(-3.0, -2.7, 5L);
        this.assertRoundCustom1(-3.0, -2.7, 6L);
        this.assertRoundCustom1(-3.0, -2.7, -1L);
    }

    @Test
    public void testRoundCustom2() throws KettleException {
        this.assertRoundCustom2(2.0, 1.2, 0L, 0L);
        this.assertRoundCustom2(1.0, 1.2, 0L, 1L);
        this.assertRoundCustom2(2.0, 1.2, 0L, 2L);
        this.assertRoundCustom2(1.0, 1.2, 0L, 3L);
        this.assertRoundCustom2(1.0, 1.2, 0L, 4L);
        this.assertRoundCustom2(1.0, 1.2, 0L, 5L);
        this.assertRoundCustom2(1.0, 1.2, 0L, 6L);
        this.assertRoundCustom2(1.0, 1.2, 0L, -1L);
        this.assertRoundCustom2(2.0, 1.5, 0L, 0L);
        this.assertRoundCustom2(1.0, 1.5, 0L, 1L);
        this.assertRoundCustom2(2.0, 1.5, 0L, 2L);
        this.assertRoundCustom2(1.0, 1.5, 0L, 3L);
        this.assertRoundCustom2(2.0, 1.5, 0L, 4L);
        this.assertRoundCustom2(1.0, 1.5, 0L, 5L);
        this.assertRoundCustom2(2.0, 1.5, 0L, 6L);
        this.assertRoundCustom2(2.0, 1.5, 0L, -1L);
        this.assertRoundCustom2(2.0, 1.7, 0L, 0L);
        this.assertRoundCustom2(1.0, 1.7, 0L, 1L);
        this.assertRoundCustom2(2.0, 1.7, 0L, 2L);
        this.assertRoundCustom2(1.0, 1.7, 0L, 3L);
        this.assertRoundCustom2(2.0, 1.7, 0L, 4L);
        this.assertRoundCustom2(2.0, 1.7, 0L, 5L);
        this.assertRoundCustom2(2.0, 1.7, 0L, 6L);
        this.assertRoundCustom2(2.0, 1.7, 0L, -1L);
        this.assertRoundCustom2(3.0, 2.2, 0L, 0L);
        this.assertRoundCustom2(2.0, 2.2, 0L, 1L);
        this.assertRoundCustom2(3.0, 2.2, 0L, 2L);
        this.assertRoundCustom2(2.0, 2.2, 0L, 3L);
        this.assertRoundCustom2(2.0, 2.2, 0L, 4L);
        this.assertRoundCustom2(2.0, 2.2, 0L, 5L);
        this.assertRoundCustom2(2.0, 2.2, 0L, 6L);
        this.assertRoundCustom2(2.0, 2.2, 0L, -1L);
        this.assertRoundCustom2(3.0, 2.5, 0L, 0L);
        this.assertRoundCustom2(2.0, 2.5, 0L, 1L);
        this.assertRoundCustom2(3.0, 2.5, 0L, 2L);
        this.assertRoundCustom2(2.0, 2.5, 0L, 3L);
        this.assertRoundCustom2(3.0, 2.5, 0L, 4L);
        this.assertRoundCustom2(2.0, 2.5, 0L, 5L);
        this.assertRoundCustom2(2.0, 2.5, 0L, 6L);
        this.assertRoundCustom2(3.0, 2.5, 0L, -1L);
        this.assertRoundCustom2(3.0, 2.7, 0L, 0L);
        this.assertRoundCustom2(2.0, 2.7, 0L, 1L);
        this.assertRoundCustom2(3.0, 2.7, 0L, 2L);
        this.assertRoundCustom2(2.0, 2.7, 0L, 3L);
        this.assertRoundCustom2(3.0, 2.7, 0L, 4L);
        this.assertRoundCustom2(3.0, 2.7, 0L, 5L);
        this.assertRoundCustom2(3.0, 2.7, 0L, 6L);
        this.assertRoundCustom2(3.0, 2.7, 0L, -1L);
        this.assertRoundCustom2(-2.0, -1.2, 0L, 0L);
        this.assertRoundCustom2(-1.0, -1.2, 0L, 1L);
        this.assertRoundCustom2(-1.0, -1.2, 0L, 2L);
        this.assertRoundCustom2(-2.0, -1.2, 0L, 3L);
        this.assertRoundCustom2(-1.0, -1.2, 0L, 4L);
        this.assertRoundCustom2(-1.0, -1.2, 0L, 5L);
        this.assertRoundCustom2(-1.0, -1.2, 0L, 6L);
        this.assertRoundCustom2(-1.0, -1.2, 0L, -1L);
        this.assertRoundCustom2(-2.0, -1.5, 0L, 0L);
        this.assertRoundCustom2(-1.0, -1.5, 0L, 1L);
        this.assertRoundCustom2(-1.0, -1.5, 0L, 2L);
        this.assertRoundCustom2(-2.0, -1.5, 0L, 3L);
        this.assertRoundCustom2(-2.0, -1.5, 0L, 4L);
        this.assertRoundCustom2(-1.0, -1.5, 0L, 5L);
        this.assertRoundCustom2(-2.0, -1.5, 0L, 6L);
        this.assertRoundCustom2(-1.0, -1.5, 0L, -1L);
        this.assertRoundCustom2(-2.0, -1.7, 0L, 0L);
        this.assertRoundCustom2(-1.0, -1.7, 0L, 1L);
        this.assertRoundCustom2(-1.0, -1.7, 0L, 2L);
        this.assertRoundCustom2(-2.0, -1.7, 0L, 3L);
        this.assertRoundCustom2(-2.0, -1.7, 0L, 4L);
        this.assertRoundCustom2(-2.0, -1.7, 0L, 5L);
        this.assertRoundCustom2(-2.0, -1.7, 0L, 6L);
        this.assertRoundCustom2(-2.0, -1.7, 0L, -1L);
        this.assertRoundCustom2(-3.0, -2.2, 0L, 0L);
        this.assertRoundCustom2(-2.0, -2.2, 0L, 1L);
        this.assertRoundCustom2(-2.0, -2.2, 0L, 2L);
        this.assertRoundCustom2(-3.0, -2.2, 0L, 3L);
        this.assertRoundCustom2(-2.0, -2.2, 0L, 4L);
        this.assertRoundCustom2(-2.0, -2.2, 0L, 5L);
        this.assertRoundCustom2(-2.0, -2.2, 0L, 6L);
        this.assertRoundCustom2(-2.0, -2.2, 0L, -1L);
        this.assertRoundCustom2(-3.0, -2.5, 0L, 0L);
        this.assertRoundCustom2(-2.0, -2.5, 0L, 1L);
        this.assertRoundCustom2(-2.0, -2.5, 0L, 2L);
        this.assertRoundCustom2(-3.0, -2.5, 0L, 3L);
        this.assertRoundCustom2(-3.0, -2.5, 0L, 4L);
        this.assertRoundCustom2(-2.0, -2.5, 0L, 5L);
        this.assertRoundCustom2(-2.0, -2.5, 0L, 6L);
        this.assertRoundCustom2(-2.0, -2.5, 0L, -1L);
        this.assertRoundCustom2(-3.0, -2.7, 0L, 0L);
        this.assertRoundCustom2(-2.0, -2.7, 0L, 1L);
        this.assertRoundCustom2(-2.0, -2.7, 0L, 2L);
        this.assertRoundCustom2(-3.0, -2.7, 0L, 3L);
        this.assertRoundCustom2(-3.0, -2.7, 0L, 4L);
        this.assertRoundCustom2(-3.0, -2.7, 0L, 5L);
        this.assertRoundCustom2(-3.0, -2.7, 0L, 6L);
        this.assertRoundCustom2(-3.0, -2.7, 0L, -1L);
    }

    public void assertRoundGeneral(final Object expectedResult, int calcFunction, Number value, Long precision, Long roundingMode, int valueDataType, int functionDataType) throws KettleException {
        ValueMetaBigNumber valueMeta;
        final String msg = this.getKettleTypeName(valueDataType) + "->" + this.getKettleTypeName(functionDataType) + " ";
        RowMeta inputRowMeta = new RowMeta();
        ArrayList<Number> inputValues = new ArrayList<Number>(3);
        String fieldValue = "Value";
        switch (valueDataType) {
            case 6: {
                valueMeta = new ValueMetaBigNumber("Value");
                break;
            }
            case 1: {
                valueMeta = new ValueMetaNumber("Value");
                break;
            }
            case 5: {
                valueMeta = new ValueMetaInteger("Value");
                break;
            }
            default: {
                throw new IllegalArgumentException(msg + "Unexpected value dataType: " + value.getClass().getName() + ". Long, Double or BigDecimal expected.");
            }
        }
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        inputValues.add(value);
        if (precision == null) {
            Object fieldPrecision = null;
            Object precisionMeta = null;
        } else {
            String fieldPrecision = "Precision";
            ValueMetaInteger precisionMeta = new ValueMetaInteger(fieldPrecision);
            inputRowMeta.addValueMeta((ValueMetaInterface)precisionMeta);
            inputValues.add(precision);
        }
        if (roundingMode == null) {
            Object fieldRoundingMode = null;
            Object roundingModeMeta = null;
        } else {
            String fieldRoundingMode = "RoundingMode";
            ValueMetaInteger roundingModeMeta = new ValueMetaInteger(fieldRoundingMode);
            inputRowMeta.addValueMeta((ValueMetaInterface)roundingModeMeta);
            inputValues.add(roundingMode);
        }
        RowSet inputRowSet = this.smh.getMockInputRowSet(new Object[][]{inputValues.toArray()});
        inputRowSet.setRowMeta((RowMetaInterface)inputRowMeta);
        String fieldA = inputRowMeta.size() > 0 ? ((ValueMetaInterface)inputRowMeta.getValueMetaList().get(0)).getName() : null;
        String fieldB = inputRowMeta.size() > 1 ? ((ValueMetaInterface)inputRowMeta.getValueMetaList().get(1)).getName() : null;
        String fieldC = inputRowMeta.size() > 2 ? ((ValueMetaInterface)inputRowMeta.getValueMetaList().get(2)).getName() : null;
        int resultDataType = functionDataType;
        String fieldResult = "test";
        final int expectedResultRowSize = inputRowMeta.size() + 1;
        Calculator calculator = new Calculator(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        calculator.getInputRowSets().add(inputRowSet);
        calculator.setInputRowMeta((RowMetaInterface)inputRowMeta);
        calculator.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(new CalculatorMetaFunction[]{new CalculatorMetaFunction("test", calcFunction, fieldA, fieldB, fieldC, resultDataType, 2, 0, false, "", "", "", "")});
        try {
            calculator.addRowListener((RowListener)new RowAdapter(){

                public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    CalculatorUnitTest.assertEquals(msg + " resultRowSize", expectedResultRowSize, rowMeta.size());
                    int fieldResultIndex = rowMeta.size() - 1;
                    CalculatorUnitTest.assertEquals(msg + " fieldResult", "test", rowMeta.getValueMeta(fieldResultIndex).getName());
                    CalculatorUnitTest.assertEquals(msg, expectedResult, row[fieldResultIndex]);
                }
            });
            calculator.processRow((StepMetaInterface)meta, (StepDataInterface)new CalculatorData());
        }
        catch (KettleException ke) {
            ke.printStackTrace();
            Assert.fail((String)(msg + ke.getMessage()));
        }
    }

    public void assertRoundEveryDataType(Number expectedResult, int calcFunction, Number value, Long precision, Long roundingMode) throws KettleException {
        double resultValue = expectedResult.doubleValue();
        this.assertRoundGeneral(resultValue, calcFunction, value.doubleValue(), precision, roundingMode, 1, 1);
        this.assertRoundGeneral(resultValue, calcFunction, new BigDecimal(String.valueOf(value.doubleValue())), precision, roundingMode, 6, 1);
        if (CalculatorUnitTest.isInt(value)) {
            this.assertRoundGeneral(resultValue, calcFunction, value.longValue(), precision, roundingMode, 5, 1);
        }
        Number resultValue2 = BigDecimal.valueOf(expectedResult.doubleValue());
        this.assertRoundGeneral(resultValue2, calcFunction, value.doubleValue(), precision, roundingMode, 1, 6);
        this.assertRoundGeneral(resultValue2, calcFunction, new BigDecimal(String.valueOf(value.doubleValue())), precision, roundingMode, 6, 6);
        if (CalculatorUnitTest.isInt(value)) {
            this.assertRoundGeneral(resultValue2, calcFunction, value.longValue(), precision, roundingMode, 5, 6);
        }
        if (CalculatorUnitTest.isInt(expectedResult)) {
            resultValue2 = expectedResult.longValue();
            this.assertRoundGeneral(resultValue2, calcFunction, value.doubleValue(), precision, roundingMode, 1, 5);
            this.assertRoundGeneral(resultValue2, calcFunction, new BigDecimal(String.valueOf(value.doubleValue())), precision, roundingMode, 6, 5);
            if (CalculatorUnitTest.isInt(value)) {
                this.assertRoundGeneral(resultValue2, calcFunction, value.longValue(), precision, roundingMode, 5, 5);
            }
        }
    }

    public void assertRound1(Number expectedResult, Number value) throws KettleException {
        this.assertRoundEveryDataType(expectedResult, 14, value, null, null);
    }

    public void assertRound2(Number expectedResult, Number value, long precision) throws KettleException {
        this.assertRoundEveryDataType(expectedResult, 15, value, precision, null);
    }

    public void assertRoundStd1(Number expectedResult, Number value) throws KettleException {
        this.assertRoundEveryDataType(expectedResult, 16, value, null, null);
    }

    public void assertRoundStd2(Number expectedResult, Number value, long precision) throws KettleException {
        this.assertRoundEveryDataType(expectedResult, 17, value, precision, null);
    }

    public void assertRoundCustom1(Number expectedResult, Number value, long roundingMode) throws KettleException {
        this.assertRoundEveryDataType(expectedResult, 85, value, null, roundingMode);
    }

    public void assertRoundCustom2(Number expectedResult, Number value, long precision, long roundingMode) throws KettleException {
        this.assertRoundEveryDataType(expectedResult, 86, value, precision, roundingMode);
    }

    private static boolean isInt(Number value) {
        BigDecimal bigDecimalValue;
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof BigInteger) {
            return true;
        }
        if (value instanceof Double || value instanceof Float) {
            bigDecimalValue = new BigDecimal(value.toString());
        } else if (value instanceof BigDecimal) {
            bigDecimalValue = (BigDecimal)value;
        } else {
            throw new IllegalArgumentException("Unexpected dataType: " + value.getClass().getName());
        }
        try {
            bigDecimalValue.longValueExact();
            return true;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    private String getKettleTypeName(int kettleNumberDataType) {
        String kettleNumberDataTypeName;
        switch (kettleNumberDataType) {
            case 6: {
                kettleNumberDataTypeName = "BigNumber(" + kettleNumberDataType + ")";
                break;
            }
            case 1: {
                kettleNumberDataTypeName = "Number(" + kettleNumberDataType + ")";
                break;
            }
            case 5: {
                kettleNumberDataTypeName = "Integer(" + kettleNumberDataType + ")";
                break;
            }
            default: {
                kettleNumberDataTypeName = "?(" + kettleNumberDataType + ")";
            }
        }
        return kettleNumberDataTypeName;
    }

    public static void assertEquals(Object expected, Object actual) {
        CalculatorUnitTest.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, Object expected, Object actual) {
        if (expected instanceof BigDecimal && actual instanceof BigDecimal) {
            if (((BigDecimal)expected).compareTo((BigDecimal)actual) != 0) {
                junit.framework.Assert.assertEquals((String)msg, (Object)expected, (Object)actual);
            }
        } else {
            junit.framework.Assert.assertEquals((String)msg, (Object)expected, (Object)actual);
        }
    }
}

