/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.abort;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.abort.Abort;
import org.pentaho.di.trans.steps.abort.AbortMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class AbortTest {
    private StepMockHelper<AbortMeta, StepDataInterface> stepMockHelper;

    @Before
    public void setup() {
        this.stepMockHelper = new StepMockHelper<AbortMeta, StepDataInterface>("ABORT TEST", AbortMeta.class, StepDataInterface.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testAbortDoesntAbortWithoutInputRow() throws KettleException {
        Abort abort = new Abort(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        abort.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        abort.getInputRowSets().add(this.stepMockHelper.getMockInputRowSet(new Object[0][]));
        Assert.assertFalse((boolean)abort.isStopped());
        abort.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.processRowsStepDataInterface);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).stopAll();
        Assert.assertFalse((boolean)abort.isStopped());
    }

    @Test
    public void testAbortAbortsWithInputRow() throws KettleException {
        Abort abort = new Abort(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        abort.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        abort.getInputRowSets().add(this.stepMockHelper.getMockInputRowSet(new Object[][]{new Object[0]}));
        Assert.assertFalse((boolean)abort.isStopped());
        abort.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.processRowsStepDataInterface);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.times((int)1))).stopAll();
        Assert.assertTrue((boolean)abort.isStopped());
    }
}

