/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.fileinput.NonAccessibleFileObject;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.BasePartitioner;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;

public class BaseStepTest {
    private StepMockHelper<StepMetaInterface, StepDataInterface> mockHelper;

    @Before
    public void setup() {
        this.mockHelper = new StepMockHelper<StepMetaInterface, StepDataInterface>("BASE STEP", StepMetaInterface.class, StepDataInterface.class);
    }

    @After
    public void tearDown() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testBaseStepPutRowLocalSpecialPartitioning() throws KettleException {
        ArrayList<StepMeta> stepMetas = new ArrayList<StepMeta>();
        stepMetas.add(this.mockHelper.stepMeta);
        stepMetas.add(this.mockHelper.stepMeta);
        StepPartitioningMeta stepPartitioningMeta = (StepPartitioningMeta)Mockito.spy((Object)new StepPartitioningMeta());
        BasePartitioner partitioner = (BasePartitioner)Mockito.mock(BasePartitioner.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenAnswer((Answer)new Answer<LogChannelInterface>(){

            public LogChannelInterface answer(InvocationOnMock invocation) throws Throwable {
                ((BaseStep)invocation.getArguments()[0]).getLogLevel();
                return ((BaseStepTest)BaseStepTest.this).mockHelper.logChannelInterface;
            }
        });
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
        Mockito.when((Object)this.mockHelper.transMeta.findNextSteps((StepMeta)Matchers.any(StepMeta.class))).thenReturn(stepMetas);
        Mockito.when((Object)this.mockHelper.stepMeta.getStepPartitioningMeta()).thenReturn((Object)stepPartitioningMeta);
        Mockito.when((Object)stepPartitioningMeta.getPartitioner()).thenReturn((Object)partitioner);
        Mockito.when((Object)partitioner.getNrPartitions()).thenReturn((Object)2);
        String object0 = "name0";
        ValueMetaBase meta0 = new ValueMetaBase(object0.toString());
        String object1 = "name1";
        ValueMetaBase meta2 = new ValueMetaBase(object1.toString());
        RowMeta rowMeta0 = new RowMeta();
        rowMeta0.addValueMeta((ValueMetaInterface)meta0);
        Object[] objects0 = new Object[]{object0};
        RowMeta rowMeta1 = new RowMeta();
        rowMeta1.addValueMeta((ValueMetaInterface)meta2);
        Object[] objects1 = new Object[]{object1};
        Mockito.when((Object)stepPartitioningMeta.getPartition((RowMetaInterface)rowMeta0, objects0)).thenReturn((Object)0);
        Mockito.when((Object)stepPartitioningMeta.getPartition((RowMetaInterface)rowMeta1, objects1)).thenReturn((Object)1);
        BlockingRowSet[] rowSet = new BlockingRowSet[]{new BlockingRowSet(2), new BlockingRowSet(2), new BlockingRowSet(2), new BlockingRowSet(2)};
        ArrayList<BlockingRowSet> outputRowSets = new ArrayList<BlockingRowSet>();
        outputRowSets.addAll(Arrays.asList(rowSet));
        BaseStep baseStep = new BaseStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        baseStep.setStopped(false);
        baseStep.setRepartitioning(2);
        baseStep.setOutputRowSets(outputRowSets);
        baseStep.putRow((RowMetaInterface)rowMeta0, objects0);
        baseStep.putRow((RowMetaInterface)rowMeta1, objects1);
        Assert.assertEquals((Object)object0, (Object)((RowSet)baseStep.getOutputRowSets().get(0)).getRow()[0]);
        Assert.assertEquals((Object)object1, (Object)((RowSet)baseStep.getOutputRowSets().get(1)).getRow()[0]);
        Assert.assertEquals((Object)object0, (Object)((RowSet)baseStep.getOutputRowSets().get(2)).getRow()[0]);
        Assert.assertEquals((Object)object1, (Object)((RowSet)baseStep.getOutputRowSets().get(3)).getRow()[0]);
    }

    @Test
    public void testBaseStepGetLogLevelWontThrowNPEWithNullLog() {
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenAnswer((Answer)new Answer<LogChannelInterface>(){

            public LogChannelInterface answer(InvocationOnMock invocation) throws Throwable {
                ((BaseStep)invocation.getArguments()[0]).getLogLevel();
                return ((BaseStepTest)BaseStepTest.this).mockHelper.logChannelInterface;
            }
        });
        new BaseStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans).getLogLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStepListenersConcurrentModification() throws InterruptedException {
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        final BaseStep baseStep = new BaseStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread addListeners = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!done.get()) {
                    baseStep.addStepListener((StepListener)Mockito.mock(StepListener.class));
                    AtomicBoolean atomicBoolean = done;
                    synchronized (atomicBoolean) {
                        done.notify();
                    }
                }
            }
        };
        try {
            addListeners.start();
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                while (baseStep.getStepListeners().size() < 20) {
                    done.wait();
                }
            }
            baseStep.markStart();
            atomicBoolean = done;
            synchronized (atomicBoolean) {
                while (baseStep.getStepListeners().size() < 100) {
                    done.wait();
                }
            }
            baseStep.markStop();
        }
        finally {
            done.set(true);
            addListeners.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resultFilesMapIsSafeForConcurrentModification() throws Exception {
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        final BaseStep step = new BaseStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        final AtomicBoolean complete = new AtomicBoolean(false);
        int FILES_AMOUNT = 10000;
        Thread filesProducer = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (int i = 0; i < 10000; ++i) {
                        step.addResultFile(new ResultFile(0, (FileObject)new NonAccessibleFileObject(Integer.toString(i)), null, null));
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (Exception e) {
                            Assert.fail((String)e.getMessage());
                        }
                    }
                }
                finally {
                    complete.set(true);
                }
            }
        });
        filesProducer.start();
        try {
            while (!complete.get()) {
                for (Map.Entry entry : step.getResultFiles().entrySet()) {
                    entry.getKey();
                }
            }
        }
        finally {
            filesProducer.join();
        }
    }

    @Test
    public void outputRowMetasAreNotSharedAmongSeveralStreams() throws Exception {
        SingleRowRowSet rs1 = new SingleRowRowSet();
        SingleRowRowSet rs2 = new SingleRowRowSet();
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
        BaseStep baseStep = new BaseStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        baseStep.setStopped(false);
        baseStep.setRepartitioning(0);
        baseStep.setOutputRowSets(Arrays.asList(rs1, rs2));
        for (RowSet rowSet : baseStep.getOutputRowSets()) {
            Assert.assertNull((String)"RowMeta should be null, since no calls were done", (Object)rowSet.getRowMeta());
        }
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("string"));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger("integer"));
        baseStep.putRow((RowMetaInterface)rowMeta, new Object[]{"a", 1});
        RowMetaInterface meta1 = rs1.getRowMeta();
        RowMetaInterface meta2 = rs2.getRowMeta();
        Assert.assertNotNull((Object)meta1);
        Assert.assertNotNull((Object)meta2);
        for (ValueMetaInterface meta : meta1.getValueMetaList()) {
            Assert.assertTrue((String)meta.getName(), (boolean)meta2.exists(meta));
        }
        Assert.assertFalse((meta1 == meta2 ? 1 : 0) != 0);
    }

    @Test
    public void testBuildLog() throws KettleValueException {
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        BaseStep testObject = new BaseStep(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans);
        Date startDate = new Date(123L);
        Date endDate = new Date(125L);
        RowMetaAndData result = testObject.buildLog("myStepName", 13, 123L, 234L, 345L, 456L, 567L, startDate, endDate);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)9L, (long)result.size());
        Assert.assertEquals((long)2L, (long)result.getValueMeta(0).getType());
        Assert.assertEquals((Object)"myStepName", (Object)result.getString(0, "default"));
        Assert.assertEquals((long)1L, (long)result.getValueMeta(1).getType());
        Assert.assertEquals((Object)new Double(13.0), (Object)result.getNumber(1, 0.1));
        Assert.assertEquals((long)1L, (long)result.getValueMeta(2).getType());
        Assert.assertEquals((Object)new Double(123.0), (Object)result.getNumber(2, 0.1));
        Assert.assertEquals((long)1L, (long)result.getValueMeta(3).getType());
        Assert.assertEquals((Object)new Double(234.0), (Object)result.getNumber(3, 0.1));
        Assert.assertEquals((long)1L, (long)result.getValueMeta(4).getType());
        Assert.assertEquals((Object)new Double(345.0), (Object)result.getNumber(4, 0.1));
        Assert.assertEquals((long)1L, (long)result.getValueMeta(5).getType());
        Assert.assertEquals((Object)new Double(456.0), (Object)result.getNumber(5, 0.1));
        Assert.assertEquals((long)1L, (long)result.getValueMeta(6).getType());
        Assert.assertEquals((Object)new Double(567.0), (Object)result.getNumber(6, 0.1));
        Assert.assertEquals((long)3L, (long)result.getValueMeta(7).getType());
        Assert.assertEquals((Object)startDate, (Object)result.getDate(7, Calendar.getInstance().getTime()));
        Assert.assertEquals((long)3L, (long)result.getValueMeta(8).getType());
        Assert.assertEquals((Object)endDate, (Object)result.getDate(8, Calendar.getInstance().getTime()));
    }
}

