/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.OracleDatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryCreationHelper;
import org.pentaho.di.repository.kdr.KettleDatabaseRepositoryMeta;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;

public class KettleDatabaseRepositoryCreationHelperTest {
    private static final int EXPECTED_ORACLE_DB_REPO_STRING = 1999;
    private static final int EXPECTED_DEFAULT_DB_REPO_STRING = 2000;
    private KettleDatabaseRepositoryMeta repositoryMeta;
    private KettleDatabaseRepository repository;
    LogChannelInterface log = LogChannel.GENERAL;
    KettleDatabaseRepositoryCreationHelper helper;
    static String INDEX = "INDEX ";
    private AnswerSecondArgument lan = new AnswerSecondArgument();

    @Before
    public void setUp() throws Exception {
        KettleLogStore.init();
        KettleDatabaseRepositoryConnectionDelegate delegate = (KettleDatabaseRepositoryConnectionDelegate)Mockito.mock(KettleDatabaseRepositoryConnectionDelegate.class);
        this.repository = (KettleDatabaseRepository)Mockito.mock(KettleDatabaseRepository.class);
        this.repository.connectionDelegate = delegate;
        this.helper = new KettleDatabaseRepositoryCreationHelper(this.repository);
        Mockito.when((Object)this.repository.getLog()).thenReturn((Object)this.log);
    }

    @Test
    public void testCreateIndexLenghts() throws KettleException {
        DatabaseMeta meta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        Mockito.when((Object)meta.getStartQuote()).thenReturn((Object)"");
        Mockito.when((Object)meta.getEndQuote()).thenReturn((Object)"");
        Mockito.when((Object)meta.getQuotedSchemaTableCombination(Mockito.anyString(), Mockito.anyString())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return invocation.getArguments()[1].toString();
            }
        });
        Mockito.when((Object)meta.getDatabaseInterface()).thenReturn((Object)new OracleDatabaseMeta());
        Database db = (Database)Mockito.mock(Database.class);
        Mockito.when((Object)db.getDatabaseMeta()).thenReturn((Object)meta);
        Mockito.when((Object)db.getDDL(Mockito.anyString(), (RowMetaInterface)Mockito.any(RowMetaInterface.class), Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyString(), Mockito.anyBoolean())).thenReturn((Object)"### CREATE TABLE;");
        Mockito.when((Object)this.repository.getDatabase()).thenReturn((Object)db);
        Mockito.when((Object)this.repository.getDatabaseMeta()).thenReturn((Object)meta);
        Mockito.when((Object)db.getCreateIndexStatement(Mockito.anyString(), Mockito.anyString(), (String[])Mockito.any(String[].class), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenAnswer((Answer)this.lan);
        KettleDatabaseRepositoryCreationHelper helper = new KettleDatabaseRepositoryCreationHelper(this.repository);
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init((boolean)true);
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
        ArrayList statements = new ArrayList();
        helper.createRepositorySchema(null, false, statements, true);
        for (String st : statements) {
            if (st == null || st.startsWith("#")) continue;
            Assert.assertTrue((String)("Index name is not overlenght!: " + st), (st.length() <= 30 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOracleDBRepoStringLength() throws Exception {
        KettleEnvironment.init();
        DatabaseMeta databaseMeta = new DatabaseMeta("OraRepo", "ORACLE", "JDBC", null, "test", null, null, null);
        this.repositoryMeta = new KettleDatabaseRepositoryMeta("KettleDatabaseRepository", "OraRepo", "Ora Repository", databaseMeta);
        this.repository = new KettleDatabaseRepository();
        this.repository.init((RepositoryMeta)this.repositoryMeta);
        KettleDatabaseRepositoryCreationHelper helper = new KettleDatabaseRepositoryCreationHelper(this.repository);
        int repoStringLength = helper.getRepoStringLength();
        Assert.assertEquals((long)1999L, (long)repoStringLength);
    }

    @Test
    public void testDefaultDBRepoStringLength() throws Exception {
        KettleEnvironment.init();
        DatabaseMeta databaseMeta = new DatabaseMeta();
        databaseMeta.setDatabaseInterface((DatabaseInterface)new TestDatabaseMeta());
        this.repositoryMeta = new KettleDatabaseRepositoryMeta("KettleDatabaseRepository", "TestRepo", "Test Repository", databaseMeta);
        this.repository = new KettleDatabaseRepository();
        this.repository.init((RepositoryMeta)this.repositoryMeta);
        KettleDatabaseRepositoryCreationHelper helper = new KettleDatabaseRepositoryCreationHelper(this.repository);
        int repoStringLength = helper.getRepoStringLength();
        Assert.assertEquals((long)2000L, (long)repoStringLength);
    }

    static class AnswerSecondArgument
    implements Answer<String> {
        AnswerSecondArgument() {
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            if (invocation.getArguments().length < 2) {
                throw new RuntimeException("no cookies!");
            }
            return String.valueOf(invocation.getArguments()[1]);
        }
    }

    class TestDatabaseMeta
    extends OracleDatabaseMeta {
        TestDatabaseMeta() {
        }

        public int getMaxVARCHARLength() {
            return 1;
        }
    }
}

