/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.filerep;

import java.util.UUID;
import org.apache.commons.vfs2.FileObject;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.filerep.KettleFileRepositoryTestBase;

public class KettleFileRepository_DatabaseNames_Test
extends KettleFileRepositoryTestBase {
    @Test
    public void getDatabaseId_ExactMatch() throws Exception {
        String name = UUID.randomUUID().toString();
        DatabaseMeta db = this.saveDatabase(name);
        ObjectId id = this.repository.getDatabaseID(name);
        Assert.assertEquals((Object)db.getObjectId(), (Object)id);
    }

    @Test
    public void getDatabaseId_InsensitiveMatch() throws Exception {
        String name = "databaseWithCamelCase";
        String lookupName = "databaseWithCamelCase".toLowerCase();
        Assert.assertNotSame((Object)lookupName, (Object)"databaseWithCamelCase");
        DatabaseMeta db = this.saveDatabase("databaseWithCamelCase");
        ObjectId id = this.repository.getDatabaseID(lookupName);
        Assert.assertEquals((Object)db.getObjectId(), (Object)id);
    }

    @Test
    public void getDatabaseId_ReturnsExactMatch_PriorToCaseInsensitiveMatch() throws Exception {
        String exact = "databaseExactMatch";
        String similar = "databaseExactMatch".toLowerCase();
        Assert.assertNotSame((Object)similar, (Object)"databaseExactMatch");
        DatabaseMeta db = this.saveDatabase("databaseExactMatch");
        DatabaseMeta another = new DatabaseMeta();
        another.setName(similar);
        FileObject fileObject = this.repository.getFileObject((RepositoryElementInterface)another);
        Assert.assertFalse((boolean)fileObject.exists());
        fileObject.createFile();
        Assert.assertTrue((boolean)fileObject.exists());
        ObjectId id = this.repository.getDatabaseID("databaseExactMatch");
        Assert.assertEquals((Object)db.getObjectId(), (Object)id);
    }

    private DatabaseMeta saveDatabase(String name) throws Exception {
        DatabaseMeta db = new DatabaseMeta();
        db.setName(name);
        this.repository.save((RepositoryElementInterface)db, null, null);
        Assert.assertNotNull((Object)db.getObjectId());
        return db;
    }
}

