/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.trans;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JobEntryTransTest {
    private final String JOB_ENTRY_TRANS_NAME = "JobEntryTransName";
    private final String JOB_ENTRY_FILE_NAME = "JobEntryFileName";
    private final String JOB_ENTRY_FILE_DIRECTORY = "JobEntryFileDirectory";
    private final String JOB_ENTRY_DESCRIPTION = "JobEntryDescription";

    public Node getEntryNode(boolean includeTransname, ObjectLocationSpecificationMethod method) throws ParserConfigurationException, SAXException, IOException {
        JobEntryTrans jobEntryTrans = this.getJobEntryTrans();
        jobEntryTrans.setDescription("JobEntryDescription");
        jobEntryTrans.setFileName("JobEntryFileName");
        jobEntryTrans.setDirectory("JobEntryFileDirectory");
        if (includeTransname) {
            jobEntryTrans.setTransname("JobEntryFileName");
        }
        if (method != null) {
            jobEntryTrans.setSpecificationMethod(method);
        }
        String string = "<job>" + jobEntryTrans.getXML() + "</job>";
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = db.parse(stream);
        Node entryNode = doc.getFirstChild();
        return entryNode;
    }

    private JobEntryTrans getJobEntryTrans() {
        JobEntryTrans jobEntryTrans = new JobEntryTrans("JobEntryTransName");
        return jobEntryTrans;
    }

    private void testJobEntry(Repository rep, boolean includeJobName, ObjectLocationSpecificationMethod method, ObjectLocationSpecificationMethod expectedMethod) throws KettleXMLException, ParserConfigurationException, SAXException, IOException {
        List databases = (List)Mockito.mock(List.class);
        List slaveServers = (List)Mockito.mock(List.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        JobEntryTrans jobEntryTrans = this.getJobEntryTrans();
        jobEntryTrans.loadXML(this.getEntryNode(includeJobName, method), databases, slaveServers, rep, metaStore);
        Assert.assertEquals((String)"If we connect to repository then we use rep_name method", (Object)expectedMethod, (Object)jobEntryTrans.getSpecificationMethod());
    }

    @Test
    public void testChooseSpecMethodByRepositoryConnectionStatus() throws KettleXMLException, ParserConfigurationException, SAXException, IOException {
        Repository rep = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)rep.isConnected()).thenReturn((Object)true);
        this.testJobEntry(null, false, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(null, false, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, true, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(null, true, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, false, null, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, false, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.FILENAME);
        this.testJobEntry(rep, true, null, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.testJobEntry(rep, true, ObjectLocationSpecificationMethod.FILENAME, ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
    }

    @Test
    public void testExecute_result_false_get_transMeta_exception() throws KettleException {
        JobEntryTrans jobEntryTrans = (JobEntryTrans)Mockito.spy((Object)new JobEntryTrans("JobEntryTransName"));
        jobEntryTrans.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        jobEntryTrans.setParentJob((Job)Mockito.mock(Job.class));
        jobEntryTrans.setLogLevel(LogLevel.NOTHING);
        ((JobEntryTrans)Mockito.doThrow((Throwable)new KettleException("Error while loading transformation")).when((Object)jobEntryTrans)).getTransMeta((Repository)Mockito.any(Repository.class), (IMetaStore)Mockito.any(IMetaStore.class), (VariableSpace)Mockito.any(VariableSpace.class));
        Result result = (Result)Mockito.mock(Result.class);
        jobEntryTrans.execute(result, 1);
        ((Result)Mockito.verify((Object)result)).setResult(false);
    }
}

