/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.IdNotFoundException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.exception.LookupReferencesException;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.empty.JobEntryEmpty;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.resource.ResourceNamingInterface;

public class JobMetaTest {
    private JobMeta jm;
    private JobEntryEmpty je1;
    private JobEntryEmpty je2;
    private JobEntryEmpty je4;

    @Before
    public void setUp() {
        this.jm = new JobMeta();
        this.je1 = new JobEntryEmpty();
        this.je1.setName("je1");
        JobEntryCopy copy1 = new JobEntryCopy((JobEntryInterface)this.je1);
        this.je2 = new JobEntryEmpty();
        this.je2.setName("je2");
        JobEntryCopy copy2 = new JobEntryCopy((JobEntryInterface)this.je2);
        JobHopMeta hop = new JobHopMeta(copy1, copy2);
        this.jm.addJobHop(hop);
        JobEntryEmpty je3 = new JobEntryEmpty();
        je3.setName("je3");
        copy2 = new JobEntryCopy((JobEntryInterface)je3);
        hop = new JobHopMeta(copy1, copy2);
        this.jm.addJobHop(hop);
        this.je4 = new JobEntryEmpty();
        this.je4.setName("je4");
        copy1 = new JobEntryCopy((JobEntryInterface)je3);
        copy2 = new JobEntryCopy((JobEntryInterface)this.je4);
        hop = new JobHopMeta(copy1, copy2);
        this.jm.addJobHop(hop);
    }

    @Test
    public void testPathExist() throws KettleXMLException, IOException, URISyntaxException {
        Assert.assertTrue((boolean)this.jm.isPathExist((JobEntryInterface)this.je1, (JobEntryInterface)this.je4));
    }

    @Test
    public void testPathNotExist() throws KettleXMLException, IOException, URISyntaxException {
        Assert.assertFalse((boolean)this.jm.isPathExist((JobEntryInterface)this.je2, (JobEntryInterface)this.je4));
    }

    @Test
    public void testContentChangeListener() throws Exception {
        ContentChangedListener listener = (ContentChangedListener)Mockito.mock(ContentChangedListener.class);
        this.jm.addContentChangedListener(listener);
        this.jm.setChanged();
        this.jm.setChanged(true);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentChanged(Matchers.same((Object)this.jm));
        this.jm.clearChanged();
        this.jm.setChanged(false);
        ((ContentChangedListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).contentSafe(Matchers.same((Object)this.jm));
        this.jm.removeContentChangedListener(listener);
        this.jm.setChanged();
        this.jm.setChanged(true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testLookupRepositoryReferences() throws Exception {
        JobMeta jobMetaMock = (JobMeta)Mockito.mock(JobMeta.class);
        ((JobMeta)Mockito.doCallRealMethod().when((Object)jobMetaMock)).lookupRepositoryReferences((Repository)Mockito.any(Repository.class));
        ((JobMeta)Mockito.doCallRealMethod().when((Object)jobMetaMock)).addJobEntry(Mockito.anyInt(), (JobEntryCopy)Mockito.any(JobEntryCopy.class));
        ((JobMeta)Mockito.doCallRealMethod().when((Object)jobMetaMock)).clear();
        jobMetaMock.clear();
        JobEntryTrans jobEntryMock = (JobEntryTrans)Mockito.mock(JobEntryTrans.class);
        Mockito.when((Object)jobEntryMock.hasRepositoryReferences()).thenReturn((Object)true);
        JobEntryTrans brokenJobEntryMock = (JobEntryTrans)Mockito.mock(JobEntryTrans.class);
        Mockito.when((Object)brokenJobEntryMock.hasRepositoryReferences()).thenReturn((Object)true);
        ((JobEntryTrans)Mockito.doThrow((Throwable)((Throwable)Mockito.mock(IdNotFoundException.class))).when((Object)brokenJobEntryMock)).lookupRepositoryReferences((Repository)Mockito.any(Repository.class));
        JobEntryCopy jobEntryCopy1 = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)jobEntryCopy1.getEntry()).thenReturn((Object)jobEntryMock);
        jobMetaMock.addJobEntry(0, jobEntryCopy1);
        JobEntryCopy jobEntryCopy2 = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)jobEntryCopy2.getEntry()).thenReturn((Object)brokenJobEntryMock);
        jobMetaMock.addJobEntry(1, jobEntryCopy2);
        JobEntryCopy jobEntryCopy3 = (JobEntryCopy)Mockito.mock(JobEntryCopy.class);
        Mockito.when((Object)jobEntryCopy3.getEntry()).thenReturn((Object)jobEntryMock);
        jobMetaMock.addJobEntry(2, jobEntryCopy3);
        Repository repo = (Repository)Mockito.mock(Repository.class);
        try {
            jobMetaMock.lookupRepositoryReferences(repo);
            Assert.fail((String)"no exception for broken entry");
        }
        catch (LookupReferencesException lookupReferencesException) {
            // empty catch block
        }
        ((JobEntryTrans)Mockito.verify((Object)jobEntryMock, (VerificationMode)Mockito.times((int)2))).lookupRepositoryReferences((Repository)Mockito.any(Repository.class));
    }

    @Test
    public void shouldUseExistingRepositoryDirectoryWhenExporting() throws KettleException {
        final JobMeta clone = (JobMeta)Mockito.spy((Object)new JobMeta());
        RepositoryDirectoryInterface directory = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)directory.getPath()).thenReturn((Object)"directoryPath");
        JobMeta jobMeta = new JobMeta(){

            public Object realClone(boolean doClear) {
                return clone;
            }
        };
        jobMeta.setRepositoryDirectory(directory);
        jobMeta.setName("jobName");
        jobMeta.exportResources(null, new HashMap(4), (ResourceNamingInterface)Mockito.mock(ResourceNamingInterface.class), null, null);
        ((JobMeta)Mockito.verify((Object)clone)).setRepositoryDirectory(directory);
    }
}

