/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.util.ConfigurableStreamLogger;

public class ConfigurableStreamLoggerTest {
    public static String INPUT = "str1\nstr2";
    public static String PREFIX = "OUTPUT";
    public static String OUT1 = "OUTPUT str1";
    public static String OUT2 = "OUTPUT str2";
    private ConfigurableStreamLogger streamLogger;
    private LogChannelInterface log;
    private InputStream is;

    @Before
    public void init() throws Exception {
        this.log = (LogChannelInterface)Mockito.mock(LogChannel.class);
        this.is = new ByteArrayInputStream(INPUT.getBytes("UTF-8"));
    }

    @Test
    public void testLogError() {
        this.streamLogger = new ConfigurableStreamLogger(this.log, this.is, LogLevel.ERROR, PREFIX);
        this.streamLogger.run();
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logError(OUT1);
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logError(OUT2);
    }

    @Test
    public void testLogMinimal() {
        this.streamLogger = new ConfigurableStreamLogger(this.log, this.is, LogLevel.MINIMAL, PREFIX);
        this.streamLogger.run();
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logMinimal(OUT1);
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logMinimal(OUT2);
    }

    @Test
    public void testLogBasic() {
        this.streamLogger = new ConfigurableStreamLogger(this.log, this.is, LogLevel.BASIC, PREFIX);
        this.streamLogger.run();
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logBasic(OUT1);
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logBasic(OUT2);
    }

    @Test
    public void testLogDetailed() {
        this.streamLogger = new ConfigurableStreamLogger(this.log, this.is, LogLevel.DETAILED, PREFIX);
        this.streamLogger.run();
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logDetailed(OUT1);
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logDetailed(OUT2);
    }

    @Test
    public void testLogDebug() {
        this.streamLogger = new ConfigurableStreamLogger(this.log, this.is, LogLevel.DEBUG, PREFIX);
        this.streamLogger.run();
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logDebug(OUT1);
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logDebug(OUT2);
    }

    @Test
    public void testLogRowlevel() {
        this.streamLogger = new ConfigurableStreamLogger(this.log, this.is, LogLevel.ROWLEVEL, PREFIX);
        this.streamLogger.run();
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logRowlevel(OUT1);
        ((LogChannelInterface)Mockito.verify((Object)this.log)).logRowlevel(OUT2);
    }
}

