/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.MetricsPainter;
import org.pentaho.di.core.metrics.MetricsDuration;

public class MetricsPainterTest {
    MetricsPainter metricsPainter;
    List<MetricsDuration> durations = null;
    final int heightStub = 0;
    final double pixelsPerMsStub = 0.0;
    final long periodInMsStub = 0L;

    @Before
    public void initialize() {
        this.metricsPainter = (MetricsPainter)Mockito.mock(MetricsPainter.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArgumentExceptionNullArgPaint() {
        this.callPaint(this.durations);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalArgumentExceptionEmptyArgPaint() {
        this.durations = new ArrayList<MetricsDuration>();
        this.callPaint(this.durations);
    }

    @Test(timeout=1000L)
    public void testDrawTimeScaleLineInfinityLoop() {
        GCInterface gCInterfaceMock = (GCInterface)Mockito.mock(GCInterface.class);
        Mockito.when((Object)this.metricsPainter.getGc()).thenReturn((Object)gCInterfaceMock);
        ((MetricsPainter)Mockito.doCallRealMethod().when((Object)this.metricsPainter)).drawTimeScaleLine(0, 0.0, 0L);
        Mockito.when((Object)gCInterfaceMock.textExtent(Matchers.anyString())).thenReturn(Mockito.mock(Point.class));
        this.metricsPainter.drawTimeScaleLine(0, 0.0, 0L);
    }

    private void callPaint(List<MetricsDuration> durations) {
        ((MetricsPainter)Mockito.doCallRealMethod().when((Object)this.metricsPainter)).paint(Matchers.anyListOf(MetricsDuration.class));
        this.metricsPainter.paint(durations);
    }
}

