/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.injection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.injection.MetaBeanLevel1;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanInjector;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;

public class MetaAnnotationInjectionTest {
    private static final String FIELD_ONE = "FIELD_ONE";
    private static final String COMPLEX_NAME = "COMPLEX_NAME";
    private static final String TEST_NAME = "TEST_NAME";

    @Test
    public void testInjectionDescription() throws Exception {
        BeanInjectionInfo ri = new BeanInjectionInfo(MetaBeanLevel1.class);
        Assert.assertEquals((long)3L, (long)ri.getGroups().size());
        Assert.assertEquals((Object)"", (Object)((BeanInjectionInfo.Group)ri.getGroups().get(0)).getName());
        Assert.assertEquals((Object)"FILENAME_LINES", (Object)((BeanInjectionInfo.Group)ri.getGroups().get(1)).getName());
        Assert.assertEquals((Object)"FILENAME_LINES2", (Object)((BeanInjectionInfo.Group)ri.getGroups().get(2)).getName());
        Assert.assertTrue((boolean)ri.getProperties().containsKey("SEPARATOR"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("FILENAME"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("BASE"));
        Assert.assertTrue((boolean)ri.getProperties().containsKey("FIRST"));
        Assert.assertEquals((Object)"FILENAME_LINES", (Object)((BeanInjectionInfo.Property)ri.getProperties().get("FILENAME")).getGroupName());
    }

    @Test
    public void testInjectionSets() throws Exception {
        MetaBeanLevel1 obj = new MetaBeanLevel1();
        RowMeta meta = new RowMeta();
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString("f1"));
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString("f2"));
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString("fstrint"));
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString("fstrlong"));
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString("fstrboolean"));
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        rows.add(new RowMetaAndData((RowMetaInterface)meta, new Object[]{"<sep>", "/tmp/file.txt", "123", "1234567891213", "y"}));
        rows.add(new RowMetaAndData((RowMetaInterface)meta, new Object[]{"<sep>", "/tmp/file2.txt", "123", "1234567891213", "y"}));
        BeanInjector inj = MetaAnnotationInjectionTest.buildBeanInjectorFor(MetaBeanLevel1.class);
        inj.setProperty((Object)obj, "SEPARATOR", rows, "f1");
        inj.setProperty((Object)obj, "FILENAME", rows, "f2");
        inj.setProperty((Object)obj, "FILENAME_ARRAY", rows, "f2");
        inj.setProperty((Object)obj, "FBOOLEAN", rows, "fstrboolean");
        inj.setProperty((Object)obj, "FINT", rows, "fstrint");
        inj.setProperty((Object)obj, "FLONG", rows, "fstrlong");
        inj.setProperty((Object)obj, "FIRST", rows, "fstrint");
        Assert.assertEquals((Object)"<sep>", (Object)obj.getSub().getSeparator());
        Assert.assertEquals((Object)"/tmp/file.txt", (Object)obj.getSub().getFiles()[0].getName());
        Assert.assertTrue((boolean)obj.fboolean);
        Assert.assertEquals((long)123L, (long)obj.fint);
        Assert.assertEquals((long)1234567891213L, (long)obj.flong);
        Assert.assertEquals((Object)"123", (Object)obj.getSub().first());
        Assert.assertArrayEquals((Object[])new String[]{"/tmp/file.txt", "/tmp/file2.txt"}, (Object[])obj.getSub().getFilenames());
    }

    @Test
    public void testInjectionForArrayPropertyWithoutDefaultConstructor_class_parameter() throws KettleException {
        BeanInjector beanInjector = MetaAnnotationInjectionTest.buildBeanInjectorFor(MetadataBean.class);
        MetadataBean targetBean = new MetadataBean();
        beanInjector.setProperty((Object)targetBean, COMPLEX_NAME, MetaAnnotationInjectionTest.createRowMetaAndData(), FIELD_ONE);
        Assert.assertNotNull((Object)targetBean.getComplexField());
        Assert.assertTrue((targetBean.getComplexField().length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_NAME, (Object)targetBean.getComplexField()[0].getFieldName());
    }

    @Test
    public void testInjectionForArrayPropertyWithoutDefaultConstructor_interface_parameter() throws KettleException {
        BeanInjector beanInjector = MetaAnnotationInjectionTest.buildBeanInjectorFor(MetadataBeanImplementsInterface.class);
        MetadataBeanImplementsInterface targetBean = new MetadataBeanImplementsInterface();
        beanInjector.setProperty((Object)targetBean, COMPLEX_NAME, MetaAnnotationInjectionTest.createRowMetaAndData(), FIELD_ONE);
        Assert.assertNotNull((Object)targetBean.getComplexField());
        Assert.assertTrue((targetBean.getComplexField().length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)TEST_NAME, (Object)targetBean.getComplexField()[0].getFieldName());
    }

    private static BeanInjector buildBeanInjectorFor(Class<?> clazz) {
        BeanInjectionInfo metaBeanInfo = new BeanInjectionInfo(clazz);
        return new BeanInjector(metaBeanInfo);
    }

    private static List<RowMetaAndData> createRowMetaAndData() {
        RowMeta meta = new RowMeta();
        meta.addValueMeta((ValueMetaInterface)new ValueMetaString(FIELD_ONE));
        return Collections.singletonList(new RowMetaAndData((RowMetaInterface)meta, new Object[]{TEST_NAME}));
    }

    public static class ComplexFieldWithInterfaceArg {
        @Injection(name="COMPLEX_NAME", group="COMPLEX")
        private String fieldName;
        private final MetadataInterface parentMeta;

        public ComplexFieldWithInterfaceArg(MetadataInterface parentMeta) {
            this.parentMeta = parentMeta;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public MetadataInterface getParentMeta() {
            return this.parentMeta;
        }
    }

    @InjectionSupported(localizationPrefix="", groups={"COMPLEX"})
    public static class MetadataBeanImplementsInterface
    implements MetadataInterface {
        @InjectionDeep
        private ComplexFieldWithInterfaceArg[] complexField;

        public ComplexFieldWithInterfaceArg[] getComplexField() {
            return this.complexField;
        }

        public void setComplexField(ComplexFieldWithInterfaceArg[] complexField) {
            this.complexField = complexField;
        }
    }

    public static class ComplexField {
        @Injection(name="COMPLEX_NAME", group="COMPLEX")
        private String fieldName;
        private final MetadataBean parentMeta;

        public ComplexField(MetadataBean parentMeta) {
            this.parentMeta = parentMeta;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public MetadataBean getParentMeta() {
            return this.parentMeta;
        }
    }

    @InjectionSupported(localizationPrefix="", groups={"COMPLEX"})
    public static class MetadataBean {
        @InjectionDeep
        private ComplexField[] complexField;

        public ComplexField[] getComplexField() {
            return this.complexField;
        }

        public void setComplexField(ComplexField[] complexField) {
            this.complexField = complexField;
        }
    }

    private static interface MetadataInterface {
    }
}

