/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.snappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.compress.CompressionProvider;
import org.pentaho.di.core.compress.CompressionProviderFactory;
import org.pentaho.di.core.compress.snappy.SnappyCompressionInputStream;
import org.pentaho.di.core.compress.snappy.SnappyCompressionOutputStream;
import org.pentaho.di.core.compress.snappy.SnappyCompressionProvider;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyCompressionProviderTest {
    public static final String PROVIDER_NAME = "Snappy";
    public CompressionProviderFactory factory = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.factory = CompressionProviderFactory.getInstance();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCtor() {
        SnappyCompressionProvider ncp = new SnappyCompressionProvider();
        Assert.assertNotNull((Object)ncp);
    }

    @Test
    public void testGetName() {
        SnappyCompressionProvider provider = (SnappyCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertNotNull((Object)provider);
        Assert.assertEquals((Object)PROVIDER_NAME, (Object)provider.getName());
    }

    @Test
    public void testGetProviderAttributes() {
        SnappyCompressionProvider provider = (SnappyCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        Assert.assertEquals((Object)"Snappy compression", (Object)provider.getDescription());
        Assert.assertTrue((boolean)provider.supportsInput());
        Assert.assertTrue((boolean)provider.supportsOutput());
        Assert.assertNull((Object)provider.getDefaultExtension());
    }

    @Test
    public void testCreateInputStream() throws IOException {
        SnappyCompressionProvider provider = (SnappyCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        SnappyInputStream in = this.createSnappyInputStream();
        SnappyCompressionInputStream inStream = new SnappyCompressionInputStream((InputStream)in, (CompressionProvider)provider);
        Assert.assertNotNull((Object)inStream);
        SnappyCompressionInputStream ncis = provider.createInputStream((InputStream)in);
        Assert.assertNotNull((Object)ncis);
    }

    @Test
    public void testCreateOutputStream() throws IOException {
        SnappyCompressionProvider provider = (SnappyCompressionProvider)this.factory.getCompressionProviderByName(PROVIDER_NAME);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SnappyCompressionOutputStream outStream = new SnappyCompressionOutputStream((OutputStream)out, (CompressionProvider)provider);
        Assert.assertNotNull((Object)outStream);
        SnappyCompressionOutputStream ncis = provider.createOutputStream((OutputStream)out);
        Assert.assertNotNull((Object)ncis);
    }

    private SnappyInputStream createSnappyInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SnappyOutputStream sos = new SnappyOutputStream((OutputStream)baos);
        byte[] testBytes = "Test".getBytes();
        sos.write(testBytes);
        ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
        sos.close();
        return new SnappyInputStream((InputStream)in);
    }
}

