/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.EnvUtil;

public class SlaveServerTest {
    SlaveServer slaveServer;

    @BeforeClass
    public static void beforeClass() throws KettleException {
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init();
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
    }

    @Before
    public void init() throws IOException {
        HttpClient httpClient = (HttpClient)Mockito.spy((Object)new HttpClient());
        ((HttpClient)Mockito.doReturn((Object)404).when((Object)httpClient)).executeMethod((HttpMethod)Matchers.any(HttpMethod.class));
        this.slaveServer = (SlaveServer)Mockito.spy((Object)new SlaveServer());
        ((SlaveServer)Mockito.doReturn((Object)httpClient).when((Object)this.slaveServer)).getHttpClient();
        ((SlaveServer)Mockito.doReturn((Object)"response_body").when((Object)this.slaveServer)).getResponseBodyAsString((InputStream)Matchers.any(InputStream.class));
    }

    @Test(expected=KettleException.class)
    public void testExecService() throws Exception {
        ((SlaveServer)Mockito.doReturn((Object)Mockito.mock(GetMethod.class)).when((Object)this.slaveServer)).buildExecuteServiceMethod(Matchers.anyString(), Matchers.anyMapOf(String.class, String.class));
        this.slaveServer.execService("wrong_app_name");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test(expected=KettleException.class)
    public void testSendXML() throws Exception {
        ((SlaveServer)Mockito.doReturn((Object)Mockito.mock(PostMethod.class)).when((Object)this.slaveServer)).buildSendXMLMethod((byte[])Matchers.any(byte[].class), Matchers.anyString());
        this.slaveServer.sendXML("", "");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test(expected=KettleException.class)
    public void testSendExport() throws Exception {
        ((SlaveServer)Mockito.doReturn((Object)Mockito.mock(PostMethod.class)).when((Object)this.slaveServer)).buildSendExportMethod(Matchers.anyString(), Matchers.anyString(), (InputStream)Matchers.any(InputStream.class));
        File tempFile = File.createTempFile("PDI-", "tmp");
        tempFile.deleteOnExit();
        this.slaveServer.sendExport(tempFile.getAbsolutePath(), "", "");
        Assert.fail((String)"Incorrect connection details had been used, but no exception was thrown");
    }

    @Test
    public void testAddCredentials() {
        this.slaveServer.setUsername("test_username");
        this.slaveServer.setPassword("test_password");
        this.slaveServer.setHostname("test_host");
        this.slaveServer.setPort("8081");
        HttpClient client = this.slaveServer.getHttpClient();
        this.slaveServer.addCredentials(client);
        HttpClient authClient = this.slaveServer.getHttpClient();
        Assert.assertTrue((boolean)authClient.getParams().isAuthenticationPreemptive());
        AuthScope scope = new AuthScope(this.slaveServer.getHostname(), Const.toInt((String)this.slaveServer.getPort(), (int)80));
        Credentials credentials = authClient.getState().getCredentials(scope);
        Assert.assertNotNull((Object)credentials);
        Assert.assertTrue((boolean)(credentials instanceof UsernamePasswordCredentials));
        UsernamePasswordCredentials baseCredentials = (UsernamePasswordCredentials)credentials;
        Assert.assertEquals((Object)this.slaveServer.getUsername(), (Object)baseCredentials.getUserName());
        Assert.assertEquals((Object)this.slaveServer.getPassword(), (Object)baseCredentials.getPassword());
    }

    @Test
    public void testModifyingName() {
        this.slaveServer.setName("test");
        ArrayList<SlaveServer> list = new ArrayList<SlaveServer>();
        list.add(this.slaveServer);
        SlaveServer slaveServer2 = (SlaveServer)Mockito.spy((Object)new SlaveServer());
        slaveServer2.setName("test");
        slaveServer2.verifyAndModifySlaveServerName(list, null);
        Assert.assertTrue((!this.slaveServer.getName().equals(slaveServer2.getName()) ? 1 : 0) != 0);
    }
}

