/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.servicecoordination.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleEvent;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleListener;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleManager;
import org.pentaho.platform.servicecoordination.impl.CountdownLatchLifecycleEvent;

public abstract class BaseCountdownLatchLifecycleManager<T>
implements IPhasedLifecycleManager<T> {
    private int phase;
    private List<IPhasedLifecycleListener<T>> listeners = new ArrayList<IPhasedLifecycleListener<T>>();
    private CountDownLatch latch = new CountDownLatch(0);
    private Thread lockingThread;
    private Executor executorService;
    private boolean terminated;

    public BaseCountdownLatchLifecycleManager() {
    }

    public BaseCountdownLatchLifecycleManager(List<IPhasedLifecycleListener<T>> listeners) {
        this.listeners = listeners;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public void addLifecycleListener(IPhasedLifecycleListener<T> listener) {
        this.checkTerminated();
        this.listeners.add(listener);
    }

    @Override
    public void removeLifecycleListener(IPhasedLifecycleListener<T> listener) {
        this.checkTerminated();
        this.listeners.remove(listener);
    }

    @Override
    public int getListenerCount() {
        this.checkTerminated();
        return this.listeners.size();
    }

    @Override
    public synchronized int advanceAndWait() throws InterruptedException {
        this.checkTerminated();
        this.latch.await();
        ++this.phase;
        this.notifyListenersAndWait();
        return this.phase;
    }

    @Override
    public synchronized int retreatAndWait() throws InterruptedException {
        this.checkTerminated();
        this.latch.await();
        if (this.phase - 1 < 0) {
            return 0;
        }
        --this.phase;
        this.notifyListenersAndWait();
        return this.phase;
    }

    @Override
    public synchronized void setPhaseAndWait(int phase) throws InterruptedException {
        this.checkTerminated();
        this.latch.await();
        this.phase = phase;
        this.notifyListenersAndWait();
    }

    @Override
    public synchronized int advance() throws InterruptedException {
        this.checkTerminated();
        this.latch.await();
        ++this.phase;
        this.notifyListeners();
        return this.phase;
    }

    @Override
    public synchronized int retreat() throws InterruptedException {
        this.checkTerminated();
        this.latch.await();
        if (this.phase - 1 < 0) {
            return 0;
        }
        --this.phase;
        this.notifyListeners();
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        this.checkTerminated();
        this.terminated = true;
        try {
            if (this.lockingThread != null) {
                this.lockingThread.interrupt();
            }
        }
        finally {
            this.lockingThread = null;
        }
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersAndWait() throws InterruptedException {
        try {
            this.lockingThread = Thread.currentThread();
            this.notifyListeners();
            this.latch.await();
        }
        finally {
            this.lockingThread = null;
        }
    }

    private void notifyListeners() {
        this.latch = new CountDownLatch(this.listeners.size());
        for (IPhasedLifecycleListener<T> listener : this.listeners) {
            CountdownLatchLifecycleEvent<T> event = new CountdownLatchLifecycleEvent<T>(this.phase, this.getNotificationObject(), this.latch, this);
            this.getExecutor().execute(new EventRunnable<T>(listener, event));
        }
    }

    protected abstract T getNotificationObject();

    @Override
    public synchronized void setPhase(int phase) {
        this.checkTerminated();
        this.phase = phase;
        this.notifyListeners();
    }

    @Override
    public void setExecutor(Executor executorService) {
        this.checkTerminated();
        this.executorService = executorService;
    }

    public Executor getExecutor() {
        if (this.executorService == null) {
            this.executorService = new SynchronousExecutor();
        }
        return this.executorService;
    }

    private void checkTerminated() {
        if (this.terminated) {
            throw new IllegalStateException("Manager has been terminated");
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private static class EventRunnable<T>
    implements Runnable {
        IPhasedLifecycleListener<T> listener;
        IPhasedLifecycleEvent<T> event;

        public EventRunnable(IPhasedLifecycleListener<T> listener, IPhasedLifecycleEvent<T> event) {
            this.listener = listener;
            this.event = event;
        }

        @Override
        public void run() {
            this.listener.onPhaseChange(this.event);
        }
    }
}

