/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Stroke;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Second;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.jfree.util.Log;
import org.pentaho.reporting.engine.classic.core.util.StrokeUtility;

public final class ChartConstants {
    public static final String DIAL_CHART_STR = "DialChart";
    public static final String PIE_CHART_STR = "PieChart";
    public static final String PIE_GRID_CHART_STR = "PieGrid";
    public static final String BAR_CHART_STR = "BarChart";
    public static final String LINE_CHART_STR = "LineChart";
    public static final String AREA_CHART_STR = "AreaChart";
    public static final String STEP_CHART_STR = "StepChart";
    public static final String STEP_AREA_CHART_STR = "StepAreaChart";
    public static final String DIFFERENCE_CHART_STR = "DifferenceChart";
    public static final String DOT_CHART_STR = "DotChart";
    public static final String BAR_LINE_CHART_STR = "BarLineChart";
    public static final String BUBBLE_CHART_STR = "BubbleChart";
    public static final int UNDEFINED_CHART_TYPE = -1;
    public static final int DIAL_CHART_TYPE = 0;
    public static final int THERMOMETER_CHART_TYPE = 1;
    public static final int PIE_CHART_TYPE = 2;
    public static final int PIE_GRID_CHART_TYPE = 3;
    public static final int BAR_CHART_TYPE = 4;
    public static final int LINE_CHART_TYPE = 5;
    public static final int AREA_CHART_TYPE = 6;
    public static final int STEP_CHART_TYPE = 7;
    public static final int STEP_AREA_CHART_TYPE = 8;
    public static final int DIFFERENCE_CHART_TYPE = 9;
    public static final int DOT_CHART_TYPE = 10;
    public static final int BAR_LINE_CHART_TYPE = 11;
    public static final int BUBBLE_CHART_TYPE = 12;
    public static final String XY_SERIES_COLLECTION_STR = "XYSeriesCollection";
    public static final String XYZ_SERIES_COLLECTION_STR = "XYZSeriesCollection";
    public static final String TIME_SERIES_COLLECTION_STR = "TimeSeriesCollection";
    public static final String CATAGORY_DATASET_STR = "CategoryDataset";
    public static final String DAY_PERIOD_TYPE_STR = "Day";
    public static final String FIXEDMILLISECOND_PERIOD_TYPE_STR = "FixedMillisecond";
    public static final String HOUR_PERIOD_TYPE_STR = "Hour";
    public static final String MILLISECOND_PERIOD_TYPE_STR = "Millisecond";
    public static final String MINUTE_PERIOD_TYPE_STR = "Minute";
    public static final String MONTH_PERIOD_TYPE_STR = "Month";
    public static final String QUARTER_PERIOD_TYPE_STR = "Quarter";
    public static final String SECOND_PERIOD_TYPE_STR = "Second";
    public static final String WEEK_PERIOD_TYPE_STR = "Week";
    public static final String YEAR_PERIOD_TYPE_STR = "Year";
    public static final String VERTICAL_ORIENTATION = "Vertical";
    public static final String HORIZONTAL_ORIENTATION = "Horizontal";
    public static final String LINE_STYLE_SOLID_STR = "solid";
    public static final String LINE_STYLE_DASH_STR = "dash";
    public static final String LINE_STYLE_DOT_STR = "dot";
    public static final String LINE_STYLE_DASHDOT_STR = "dashdot";
    public static final String LINE_STYLE_DASHDOTDOT_STR = "dashdotdot";

    private ChartConstants() {
    }

    public static String getChartTypeName(int type) {
        String rtn = "";
        switch (type) {
            case 2: {
                rtn = PIE_CHART_STR;
                break;
            }
            case 3: {
                rtn = PIE_GRID_CHART_STR;
                break;
            }
            case 4: {
                rtn = BAR_CHART_STR;
                break;
            }
            case 5: {
                rtn = LINE_CHART_STR;
                break;
            }
            case 11: {
                rtn = BAR_LINE_CHART_STR;
                break;
            }
            case 12: {
                rtn = BUBBLE_CHART_STR;
                break;
            }
            case 0: {
                rtn = DIAL_CHART_STR;
                break;
            }
            case 9: {
                rtn = DIFFERENCE_CHART_STR;
                break;
            }
            case 10: {
                rtn = DOT_CHART_STR;
                break;
            }
            case 8: {
                rtn = STEP_AREA_CHART_STR;
                break;
            }
            case 7: {
                rtn = STEP_CHART_STR;
                break;
            }
            case 6: {
                rtn = AREA_CHART_STR;
                break;
            }
        }
        return rtn;
    }

    public static Class getTimePeriodClass(String timePeriodStr) {
        Class<Millisecond> retClass = Millisecond.class;
        if (timePeriodStr.equalsIgnoreCase(SECOND_PERIOD_TYPE_STR)) {
            retClass = Second.class;
        } else if (timePeriodStr.equalsIgnoreCase(MINUTE_PERIOD_TYPE_STR)) {
            retClass = Minute.class;
        } else if (timePeriodStr.equalsIgnoreCase(HOUR_PERIOD_TYPE_STR)) {
            retClass = Hour.class;
        } else if (timePeriodStr.equalsIgnoreCase(DAY_PERIOD_TYPE_STR)) {
            retClass = Day.class;
        } else if (timePeriodStr.equalsIgnoreCase(WEEK_PERIOD_TYPE_STR)) {
            retClass = Week.class;
        } else if (timePeriodStr.equalsIgnoreCase(MONTH_PERIOD_TYPE_STR)) {
            retClass = Month.class;
        } else if (timePeriodStr.equalsIgnoreCase(QUARTER_PERIOD_TYPE_STR)) {
            retClass = Quarter.class;
        } else if (timePeriodStr.equalsIgnoreCase(YEAR_PERIOD_TYPE_STR)) {
            retClass = Year.class;
        }
        return retClass;
    }

    public static Stroke translateLineStyle(float lineWidth, String lineStyle) {
        if (lineWidth < 0.0f) {
            Log.error((Object)"LineChartExpression.ERROR_0001_INVALID_LINE_WIDTH");
            lineWidth = 1.0f;
        }
        int strokeType = LINE_STYLE_DASH_STR.equals(lineStyle) ? 1 : (LINE_STYLE_DOT_STR.equals(lineStyle) ? 2 : (LINE_STYLE_DASHDOT_STR.equals(lineStyle) ? 3 : (LINE_STYLE_DASHDOTDOT_STR.equals(lineStyle) ? 4 : (lineWidth == 0.0f ? 5 : 0))));
        return StrokeUtility.createStroke((int)strokeType, (float)lineWidth);
    }
}

