/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.timestamp.SimpleTimestampFormat;

public class ValueMetaTimestamp
extends ValueMetaDate {
    public ValueMetaTimestamp() {
        this((String)null);
    }

    public ValueMetaTimestamp(String name) {
        super(name, 9);
    }

    @Override
    public boolean isDate() {
        return true;
    }

    @Override
    public Date getDate(Object object) throws KettleValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        return timestamp;
    }

    @Override
    public Long getInteger(Object object) throws KettleValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        long ms = timestamp.getTime();
        return ms;
    }

    @Override
    public Double getNumber(Object object) throws KettleValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        long ms = timestamp.getTime();
        return Long.valueOf(ms).doubleValue();
    }

    @Override
    public BigDecimal getBigNumber(Object object) throws KettleValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        BigDecimal nanos = BigDecimal.valueOf(timestamp.getTime()).multiply(BigDecimal.valueOf(1000000000L)).add(BigDecimal.valueOf(timestamp.getNanos()));
        return nanos;
    }

    @Override
    public Boolean getBoolean(Object object) throws KettleValueException {
        throw new KettleValueException(this.toStringMeta() + ": it's not possible to convert from Timestamp to Boolean");
    }

    @Override
    public String getString(Object object) throws KettleValueException {
        return this.convertTimestampToString(this.getTimestamp(object));
    }

    public Timestamp getTimestamp(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 9: {
                switch (this.storageType) {
                    case 0: {
                        return (Timestamp)object;
                    }
                    case 1: {
                        return (Timestamp)this.convertBinaryStringToNativeType((byte[])object);
                    }
                    case 2: {
                        return (Timestamp)this.index[(Integer)object];
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToTimestamp((String)object);
                    }
                    case 1: {
                        return this.convertStringToTimestamp((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToTimestamp((String)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertNumberToTimestamp((Double)object);
                    }
                    case 1: {
                        return this.convertNumberToTimestamp((Double)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertNumberToTimestamp((Double)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 5: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertIntegerToTimestamp((Long)object);
                    }
                    case 1: {
                        return this.convertIntegerToTimestamp((Long)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertIntegerToTimestamp((Long)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 6: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertBigNumberToTimestamp((BigDecimal)object);
                    }
                    case 1: {
                        return this.convertBigNumberToTimestamp((BigDecimal)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertBigNumberToTimestamp((BigDecimal)this.index[(Integer)object]);
                    }
                }
                throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 4: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a boolean to a timestamp.");
            }
            case 8: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a binary value to timestamp.");
            }
            case 7: {
                throw new KettleValueException(this.toString() + " : I don't know how to convert a serializable value to timestamp.");
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    @Override
    public int compare(Object data1, Object data2) throws KettleValueException {
        Timestamp timestamp1 = this.getTimestamp(data1);
        Timestamp timestamp2 = this.getTimestamp(data2);
        int cmp = 0;
        cmp = timestamp1 == null ? (timestamp2 == null ? 0 : -1) : (timestamp2 == null ? 1 : timestamp1.compareTo(timestamp2));
        if (this.isSortedDescending()) {
            return -cmp;
        }
        return cmp;
    }

    protected Timestamp convertBigNumberToTimestamp(BigDecimal bd) {
        if (bd == null) {
            return null;
        }
        return this.convertIntegerToTimestamp(bd.longValue());
    }

    protected Timestamp convertNumberToTimestamp(Double d) {
        if (d == null) {
            return null;
        }
        long nanos = d.longValue();
        return this.convertIntegerToTimestamp(nanos);
    }

    protected Timestamp convertIntegerToTimestamp(Long nanos) {
        if (nanos == null) {
            return null;
        }
        long msSinceEpoch = nanos / 1000000L;
        int leftNanos = (int)(nanos - msSinceEpoch * 1000000L);
        Timestamp timestamp = new Timestamp(msSinceEpoch);
        timestamp.setNanos(leftNanos);
        return timestamp;
    }

    protected synchronized Timestamp convertStringToTimestamp(String string) throws KettleValueException {
        Timestamp returnValue;
        if (Const.isEmpty(string = Const.trimToType(string, this.getTrimType()))) {
            return null;
        }
        try {
            returnValue = Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            try {
                returnValue = (Timestamp)this.getDateFormat().parse(string);
            }
            catch (ParseException ex) {
                throw new KettleValueException(this.toString() + " : couldn't convert string [" + string + "] to a timestamp, expecting format [yyyy-mm-dd hh:mm:ss.ffffff]", e);
            }
        }
        return returnValue;
    }

    protected synchronized String convertTimestampToString(Timestamp timestamp) throws KettleValueException {
        if (timestamp == null) {
            return null;
        }
        return this.getDateFormat().format(timestamp);
    }

    @Override
    public Object convertDataFromString(String pol, ValueMetaInterface convertMeta, String nullIf, String ifNull, int trim_type) throws KettleValueException {
        String null_value = nullIf;
        if (null_value == null) {
            switch (convertMeta.getType()) {
                case 4: {
                    null_value = "";
                    break;
                }
                case 2: {
                    null_value = "";
                    break;
                }
                case 6: {
                    null_value = "";
                    break;
                }
                case 1: {
                    null_value = "";
                    break;
                }
                case 5: {
                    null_value = "";
                    break;
                }
                case 3: {
                    null_value = "";
                    break;
                }
                case 8: {
                    null_value = "";
                    break;
                }
                default: {
                    null_value = "";
                }
            }
        }
        if (!Const.isEmpty(ifNull) && (Const.isEmpty(pol) || pol.equalsIgnoreCase(Const.rightPad(new StringBuffer(null_value), pol.length())))) {
            pol = ifNull;
        }
        if (Const.isEmpty(pol)) {
            return null;
        }
        if (!Const.isEmpty(null_value) ? null_value.length() <= pol.length() && pol.equalsIgnoreCase(Const.rightPad(new StringBuffer(null_value), pol.length())) : Const.onlySpaces(pol)) {
            return null;
        }
        switch (trim_type) {
            case 1: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                pol = strpol.toString();
                break;
            }
            case 2: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
            case 3: {
                StringBuffer strpol = new StringBuffer(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
        }
        return this.convertData(convertMeta, pol);
    }

    public Timestamp convertDateToTimestamp(Date date) throws KettleValueException {
        if (date == null) {
            return null;
        }
        Timestamp result = null;
        result = date instanceof Timestamp ? (Timestamp)date : new Timestamp(date.getTime());
        return result;
    }

    @Override
    public Object convertData(ValueMetaInterface meta2, Object data2) throws KettleValueException {
        switch (meta2.getType()) {
            case 2: {
                return this.convertStringToTimestamp(meta2.getString(data2));
            }
            case 5: {
                return this.convertIntegerToTimestamp(meta2.getInteger(data2));
            }
            case 1: {
                return this.convertNumberToTimestamp(meta2.getNumber(data2));
            }
            case 3: {
                return this.convertDateToTimestamp(meta2.getDate(data2));
            }
            case 6: {
                return this.convertBigNumberToTimestamp(meta2.getBigNumber(data2));
            }
        }
        throw new KettleValueException(meta2.toStringMeta() + " : can't be converted to a timestamp");
    }

    @Override
    public Object cloneValueData(Object object) throws KettleValueException {
        Timestamp timestamp = this.getTimestamp(object);
        if (timestamp == null) {
            return null;
        }
        Timestamp clone = new Timestamp(timestamp.getTime());
        clone.setNanos(timestamp.getNanos());
        return clone;
    }

    @Override
    public ValueMetaInterface getValueFromSQLType(DatabaseMeta databaseMeta, String name, ResultSetMetaData rm, int index, boolean ignoreLength, boolean lazyConversion) throws KettleDatabaseException {
        try {
            int type = rm.getColumnType(index);
            if (type == 93) {
                int length = rm.getScale(index);
                ValueMetaDate valueMeta = databaseMeta.supportsTimestampDataType() ? new ValueMetaTimestamp(name) : new ValueMetaDate(name);
                valueMeta.setLength(length);
                this.getOriginalColumnMetadata(valueMeta, rm, index, ignoreLength);
                return valueMeta;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error evaluating timestamp value metadata", e);
        }
    }

    @Override
    public Object getValueFromResultSet(DatabaseInterface databaseInterface, ResultSet resultSet, int index) throws KettleDatabaseException {
        try {
            return resultSet.getTimestamp(index + 1);
        }
        catch (Exception e) {
            throw new KettleDatabaseException(this.toStringMeta() + " : Unable to get timestamp from resultset at index " + index, e);
        }
    }

    @Override
    public void setPreparedStatementValue(DatabaseMeta databaseMeta, PreparedStatement preparedStatement, int index, Object data) throws KettleDatabaseException {
        try {
            if (data != null) {
                preparedStatement.setTimestamp(index, this.getTimestamp(data));
            } else {
                preparedStatement.setNull(index, 93);
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException(this.toStringMeta() + " : Unable to set value on prepared statement on index " + index, e);
        }
    }

    @Override
    public Object convertDataUsingConversionMetaData(Object data2) throws KettleValueException {
        if (this.conversionMetadata == null) {
            throw new KettleValueException("API coding error: please specify the conversion metadata before attempting to convert value " + this.name);
        }
        return super.convertDataUsingConversionMetaData(data2);
    }

    @Override
    public byte[] getBinaryString(Object object) throws KettleValueException {
        if (object == null) {
            return null;
        }
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        switch (this.storageType) {
            case 0: {
                return this.convertStringToBinaryString(this.getString(object));
            }
            case 1: {
                return this.convertStringToBinaryString((String)this.convertBinaryStringToNativeType((byte[])object));
            }
            case 2: {
                return this.convertStringToBinaryString(this.getString(this.index[(Integer)object]));
            }
        }
        throw new KettleValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
    }

    @Override
    public void writeData(DataOutputStream outputStream, Object object) throws KettleFileException {
        try {
            outputStream.writeBoolean(object == null);
            if (object != null) {
                switch (this.storageType) {
                    case 0: {
                        Timestamp timestamp = this.convertDateToTimestamp((Date)object);
                        outputStream.writeLong(timestamp.getTime());
                        outputStream.writeInt(timestamp.getNanos());
                        break;
                    }
                    case 1: {
                        this.writeBinaryString(outputStream, (byte[])object);
                        break;
                    }
                    case 2: {
                        this.writeInteger(outputStream, (Integer)object);
                        break;
                    }
                    default: {
                        throw new KettleFileException(this.toString() + " : Unknown storage type " + this.getStorageType());
                    }
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to write value timestamp data to output stream", e);
        }
        catch (KettleValueException e) {
            throw new RuntimeException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    @Override
    public Object readData(DataInputStream inputStream) throws KettleFileException, KettleEOFException, SocketTimeoutException {
        try {
            if (inputStream.readBoolean()) {
                return null;
            }
            switch (this.storageType) {
                case 0: {
                    long time = inputStream.readLong();
                    int nanos = inputStream.readInt();
                    Timestamp timestamp = new Timestamp(time);
                    timestamp.setNanos(nanos);
                    return timestamp;
                }
                case 1: {
                    return this.readBinaryString(inputStream);
                }
                case 2: {
                    return this.readSmallInteger(inputStream);
                }
            }
            throw new KettleFileException(this.toString() + " : Unknown storage type " + this.getStorageType());
        }
        catch (EOFException e) {
            throw new KettleEOFException(e);
        }
        catch (SocketTimeoutException e) {
            throw e;
        }
        catch (IOException e) {
            throw new KettleFileException(this.toString() + " : Unable to read value timestamp data from input stream", e);
        }
    }

    @Override
    public synchronized SimpleDateFormat getDateFormat() {
        if (this.conversionMetadata != null) {
            return new SimpleTimestampFormat(this.conversionMetadata.getDateFormat().toPattern());
        }
        if (this.dateFormat == null || this.dateFormatChanged) {
            this.dateFormat = new SimpleTimestampFormat(new SimpleDateFormat().toPattern());
            String mask = Const.isEmpty(this.conversionMask) ? DEFAULT_TIMESTAMP_FORMAT_MASK : this.conversionMask;
            this.dateFormat = this.dateFormatLocale == null || this.dateFormatLocale.equals(Locale.getDefault()) ? new SimpleTimestampFormat(mask) : new SimpleTimestampFormat(mask, this.dateFormatLocale);
            if (this.dateFormatTimeZone != null) {
                this.dateFormat.setTimeZone(this.dateFormatTimeZone);
            }
            this.dateFormat.setLenient(this.dateFormatLenient);
            this.dateFormatChanged = false;
        }
        return this.dateFormat;
    }
}

