/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.mapreduce.entry.pmr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.mapreduce.DialogClassUtil;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.NamedClusterLoadSaveUtil;
import org.pentaho.big.data.kettle.plugins.mapreduce.entry.UserDefinedItem;
import org.pentaho.big.data.kettle.plugins.mapreduce.step.exit.HadoopExitMeta;
import org.pentaho.bigdata.api.mapreduce.MapReduceJobAdvanced;
import org.pentaho.bigdata.api.mapreduce.MapReduceService;
import org.pentaho.bigdata.api.mapreduce.PentahoMapReduceJobBuilder;
import org.pentaho.bigdata.api.mapreduce.TaskCompletionEvent;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;
import org.w3c.dom.Node;

@JobEntry(id="HadoopTransJobExecutorPlugin", image="HDT.svg", name="HadoopTransJobExecutorPlugin.Name", description="HadoopTransJobExecutorPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.hadooptransjobexecutor", documentationUrl="http://wiki.pentaho.com/display/EAI/Pentaho+MapReduce")
public class JobEntryHadoopTransJobExecutor
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public static final String MAPREDUCE_APPLICATION_CLASSPATH = "mapreduce.application.classpath";
    public static final String DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH = "$HADOOP_MAPRED_HOME/share/hadoop/mapreduce/*,$HADOOP_MAPRED_HOME/share/hadoop/mapreduce/lib/*";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_USE_DISTRIBUTED_CACHE = "pmr.use.distributed.cache";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_PMR_LIBRARIES_ARCHIVE_FILE = "pmr.libraries.archive.file";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_KETTLE_HDFS_INSTALL_DIR = "pmr.kettle.dfs.install.dir";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_KETTLE_INSTALLATION_ID = "pmr.kettle.installation.id";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_ADDITIONAL_PLUGINS = "pmr.kettle.additional.plugins";
    private static Class<?> PKG = JobEntryHadoopTransJobExecutor.class;
    public static final String DIALOG_NAME = DialogClassUtil.getDialogClassName(PKG);
    private final NamedClusterService namedClusterService;
    private final NamedClusterServiceLocator namedClusterServiceLocator;
    private final NamedClusterLoadSaveUtil namedClusterLoadSaveUtil = new NamedClusterLoadSaveUtil();
    private String hadoopJobName;
    private String mapRepositoryDir;
    private String mapRepositoryFile;
    private ObjectId mapRepositoryReference;
    private String mapTrans;
    private String combinerRepositoryDir;
    private String combinerRepositoryFile;
    private ObjectId combinerRepositoryReference;
    private String combinerTrans;
    private boolean combiningSingleThreaded;
    private String reduceRepositoryDir;
    private String reduceRepositoryFile;
    private ObjectId reduceRepositoryReference;
    private String reduceTrans;
    private boolean reducingSingleThreaded;
    private String mapInputStepName;
    private String mapOutputStepName;
    private String combinerInputStepName;
    private String combinerOutputStepName;
    private String reduceInputStepName;
    private String reduceOutputStepName;
    private boolean suppressOutputMapKey;
    private boolean suppressOutputMapValue;
    private boolean suppressOutputKey;
    private boolean suppressOutputValue;
    private String inputFormatClass;
    private String outputFormatClass;
    private NamedCluster namedCluster;
    private String inputPath;
    private String outputPath;
    private boolean cleanOutputPath;
    private boolean blocking;
    private String loggingInterval = "60";
    private String numMapTasks = "1";
    private String numReduceTasks = "1";
    private List<UserDefinedItem> userDefined = new ArrayList<UserDefinedItem>();
    private final RuntimeTester runtimeTester;
    private final RuntimeTestActionService runtimeTestActionService;

    public JobEntryHadoopTransJobExecutor(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, NamedClusterServiceLocator namedClusterServiceLocator) throws Throwable {
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.runtimeTester = runtimeTester;
        this.reducingSingleThreaded = false;
        this.combiningSingleThreaded = false;
    }

    private static final TransMeta loadTransMeta(VariableSpace space, Repository rep, String filename, ObjectId transformationId, String repositoryDir, String repositoryFile) throws KettleException {
        TransMeta transMeta = null;
        if (!Const.isEmpty((String)filename)) {
            String realFilename = space.environmentSubstitute(filename);
            transMeta = new TransMeta(realFilename);
        } else if (transformationId != null) {
            if (rep != null) {
                transMeta = rep.loadTransformation(transformationId, null);
            }
        } else if (!Const.isEmpty((String)repositoryDir) && !Const.isEmpty((String)repositoryFile) && rep != null) {
            String mapRepositoryDirS = space.environmentSubstitute(repositoryDir);
            String mapRepositoryFileS = space.environmentSubstitute(repositoryFile);
            RepositoryDirectoryInterface repositoryDirectory = rep.loadRepositoryDirectoryTree().findDirectory(mapRepositoryDirS);
            transMeta = rep.loadTransformation(mapRepositoryFileS, repositoryDirectory, null, true, null);
        }
        return transMeta;
    }

    public static String[] splitInputPaths(String inputPath, VariableSpace variableSpace) {
        String inputPathS = variableSpace.environmentSubstitute(inputPath);
        Matcher m = Pattern.compile("[{][^{]*[}]").matcher(inputPathS);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group().replace(",", "@!@"));
        }
        m.appendTail(sb);
        return sb.toString().split(",");
    }

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        this.hadoopJobName = hadoopJobName;
    }

    public String getMapTrans() {
        return this.mapTrans;
    }

    public void setMapTrans(String mapTrans) {
        this.mapTrans = mapTrans;
    }

    public String getCombinerTrans() {
        return this.combinerTrans;
    }

    public void setCombinerTrans(String combinerTrans) {
        this.combinerTrans = combinerTrans;
    }

    public String getReduceTrans() {
        return this.reduceTrans;
    }

    public void setReduceTrans(String reduceTrans) {
        this.reduceTrans = reduceTrans;
    }

    public String getMapRepositoryDir() {
        return this.mapRepositoryDir;
    }

    public void setMapRepositoryDir(String mapRepositoryDir) {
        this.mapRepositoryDir = mapRepositoryDir;
    }

    public String getMapRepositoryFile() {
        return this.mapRepositoryFile;
    }

    public void setMapRepositoryFile(String mapRepositoryFile) {
        this.mapRepositoryFile = mapRepositoryFile;
    }

    public ObjectId getMapRepositoryReference() {
        return this.mapRepositoryReference;
    }

    public void setMapRepositoryReference(ObjectId mapRepositoryReference) {
        this.mapRepositoryReference = mapRepositoryReference;
    }

    public String getCombinerRepositoryDir() {
        return this.combinerRepositoryDir;
    }

    public void setCombinerRepositoryDir(String combinerRepositoryDir) {
        this.combinerRepositoryDir = combinerRepositoryDir;
    }

    public String getCombinerRepositoryFile() {
        return this.combinerRepositoryFile;
    }

    public void setCombinerRepositoryFile(String combinerRepositoryFile) {
        this.combinerRepositoryFile = combinerRepositoryFile;
    }

    public ObjectId getCombinerRepositoryReference() {
        return this.combinerRepositoryReference;
    }

    public void setCombinerRepositoryReference(ObjectId combinerRepositoryReference) {
        this.combinerRepositoryReference = combinerRepositoryReference;
    }

    public String getReduceRepositoryDir() {
        return this.reduceRepositoryDir;
    }

    public void setReduceRepositoryDir(String reduceRepositoryDir) {
        this.reduceRepositoryDir = reduceRepositoryDir;
    }

    public String getReduceRepositoryFile() {
        return this.reduceRepositoryFile;
    }

    public void setReduceRepositoryFile(String reduceRepositoryFile) {
        this.reduceRepositoryFile = reduceRepositoryFile;
    }

    public ObjectId getReduceRepositoryReference() {
        return this.reduceRepositoryReference;
    }

    public void setReduceRepositoryReference(ObjectId reduceRepositoryReference) {
        this.reduceRepositoryReference = reduceRepositoryReference;
    }

    public String getMapInputStepName() {
        return this.mapInputStepName;
    }

    public void setMapInputStepName(String mapInputStepName) {
        this.mapInputStepName = mapInputStepName;
    }

    public String getMapOutputStepName() {
        return this.mapOutputStepName;
    }

    public void setMapOutputStepName(String mapOutputStepName) {
        this.mapOutputStepName = mapOutputStepName;
    }

    public String getCombinerInputStepName() {
        return this.combinerInputStepName;
    }

    public void setCombinerInputStepName(String combinerInputStepName) {
        this.combinerInputStepName = combinerInputStepName;
    }

    public String getCombinerOutputStepName() {
        return this.combinerOutputStepName;
    }

    public void setCombinerOutputStepName(String combinerOutputStepName) {
        this.combinerOutputStepName = combinerOutputStepName;
    }

    public String getReduceInputStepName() {
        return this.reduceInputStepName;
    }

    public void setReduceInputStepName(String reduceInputStepName) {
        this.reduceInputStepName = reduceInputStepName;
    }

    public String getReduceOutputStepName() {
        return this.reduceOutputStepName;
    }

    public void setReduceOutputStepName(String reduceOutputStepName) {
        this.reduceOutputStepName = reduceOutputStepName;
    }

    public boolean getSuppressOutputOfMapKey() {
        return this.suppressOutputMapKey;
    }

    public void setSuppressOutputOfMapKey(boolean suppress) {
        this.suppressOutputMapKey = suppress;
    }

    public boolean getSuppressOutputOfMapValue() {
        return this.suppressOutputMapValue;
    }

    public void setSuppressOutputOfMapValue(boolean suppress) {
        this.suppressOutputMapValue = suppress;
    }

    public boolean getSuppressOutputOfKey() {
        return this.suppressOutputKey;
    }

    public void setSuppressOutputOfKey(boolean suppress) {
        this.suppressOutputKey = suppress;
    }

    public boolean getSuppressOutputOfValue() {
        return this.suppressOutputValue;
    }

    public void setSuppressOutputOfValue(boolean suppress) {
        this.suppressOutputValue = suppress;
    }

    public String getInputFormatClass() {
        return this.inputFormatClass;
    }

    public void setInputFormatClass(String inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public String getOutputFormatClass() {
        return this.outputFormatClass;
    }

    public void setOutputFormatClass(String outputFormatClass) {
        this.outputFormatClass = outputFormatClass;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public boolean isCleanOutputPath() {
        return this.cleanOutputPath;
    }

    public void setCleanOutputPath(boolean cleanOutputPath) {
        this.cleanOutputPath = cleanOutputPath;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public String getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(String loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public List<UserDefinedItem> getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(List<UserDefinedItem> userDefined) {
        this.userDefined = userDefined;
    }

    public String getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(String numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public String getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(String numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public Result execute(Result result, int arg1) throws KettleException {
        Log4jFileAppender appender;
        block46: {
            result.setNrErrors(0L);
            appender = null;
            String logFileName = "pdi-" + this.getName();
            try {
                appender = LogWriter.createFileAppender((String)logFileName, (boolean)false, (boolean)false);
                LogWriter.getInstance().addAppender((Appender)appender);
                this.log.setLogLevel(this.parentJob.getLogLevel());
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            try {
                String numReduceTasksS;
                String numMapTasksS;
                PentahoMapReduceJobBuilder jobBuilder;
                block45: {
                    block44: {
                        StepMeta mapOut;
                        MapReduceService mapReduceService = (MapReduceService)this.namedClusterServiceLocator.getService(this.namedCluster, MapReduceService.class);
                        jobBuilder = mapReduceService.createPentahoMapReduceJobBuilder(this.log, this.variables);
                        String hadoopJobNameS = this.environmentSubstitute(this.hadoopJobName);
                        jobBuilder.setHadoopJobName(hadoopJobNameS);
                        TransExecutionConfiguration transExecConfig = new TransExecutionConfiguration();
                        TransMeta transMeta = JobEntryHadoopTransJobExecutor.loadTransMeta((VariableSpace)this, this.rep, this.mapTrans, this.mapRepositoryReference, this.mapRepositoryDir, this.mapRepositoryFile);
                        TransConfiguration transConfig = new TransConfiguration(transMeta, transExecConfig);
                        String mapInputStepNameS = this.environmentSubstitute(this.mapInputStepName);
                        String mapOutputStepNameS = this.environmentSubstitute(this.mapOutputStepName);
                        try {
                            jobBuilder.verifyTransMeta(transMeta, mapInputStepNameS, mapOutputStepNameS);
                        }
                        catch (Exception ex) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.MapConfiguration.Error", (String[])new String[0]), (Throwable)ex);
                        }
                        jobBuilder.setMapperInfo(transConfig.getXML(), mapInputStepNameS, mapOutputStepNameS);
                        jobBuilder.set("transformation-combine-single-threaded", this.combiningSingleThreaded ? "true" : "false");
                        jobBuilder.set("transformation-reduce-single-threaded", this.reducingSingleThreaded ? "true" : "false");
                        if (this.getSuppressOutputOfMapKey()) {
                            jobBuilder.setMapOutputKeyClass(jobBuilder.getHadoopWritableCompatibleClassName(null));
                        }
                        if (this.getSuppressOutputOfMapValue()) {
                            jobBuilder.setMapOutputValueClass(jobBuilder.getHadoopWritableCompatibleClassName(null));
                        }
                        if ((!this.getSuppressOutputOfMapKey() || !this.getSuppressOutputOfMapValue() && transMeta != null) && (mapOut = transMeta.findStep(mapOutputStepNameS)).getStepMetaInterface() instanceof HadoopExitMeta) {
                            RowMetaInterface prevStepFields = transMeta.getPrevStepFields(mapOut);
                            if (!this.getSuppressOutputOfMapKey()) {
                                ValueMetaInterface keyVM;
                                String keyName = ((HadoopExitMeta)mapOut.getStepMetaInterface()).getOutKeyFieldname();
                                int keyI = prevStepFields.indexOfValue(keyName);
                                ValueMetaInterface valueMetaInterface = keyVM = keyI >= 0 ? prevStepFields.getValueMeta(keyI) : null;
                                if (keyVM == null) {
                                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoMapOutputKeyDefined.Error", (String[])new String[0]));
                                }
                                String hadoopWritableKey = jobBuilder.getHadoopWritableCompatibleClassName(keyVM);
                                jobBuilder.setMapOutputKeyClass(hadoopWritableKey);
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.MapOutputKeyMessage", (String[])new String[]{hadoopWritableKey}));
                            }
                            if (!this.getSuppressOutputOfMapValue()) {
                                ValueMetaInterface valueVM;
                                String valName = ((HadoopExitMeta)mapOut.getStepMetaInterface()).getOutValueFieldname();
                                int valI = prevStepFields.indexOfValue(valName);
                                ValueMetaInterface valueMetaInterface = valueVM = valI >= 0 ? prevStepFields.getValueMeta(valI) : null;
                                if (valueVM == null) {
                                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoMapOutputValueDefined.Error", (String[])new String[0]));
                                }
                                String hadoopWritableValue = jobBuilder.getHadoopWritableCompatibleClassName(valueVM);
                                jobBuilder.setMapOutputValueClass(hadoopWritableValue);
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.MapOutputValueMessage", (String[])new String[]{hadoopWritableValue}));
                            }
                        }
                        if ((transMeta = JobEntryHadoopTransJobExecutor.loadTransMeta((VariableSpace)this, this.rep, this.combinerTrans, this.combinerRepositoryReference, this.combinerRepositoryDir, this.combinerRepositoryFile)) != null) {
                            if (this.combiningSingleThreaded) {
                                this.verifySingleThreadingValidity(transMeta);
                            }
                            String combinerInputStepNameS = this.environmentSubstitute(this.combinerInputStepName);
                            String combinerOutputStepNameS = this.environmentSubstitute(this.combinerOutputStepName);
                            transConfig = new TransConfiguration(transMeta, transExecConfig);
                            jobBuilder.setCombinerInfo(transConfig.getXML(), combinerInputStepNameS, combinerOutputStepNameS);
                            try {
                                jobBuilder.verifyTransMeta(transMeta, combinerInputStepNameS, combinerOutputStepNameS);
                            }
                            catch (Exception ex) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.CombinerConfiguration.Error", (String[])new String[0]), (Throwable)ex);
                            }
                        }
                        if ((transMeta = JobEntryHadoopTransJobExecutor.loadTransMeta((VariableSpace)this, this.rep, this.reduceTrans, this.reduceRepositoryReference, this.reduceRepositoryDir, this.reduceRepositoryFile)) != null) {
                            if (this.reducingSingleThreaded) {
                                this.verifySingleThreadingValidity(transMeta);
                            }
                            String reduceInputStepNameS = this.environmentSubstitute(this.reduceInputStepName);
                            String reduceOutputStepNameS = this.environmentSubstitute(this.reduceOutputStepName);
                            transConfig = new TransConfiguration(transMeta, transExecConfig);
                            jobBuilder.setReducerInfo(transConfig.getXML(), reduceInputStepNameS, reduceOutputStepNameS);
                            try {
                                jobBuilder.verifyTransMeta(transMeta, reduceInputStepNameS, reduceOutputStepNameS);
                            }
                            catch (Exception ex) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReducerConfiguration.Error", (String[])new String[0]), (Throwable)ex);
                            }
                            if (this.getSuppressOutputOfKey()) {
                                jobBuilder.setOutputKeyClass(jobBuilder.getHadoopWritableCompatibleClassName(null));
                            }
                            if (this.getSuppressOutputOfValue()) {
                                jobBuilder.setOutputValueClass(jobBuilder.getHadoopWritableCompatibleClassName(null));
                            }
                            if (!this.getSuppressOutputOfKey() || !this.getSuppressOutputOfValue()) {
                                StepMeta reduceOut = transMeta.findStep(reduceOutputStepNameS);
                                RowMetaInterface prevStepFields = transMeta.getPrevStepFields(reduceOut);
                                if (reduceOut.getStepMetaInterface() instanceof HadoopExitMeta) {
                                    ValueMetaInterface valueVM;
                                    String keyName = ((HadoopExitMeta)reduceOut.getStepMetaInterface()).getOutKeyFieldname();
                                    String valName = ((HadoopExitMeta)reduceOut.getStepMetaInterface()).getOutValueFieldname();
                                    int keyI = prevStepFields.indexOfValue(keyName);
                                    ValueMetaInterface keyVM = keyI >= 0 ? prevStepFields.getValueMeta(keyI) : null;
                                    int valI = prevStepFields.indexOfValue(valName);
                                    ValueMetaInterface valueMetaInterface = valueVM = valI >= 0 ? prevStepFields.getValueMeta(valI) : null;
                                    if (!this.getSuppressOutputOfKey()) {
                                        if (keyVM == null) {
                                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoOutputKeyDefined.Error", (String[])new String[0]));
                                        }
                                        String hadoopWritableKey = jobBuilder.getHadoopWritableCompatibleClassName(keyVM);
                                        jobBuilder.setOutputKeyClass(hadoopWritableKey);
                                        this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.OutputKeyMessage", (String[])new String[]{hadoopWritableKey}));
                                    }
                                    if (!this.getSuppressOutputOfValue()) {
                                        if (valueVM == null) {
                                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NoOutputValueDefined.Error", (String[])new String[0]));
                                        }
                                        String hadoopWritableValue = jobBuilder.getHadoopWritableCompatibleClassName(valueVM);
                                        jobBuilder.setOutputValueClass(hadoopWritableValue);
                                        this.logDebug(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.Message.OutputValueMessage", (String[])new String[]{hadoopWritableValue}));
                                    }
                                }
                            }
                        }
                        jobBuilder.setInputFormatClass(this.inputFormatClass);
                        jobBuilder.setOutputFormatClass(this.outputFormatClass);
                        jobBuilder.setInputPaths(JobEntryHadoopTransJobExecutor.splitInputPaths(this.inputPath, this.variables));
                        jobBuilder.setOutputPath(this.environmentSubstitute(this.outputPath));
                        for (UserDefinedItem item : this.userDefined) {
                            if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                            String nameS = this.environmentSubstitute(item.getName());
                            String valueS = this.environmentSubstitute(item.getValue());
                            jobBuilder.set(nameS, valueS);
                        }
                        numMapTasksS = this.environmentSubstitute(this.numMapTasks);
                        try {
                            if (Integer.parseInt(numMapTasksS) < 0) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NumMapTasks.Error", (String[])new String[0]));
                            }
                        }
                        catch (NumberFormatException e) {
                            if (!this.log.isDebug()) break block44;
                            this.logError(Const.getStackTracker((Throwable)e));
                        }
                    }
                    numReduceTasksS = this.environmentSubstitute(this.numReduceTasks);
                    try {
                        if (Integer.parseInt(numReduceTasksS) < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.NumReduceTasks.Error", (String[])new String[0]));
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!this.log.isDebug()) break block45;
                        this.logError(Const.getStackTracker((Throwable)e));
                    }
                }
                jobBuilder.setNumMapTasks(Const.toInt((String)numMapTasksS, (int)1));
                jobBuilder.setNumReduceTasks(Const.toInt((String)numReduceTasksS, (int)1));
                jobBuilder.setLogLevel(this.getLogLevel());
                jobBuilder.setCleanOutputPath(this.isCleanOutputPath());
                MapReduceJobAdvanced runningJob = jobBuilder.submit();
                String loggingIntervalS = this.environmentSubstitute(this.loggingInterval);
                int logIntv = 60;
                try {
                    logIntv = Integer.parseInt(loggingIntervalS);
                }
                catch (NumberFormatException e) {
                    this.logError("Can't parse logging interval '" + loggingIntervalS + "'. Setting " + "logging interval to 60");
                }
                if (!this.blocking) break block46;
                try {
                    int taskCompletionEventIndex = 0;
                    while (!this.parentJob.isStopped() && !runningJob.isComplete()) {
                        if (logIntv >= 1) {
                            this.printJobStatus(runningJob);
                            taskCompletionEventIndex += this.logTaskMessages(runningJob, taskCompletionEventIndex);
                            Thread.sleep(logIntv * 1000);
                            continue;
                        }
                        Thread.sleep(60000L);
                    }
                    if (this.parentJob.isStopped() && !runningJob.isComplete()) {
                        runningJob.killJob();
                        result.setResult(false);
                    }
                    this.printJobStatus(runningJob);
                    this.logTaskMessages(runningJob, taskCompletionEventIndex);
                }
                catch (InterruptedException ie) {
                    this.logError(ie.getMessage(), ie);
                }
                result.setResult(runningJob.isSuccessful());
            }
            catch (Throwable t) {
                t.printStackTrace();
                result.setStopped(true);
                result.setNrErrors(1L);
                result.setResult(false);
                this.logError(Const.NVL((String)t.getMessage(), (String)""), t);
            }
        }
        if (appender != null) {
            LogWriter.getInstance().removeAppender((Appender)appender);
            appender.close();
            ResultFile resultFile = new ResultFile(1, appender.getFile(), this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
        return result;
    }

    private int logTaskMessages(MapReduceJobAdvanced runningJob, int startIndex) throws IOException {
        TaskCompletionEvent[] tcEvents = runningJob.getTaskCompletionEvents(startIndex);
        block4: for (int i = 0; i < tcEvents.length; ++i) {
            String[] diags = runningJob.getTaskDiagnostics(tcEvents[i].getTaskAttemptId());
            StringBuilder diagsOutput = new StringBuilder();
            if (diags != null && diags.length > 0) {
                diagsOutput.append(Const.CR);
                for (String s : diags) {
                    diagsOutput.append(s);
                    diagsOutput.append(Const.CR);
                }
            }
            TaskCompletionEvent.Status status = tcEvents[i].getTaskStatus();
            switch (tcEvents[i].getTaskStatus()) {
                case KILLED: 
                case FAILED: 
                case TIPFAILED: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.TaskDetails", (Object[])new Object[]{status, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block4;
                }
                case SUCCEEDED: 
                case OBSOLETE: {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.TaskDetails", (Object[])new Object[]{TaskCompletionEvent.Status.SUCCEEDED, tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                    continue block4;
                }
                default: {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.TaskDetails", (Object[])new Object[]{"UNKNOWN", tcEvents[i].getTaskAttemptId(), tcEvents[i].getTaskAttemptId(), tcEvents[i].getEventId(), diagsOutput}));
                }
            }
        }
        return tcEvents.length;
    }

    public PluginInterface getPluginInterface() {
        String pluginId = PluginRegistry.getInstance().getPluginId((Object)this);
        return PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, pluginId);
    }

    private void verifySingleThreadingValidity(TransMeta transMeta) throws KettleException {
        for (StepMeta stepMeta : transMeta.getSteps()) {
            TransMeta.TransformationType[] types = stepMeta.getStepMetaInterface().getSupportedTransformationTypes();
            boolean ok = false;
            for (TransMeta.TransformationType type : types) {
                if (type != TransMeta.TransformationType.SingleThreaded) continue;
                ok = true;
            }
            if (ok) continue;
            throw new KettleException("Step '" + stepMeta.getName() + "' of type '" + stepMeta.getStepID() + "' is not supported in a Single Threaded transformation engine.");
        }
    }

    public void printJobStatus(MapReduceJobAdvanced runningJob) throws IOException {
        if (this.log.isBasic()) {
            double setupPercent = runningJob.getSetupProgress() * 100.0;
            double mapPercent = runningJob.getMapProgress() * 100.0;
            double reducePercent = runningJob.getReduceProgress() * 100.0;
            this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.RunningPercent", (Object[])new Object[]{setupPercent, mapPercent, reducePercent}));
        }
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.hadoopJobName = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_name");
        this.mapRepositoryDir = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans_repo_dir");
        this.mapRepositoryFile = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans_repo_file");
        String mapTransId = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans_repo_reference");
        this.mapRepositoryReference = Const.isEmpty((String)mapTransId) ? null : new StringObjectId(mapTransId);
        this.mapTrans = XMLHandler.getTagValue((Node)entrynode, (String)"map_trans");
        this.combinerRepositoryDir = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans_repo_dir");
        this.combinerRepositoryFile = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans_repo_file");
        String combinerTransId = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans_repo_reference");
        this.combinerRepositoryReference = Const.isEmpty((String)combinerTransId) ? null : new StringObjectId(combinerTransId);
        this.combinerTrans = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_trans");
        String combinerSingleThreaded = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_single_threaded");
        if (!Const.isEmpty((String)combinerSingleThreaded)) {
            this.setCombiningSingleThreaded("Y".equalsIgnoreCase(combinerSingleThreaded));
        } else {
            this.setCombiningSingleThreaded(false);
        }
        this.reduceRepositoryDir = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans_repo_dir");
        this.reduceRepositoryFile = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans_repo_file");
        String reduceTransId = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans_repo_reference");
        this.reduceRepositoryReference = Const.isEmpty((String)reduceTransId) ? null : new StringObjectId(reduceTransId);
        this.reduceTrans = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_trans");
        String single = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_single_threaded");
        if (Const.isEmpty((String)single)) {
            this.setReducingSingleThreaded(false);
        } else {
            this.setReducingSingleThreaded("Y".equalsIgnoreCase(single));
        }
        this.mapInputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"map_input_step_name");
        this.mapOutputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"map_output_step_name");
        this.combinerInputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_input_step_name");
        this.combinerOutputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"combiner_output_step_name");
        this.reduceInputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_input_step_name");
        this.reduceOutputStepName = XMLHandler.getTagValue((Node)entrynode, (String)"reduce_output_step_name");
        this.blocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blocking"));
        this.loggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"logging_interval");
        this.inputPath = XMLHandler.getTagValue((Node)entrynode, (String)"input_path");
        this.inputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"input_format_class");
        this.outputPath = XMLHandler.getTagValue((Node)entrynode, (String)"output_path");
        String cleanOutputPath = XMLHandler.getTagValue((Node)entrynode, (String)"clean_output_path");
        if (!Const.isEmpty((String)cleanOutputPath)) {
            this.setCleanOutputPath(cleanOutputPath.equalsIgnoreCase("Y"));
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_key"))) {
            this.suppressOutputMapKey = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_key").equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_value"))) {
            this.suppressOutputMapValue = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_map_value").equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_key"))) {
            this.suppressOutputKey = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_key").equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_value"))) {
            this.suppressOutputValue = XMLHandler.getTagValue((Node)entrynode, (String)"suppress_output_value").equalsIgnoreCase("Y");
        }
        this.outputFormatClass = XMLHandler.getTagValue((Node)entrynode, (String)"output_format_class");
        this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, null, rep, metaStore, entrynode, this.log);
        this.setRepository(rep);
        this.numMapTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_map_tasks");
        this.numReduceTasks = XMLHandler.getTagValue((Node)entrynode, (String)"num_reduce_tasks");
        this.userDefined = new ArrayList<UserDefinedItem>();
        Node userDefinedList = XMLHandler.getSubNode((Node)entrynode, (String)"user_defined_list");
        int nrUserDefined = XMLHandler.countNodes((Node)userDefinedList, (String)"user_defined");
        for (int i = 0; i < nrUserDefined; ++i) {
            Node userDefinedNode = XMLHandler.getSubNodeByNr((Node)userDefinedList, (String)"user_defined", (int)i);
            String name = XMLHandler.getTagValue((Node)userDefinedNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)userDefinedNode, (String)"value");
            UserDefinedItem item = new UserDefinedItem();
            item.setName(name);
            item.setValue(value);
            this.userDefined.add(item);
        }
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(1024);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans_repo_dir", (String)this.mapRepositoryDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans_repo_file", (String)this.mapRepositoryFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans_repo_reference", this.mapRepositoryReference == null ? null : this.mapRepositoryReference.toString()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_trans", (String)this.mapTrans));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans_repo_dir", (String)this.combinerRepositoryDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans_repo_file", (String)this.combinerRepositoryFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans_repo_reference", this.combinerRepositoryReference == null ? null : this.combinerRepositoryReference.toString()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_trans", (String)this.combinerTrans));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_single_threaded", (boolean)this.combiningSingleThreaded));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans_repo_dir", (String)this.reduceRepositoryDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans_repo_file", (String)this.reduceRepositoryFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans_repo_reference", this.reduceRepositoryReference == null ? null : this.reduceRepositoryReference.toString()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_trans", (String)this.reduceTrans));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_single_threaded", (boolean)this.reducingSingleThreaded));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_input_step_name", (String)this.mapInputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"map_output_step_name", (String)this.mapOutputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_input_step_name", (String)this.combinerInputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"combiner_output_step_name", (String)this.combinerOutputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_input_step_name", (String)this.reduceInputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"reduce_output_step_name", (String)this.reduceOutputStepName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blocking", (boolean)this.blocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_interval", (String)this.loggingInterval));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_path", (String)this.inputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"input_format_class", (String)this.inputFormatClass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_path", (String)this.outputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clean_output_path", (boolean)this.cleanOutputPath));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_map_key", (boolean)this.suppressOutputMapKey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_map_value", (boolean)this.suppressOutputMapValue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_key", (boolean)this.suppressOutputKey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"suppress_output_value", (boolean)this.suppressOutputValue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"output_format_class", (String)this.outputFormatClass));
        this.namedClusterLoadSaveUtil.getXmlNamedCluster(this.namedCluster, this.namedClusterService, this.metaStore, this.log, retval);
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_map_tasks", (String)this.numMapTasks));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_reduce_tasks", (String)this.numReduceTasks));
        retval.append("      <user_defined_list>").append(Const.CR);
        if (this.userDefined != null) {
            for (UserDefinedItem item : this.userDefined) {
                if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                retval.append("        <user_defined>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)item.getName()));
                retval.append("          ").append(XMLHandler.addTagValue((String)"value", (String)item.getValue()));
                retval.append("        </user_defined>").append(Const.CR);
            }
        }
        retval.append("      </user_defined_list>").append(Const.CR);
        return retval.toString();
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep != null) {
            this.setHadoopJobName(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_name"));
            this.setMapRepositoryDir(rep.getJobEntryAttributeString(id_jobentry, "map_trans_repo_dir"));
            this.setMapRepositoryFile(rep.getJobEntryAttributeString(id_jobentry, "map_trans_repo_file"));
            String mapTransId = rep.getJobEntryAttributeString(id_jobentry, "map_trans_repo_reference");
            this.setMapRepositoryReference((ObjectId)(Const.isEmpty((String)mapTransId) ? null : new StringObjectId(mapTransId)));
            this.setMapTrans(rep.getJobEntryAttributeString(id_jobentry, "map_trans"));
            this.setReduceRepositoryDir(rep.getJobEntryAttributeString(id_jobentry, "reduce_trans_repo_dir"));
            this.setReduceRepositoryFile(rep.getJobEntryAttributeString(id_jobentry, "reduce_trans_repo_file"));
            String reduceTransId = rep.getJobEntryAttributeString(id_jobentry, "reduce_trans_repo_reference");
            this.setReduceRepositoryReference((ObjectId)(Const.isEmpty((String)reduceTransId) ? null : new StringObjectId(reduceTransId)));
            this.setReduceTrans(rep.getJobEntryAttributeString(id_jobentry, "reduce_trans"));
            this.setReducingSingleThreaded(rep.getJobEntryAttributeBoolean(id_jobentry, "reduce_single_threaded", false));
            this.setCombinerRepositoryDir(rep.getJobEntryAttributeString(id_jobentry, "combiner_trans_repo_dir"));
            this.setCombinerRepositoryFile(rep.getJobEntryAttributeString(id_jobentry, "combiner_trans_repo_file"));
            String combinerTransId = rep.getJobEntryAttributeString(id_jobentry, "combiner_trans_repo_reference");
            this.setCombinerRepositoryReference((ObjectId)(Const.isEmpty((String)combinerTransId) ? null : new StringObjectId(combinerTransId)));
            this.setCombinerTrans(rep.getJobEntryAttributeString(id_jobentry, "combiner_trans"));
            this.setCombiningSingleThreaded(rep.getJobEntryAttributeBoolean(id_jobentry, "combiner_single_threaded", false));
            this.setMapInputStepName(rep.getJobEntryAttributeString(id_jobentry, "map_input_step_name"));
            this.setMapOutputStepName(rep.getJobEntryAttributeString(id_jobentry, "map_output_step_name"));
            this.setCombinerInputStepName(rep.getJobEntryAttributeString(id_jobentry, "combiner_input_step_name"));
            this.setCombinerOutputStepName(rep.getJobEntryAttributeString(id_jobentry, "combiner_output_step_name"));
            this.setReduceInputStepName(rep.getJobEntryAttributeString(id_jobentry, "reduce_input_step_name"));
            this.setReduceOutputStepName(rep.getJobEntryAttributeString(id_jobentry, "reduce_output_step_name"));
            this.setBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "blocking"));
            this.setLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "logging_interval"));
            this.setInputPath(rep.getJobEntryAttributeString(id_jobentry, "input_path"));
            this.setInputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "input_format_class"));
            this.setOutputPath(rep.getJobEntryAttributeString(id_jobentry, "output_path"));
            this.setCleanOutputPath(rep.getJobEntryAttributeBoolean(id_jobentry, "clean_output_path"));
            this.setSuppressOutputOfMapKey(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_map_key"));
            this.setSuppressOutputOfMapValue(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_map_value"));
            this.setSuppressOutputOfKey(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_key"));
            this.setSuppressOutputOfValue(rep.getJobEntryAttributeBoolean(id_jobentry, "suppress_output_value"));
            this.setOutputFormatClass(rep.getJobEntryAttributeString(id_jobentry, "output_format_class"));
            this.namedCluster = this.namedClusterLoadSaveUtil.loadClusterConfig(this.namedClusterService, id_jobentry, rep, metaStore, null, this.log);
            this.setRepository(rep);
            this.setNumMapTasks(rep.getJobEntryAttributeString(id_jobentry, "num_map_tasks"));
            this.setNumReduceTasks(rep.getJobEntryAttributeString(id_jobentry, "num_reduce_tasks"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "user_defined_name");
            if (argnr > 0) {
                this.userDefined = new ArrayList<UserDefinedItem>();
                UserDefinedItem item = null;
                for (int i = 0; i < argnr; ++i) {
                    item = new UserDefinedItem();
                    item.setName(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_name"));
                    item.setValue(rep.getJobEntryAttributeString(id_jobentry, i, "user_defined_value"));
                    this.userDefined.add(item);
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        if (rep != null) {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans_repo_dir", this.mapRepositoryDir);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans_repo_file", this.mapRepositoryFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans_repo_reference", this.mapRepositoryReference == null ? null : this.mapRepositoryReference.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_trans", this.mapTrans);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans_repo_dir", this.reduceRepositoryDir);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans_repo_file", this.reduceRepositoryFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans_repo_reference", this.reduceRepositoryReference == null ? null : this.reduceRepositoryReference.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_trans", this.reduceTrans);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_single_threaded", this.reducingSingleThreaded);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans_repo_dir", this.combinerRepositoryDir);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans_repo_file", this.combinerRepositoryFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans_repo_reference", this.combinerRepositoryReference == null ? null : this.combinerRepositoryReference.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_trans", this.combinerTrans);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_single_threaded", this.combiningSingleThreaded);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_input_step_name", this.mapInputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "map_output_step_name", this.mapOutputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_input_step_name", this.combinerInputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "combiner_output_step_name", this.combinerOutputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_input_step_name", this.reduceInputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "reduce_output_step_name", this.reduceOutputStepName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blocking", this.blocking);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_interval", this.loggingInterval);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_path", this.inputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "input_format_class", this.inputFormatClass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_path", this.outputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "clean_output_path", this.cleanOutputPath);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_map_key", this.suppressOutputMapKey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_map_value", this.suppressOutputMapValue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_key", this.suppressOutputKey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "suppress_output_value", this.suppressOutputValue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "output_format_class", this.outputFormatClass);
            this.namedClusterLoadSaveUtil.saveNamedClusterRep(this.namedCluster, this.namedClusterService, rep, this.metaStore, id_job, this.getObjectId(), this.log);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_map_tasks", this.numMapTasks);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_reduce_tasks", this.numReduceTasks);
            if (this.userDefined != null) {
                for (int i = 0; i < this.userDefined.size(); ++i) {
                    UserDefinedItem item = this.userDefined.get(i);
                    if (item.getName() == null || "".equals(item.getName()) || item.getValue() == null || "".equals(item.getValue())) continue;
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_name", item.getName());
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "user_defined_value", item.getValue());
                }
            }
        } else {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public boolean isReducingSingleThreaded() {
        return this.reducingSingleThreaded;
    }

    public void setReducingSingleThreaded(boolean reducingSingleThreaded) {
        this.reducingSingleThreaded = reducingSingleThreaded;
    }

    public boolean isCombiningSingleThreaded() {
        return this.combiningSingleThreaded;
    }

    public void setCombiningSingleThreaded(boolean combiningSingleThreaded) {
        this.combiningSingleThreaded = combiningSingleThreaded;
    }

    private boolean hasMapperDefinition() {
        return !Const.isEmpty((String)this.mapTrans) || this.mapRepositoryReference != null || !Const.isEmpty((String)this.mapRepositoryDir) && !Const.isEmpty((String)this.mapRepositoryFile);
    }

    private boolean hasReducerDefinition() {
        return !Const.isEmpty((String)this.reduceTrans) || this.reduceRepositoryReference != null || !Const.isEmpty((String)this.reduceRepositoryDir) && !Const.isEmpty((String)this.reduceRepositoryFile);
    }

    private boolean hasCombinerDefinition() {
        return !Const.isEmpty((String)this.combinerTrans) || this.combinerRepositoryReference != null || !Const.isEmpty((String)this.combinerRepositoryDir) && !Const.isEmpty((String)this.combinerRepositoryFile);
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReferencedObject.Mapper", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReferencedObject.Combiner", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.ReferencedObject.Reducer", (String[])new String[0])};
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.hasMapperDefinition(), this.hasCombinerDefinition(), this.hasReducerDefinition()};
    }

    public Object loadReferencedObject(int index, Repository rep, VariableSpace space) throws KettleException {
        switch (index) {
            case 0: {
                return JobEntryHadoopTransJobExecutor.loadTransMeta(space, rep, this.mapTrans, this.mapRepositoryReference, this.mapRepositoryDir, this.mapRepositoryFile);
            }
            case 1: {
                return JobEntryHadoopTransJobExecutor.loadTransMeta(space, rep, this.combinerTrans, this.combinerRepositoryReference, this.combinerRepositoryDir, this.combinerRepositoryFile);
            }
            case 2: {
                return JobEntryHadoopTransJobExecutor.loadTransMeta(space, rep, this.reduceTrans, this.reduceRepositoryReference, this.reduceRepositoryDir, this.reduceRepositoryFile);
            }
        }
        return null;
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        this.copyVariablesFrom(space);
        boolean[] enabled = this.isReferencedObjectEnabled();
        for (int i = 0; i < enabled.length; ++i) {
            if (!enabled[i]) continue;
            TransMeta transMeta = (TransMeta)this.loadReferencedObject(i, repository, space);
            String proposedNewFilename = transMeta.exportResources((VariableSpace)transMeta, definitions, namingInterface, repository, metaStore);
            String newFilename = "${Internal.Job.Filename.Directory}/" + proposedNewFilename;
            transMeta.setFilename(newFilename);
            transMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
            this.setSpecificationMethodAndValue(i, ObjectLocationSpecificationMethod.FILENAME, newFilename, null, null);
        }
        return this.getHadoopJobName();
    }

    private void setSpecificationMethodAndValue(int i, ObjectLocationSpecificationMethod specification, String filename, String repositoryDir, ObjectId referrence) {
        block0 : switch (specification) {
            case FILENAME: {
                switch (i) {
                    case 0: {
                        this.setMapTrans(filename);
                        break;
                    }
                    case 1: {
                        this.setCombinerTrans(filename);
                        break;
                    }
                    case 2: {
                        this.setReduceTrans(filename);
                    }
                }
                break;
            }
            case REPOSITORY_BY_NAME: {
                switch (i) {
                    case 0: {
                        this.setMapRepositoryDir(repositoryDir);
                        this.setMapRepositoryFile(filename);
                        break;
                    }
                    case 1: {
                        this.setCombinerRepositoryDir(repositoryDir);
                        this.setCombinerRepositoryFile(filename);
                        break;
                    }
                    case 2: {
                        this.setReduceRepositoryDir(repositoryDir);
                        this.setReduceRepositoryFile(filename);
                    }
                }
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                switch (i) {
                    case 0: {
                        this.setMapRepositoryReference(referrence);
                        break block0;
                    }
                    case 1: {
                        this.setCombinerRepositoryReference(referrence);
                        break block0;
                    }
                    case 2: {
                        this.setReduceRepositoryReference(referrence);
                    }
                }
            }
        }
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public String getDialogClassName() {
        return DIALOG_NAME;
    }
}

