/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueStatistics;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractCSQueue
implements CSQueue {
    CSQueue parent;
    final String queueName;
    float capacity;
    float maximumCapacity;
    float absoluteCapacity;
    float absoluteMaxCapacity;
    float absoluteUsedCapacity = 0.0f;
    float usedCapacity = 0.0f;
    volatile int numContainers;
    final Resource minimumAllocation;
    final Resource maximumAllocation;
    QueueState state;
    final QueueMetrics metrics;
    final ResourceCalculator resourceCalculator;
    Set<String> accessibleLabels;
    RMNodeLabelsManager labelManager;
    String defaultLabelExpression;
    Resource usedResources = Resources.createResource((int)0, (int)0);
    Map<String, Float> absoluteCapacityByNodeLabels;
    Map<String, Float> capacitiyByNodeLabels;
    Map<String, Resource> usedResourcesByNodeLabels = new HashMap<String, Resource>();
    Map<String, Float> absoluteMaxCapacityByNodeLabels;
    Map<String, Float> maxCapacityByNodeLabels;
    Map<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
    boolean reservationsContinueLooking;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public AbstractCSQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        this.minimumAllocation = cs.getMinimumResourceCapability();
        this.maximumAllocation = cs.getMaximumResourceCapability();
        this.labelManager = cs.getRMContext().getNodeLabelManager();
        this.parent = parent;
        this.queueName = queueName;
        this.resourceCalculator = cs.getResourceCalculator();
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics(), cs.getConf());
        this.accessibleLabels = cs.getConfiguration().getAccessibleNodeLabels(this.getQueuePath());
        this.defaultLabelExpression = cs.getConfiguration().getDefaultNodeLabelExpression(this.getQueuePath());
        if (this.accessibleLabels == null && parent != null) {
            this.accessibleLabels = parent.getAccessibleNodeLabels();
        }
        SchedulerUtils.checkIfLabelInClusterNodeLabels(this.labelManager, this.accessibleLabels);
        if (this.defaultLabelExpression == null && parent != null && this.accessibleLabels.containsAll(parent.getAccessibleNodeLabels())) {
            this.defaultLabelExpression = parent.getDefaultNodeLabelExpression();
        }
        this.capacitiyByNodeLabels = cs.getConfiguration().getNodeLabelCapacities(this.getQueuePath(), this.accessibleLabels, this.labelManager);
        this.maxCapacityByNodeLabels = cs.getConfiguration().getMaximumNodeLabelCapacities(this.getQueuePath(), this.accessibleLabels, this.labelManager);
    }

    @Override
    public synchronized float getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    @Override
    public float getAbsoluteMaximumCapacity() {
        return this.absoluteMaxCapacity;
    }

    @Override
    public synchronized float getAbsoluteUsedCapacity() {
        return this.absoluteUsedCapacity;
    }

    @Override
    public float getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.usedCapacity;
    }

    @Override
    public synchronized Resource getUsedResources() {
        return this.usedResources;
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public synchronized CSQueue getParent() {
        return this.parent;
    }

    @Override
    public synchronized void setParent(CSQueue newParentQueue) {
        this.parent = (ParentQueue)newParentQueue;
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return this.accessibleLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        AbstractCSQueue abstractCSQueue = this;
        synchronized (abstractCSQueue) {
            if (this.acls.get(acl).isUserAllowed(user)) {
                return true;
            }
        }
        if (this.parent != null) {
            return this.parent.hasAccess(acl, user);
        }
        return false;
    }

    @Override
    public synchronized void setUsedCapacity(float usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    @Override
    public synchronized void setAbsoluteUsedCapacity(float absUsedCapacity) {
        this.absoluteUsedCapacity = absUsedCapacity;
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), this.capacity, maximumCapacity);
        float absMaxCapacity = CSQueueUtils.computeAbsoluteMaximumCapacity(maximumCapacity, this.parent);
        CSQueueUtils.checkAbsoluteCapacity(this.getQueueName(), this.absoluteCapacity, absMaxCapacity);
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absMaxCapacity;
    }

    @Override
    public float getAbsActualCapacity() {
        return this.absoluteCapacity;
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return this.defaultLabelExpression;
    }

    synchronized void setupQueueConfigs(Resource clusterResource, float capacity, float absoluteCapacity, float maximumCapacity, float absoluteMaxCapacity, QueueState state, Map<QueueACL, AccessControlList> acls, Set<String> labels, String defaultLabelExpression, Map<String, Float> nodeLabelCapacities, Map<String, Float> maximumNodeLabelCapacities, boolean reservationContinueLooking) throws IOException {
        CSQueueUtils.checkMaxCapacity(this.getQueueName(), capacity, maximumCapacity);
        CSQueueUtils.checkAbsoluteCapacity(this.getQueueName(), absoluteCapacity, absoluteMaxCapacity);
        this.capacity = capacity;
        this.absoluteCapacity = absoluteCapacity;
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = absoluteMaxCapacity;
        this.state = state;
        this.acls = acls;
        this.accessibleLabels = labels;
        this.defaultLabelExpression = defaultLabelExpression;
        this.capacitiyByNodeLabels = new HashMap<String, Float>(nodeLabelCapacities);
        this.maxCapacityByNodeLabels = new HashMap<String, Float>(maximumNodeLabelCapacities);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.parent, clusterResource, this.minimumAllocation);
        if (this.parent != null && this.parent.getParent() != null && this.parent.getAccessibleNodeLabels() != null && !this.parent.getAccessibleNodeLabels().contains("*")) {
            if (this.getAccessibleNodeLabels().contains("*")) {
                throw new IOException("Parent's accessible queue is not ANY(*), but child's accessible queue is *");
            }
            Sets.SetView diff = Sets.difference(this.getAccessibleNodeLabels(), this.parent.getAccessibleNodeLabels());
            if (!diff.isEmpty()) {
                throw new IOException("Some labels of child queue is not a subset of parent queue, these labels=[" + StringUtils.join((Collection)diff, (String)",") + "]");
            }
        }
        this.absoluteCapacityByNodeLabels = CSQueueUtils.computeAbsoluteCapacityByNodeLabels(this.capacitiyByNodeLabels, this.parent);
        this.absoluteMaxCapacityByNodeLabels = CSQueueUtils.computeAbsoluteMaxCapacityByNodeLabels(maximumNodeLabelCapacities, this.parent);
        CSQueueUtils.checkAbsoluteCapacitiesByLabel(this.getQueueName(), this.absoluteCapacityByNodeLabels, this.absoluteCapacityByNodeLabels);
        this.reservationsContinueLooking = reservationContinueLooking;
    }

    protected QueueInfo getQueueInfo() {
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.queueName);
        queueInfo.setAccessibleNodeLabels(this.accessibleLabels);
        queueInfo.setCapacity(this.capacity);
        queueInfo.setMaximumCapacity(this.maximumCapacity);
        queueInfo.setQueueState(this.state);
        queueInfo.setDefaultNodeLabelExpression(this.defaultLabelExpression);
        queueInfo.setCurrentCapacity(this.getUsedCapacity());
        queueInfo.setQueueStatistics(this.getQueueStatistics());
        return queueInfo;
    }

    public QueueStatistics getQueueStatistics() {
        QueueStatistics stats = (QueueStatistics)this.recordFactory.newRecordInstance(QueueStatistics.class);
        stats.setNumAppsSubmitted((long)this.getMetrics().getAppsSubmitted());
        stats.setNumAppsRunning((long)this.getMetrics().getAppsRunning());
        stats.setNumAppsPending((long)this.getMetrics().getAppsPending());
        stats.setNumAppsCompleted((long)this.getMetrics().getAppsCompleted());
        stats.setNumAppsKilled((long)this.getMetrics().getAppsKilled());
        stats.setNumAppsFailed((long)this.getMetrics().getAppsFailed());
        stats.setNumActiveUsers((long)this.getMetrics().getActiveUsers());
        stats.setAvailableMemoryMB((long)this.getMetrics().getAvailableMB());
        stats.setAllocatedMemoryMB((long)this.getMetrics().getAllocatedMB());
        stats.setPendingMemoryMB((long)this.getMetrics().getPendingMB());
        stats.setReservedMemoryMB((long)this.getMetrics().getReservedMB());
        stats.setAvailableVCores((long)this.getMetrics().getAvailableVirtualCores());
        stats.setAllocatedVCores((long)this.getMetrics().getAllocatedVirtualCores());
        stats.setPendingVCores((long)this.getMetrics().getPendingVirtualCores());
        stats.setReservedVCores((long)this.getMetrics().getReservedVirtualCores());
        stats.setPendingContainers((long)this.getMetrics().getPendingContainers());
        stats.setAllocatedContainers((long)this.getMetrics().getAllocatedContainers());
        stats.setReservedContainers((long)this.getMetrics().getReservedContainers());
        return stats;
    }

    @InterfaceAudience.Private
    public Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @InterfaceAudience.Private
    public Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    synchronized void allocateResource(Resource clusterResource, Resource resource, Set<String> nodeLabels) {
        Resources.addTo((Resource)this.usedResources, (Resource)resource);
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            if (!this.usedResourcesByNodeLabels.containsKey("")) {
                this.usedResourcesByNodeLabels.put("", Resources.createResource((int)0));
            }
            Resources.addTo((Resource)this.usedResourcesByNodeLabels.get(""), (Resource)resource);
        } else {
            for (String label : Sets.intersection(this.accessibleLabels, nodeLabels)) {
                if (!this.usedResourcesByNodeLabels.containsKey(label)) {
                    this.usedResourcesByNodeLabels.put(label, Resources.createResource((int)0));
                }
                Resources.addTo((Resource)this.usedResourcesByNodeLabels.get(label), (Resource)resource);
            }
        }
        ++this.numContainers;
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
    }

    protected synchronized void releaseResource(Resource clusterResource, Resource resource, Set<String> nodeLabels) {
        Resources.subtractFrom((Resource)this.usedResources, (Resource)resource);
        if (null == nodeLabels || nodeLabels.isEmpty()) {
            if (!this.usedResourcesByNodeLabels.containsKey("")) {
                this.usedResourcesByNodeLabels.put("", Resources.createResource((int)0));
            }
            Resources.subtractFrom((Resource)this.usedResourcesByNodeLabels.get(""), (Resource)resource);
        } else {
            for (String label : Sets.intersection(this.accessibleLabels, nodeLabels)) {
                if (!this.usedResourcesByNodeLabels.containsKey(label)) {
                    this.usedResourcesByNodeLabels.put(label, Resources.createResource((int)0));
                }
                Resources.subtractFrom((Resource)this.usedResourcesByNodeLabels.get(label), (Resource)resource);
            }
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this, this.getParent(), clusterResource, this.minimumAllocation);
        --this.numContainers;
    }

    @Override
    @InterfaceAudience.Private
    public float getCapacityByNodeLabel(String label) {
        if (StringUtils.equals((String)label, (String)"")) {
            if (null == this.parent) {
                return 1.0f;
            }
            return this.getCapacity();
        }
        if (!this.capacitiyByNodeLabels.containsKey(label)) {
            return 0.0f;
        }
        return this.capacitiyByNodeLabels.get(label).floatValue();
    }

    @Override
    @InterfaceAudience.Private
    public float getAbsoluteCapacityByNodeLabel(String label) {
        if (StringUtils.equals((String)label, (String)"")) {
            if (null == this.parent) {
                return 1.0f;
            }
            return this.getAbsoluteCapacity();
        }
        if (!this.absoluteCapacityByNodeLabels.containsKey(label)) {
            return 0.0f;
        }
        return this.absoluteCapacityByNodeLabels.get(label).floatValue();
    }

    @Override
    @InterfaceAudience.Private
    public float getAbsoluteMaximumCapacityByNodeLabel(String label) {
        if (StringUtils.equals((String)label, (String)"")) {
            return this.getAbsoluteMaximumCapacity();
        }
        if (!this.absoluteMaxCapacityByNodeLabels.containsKey(label)) {
            return 0.0f;
        }
        return this.absoluteMaxCapacityByNodeLabels.get(label).floatValue();
    }

    @InterfaceAudience.Private
    public boolean getReservationContinueLooking() {
        return this.reservationsContinueLooking;
    }

    @InterfaceAudience.Private
    public Map<QueueACL, AccessControlList> getACLs() {
        return this.acls;
    }
}

