/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;

public class RMAppManager
implements EventHandler<RMAppManagerEvent>,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppManager.class);
    private int maxCompletedAppsInMemory;
    private int maxCompletedAppsInStateStore;
    protected int completedAppsInStateStore = 0;
    private LinkedList<ApplicationId> completedApps = new LinkedList();
    private final RMContext rmContext;
    private final ApplicationMasterService masterService;
    private final YarnScheduler scheduler;
    private final ApplicationACLsManager applicationACLsManager;
    private Configuration conf;

    public RMAppManager(RMContext context, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
        this.rmContext = context;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.applicationACLsManager = applicationACLsManager;
        this.conf = conf;
        this.maxCompletedAppsInMemory = conf.getInt("yarn.resourcemanager.max-completed-applications", 10000);
        this.maxCompletedAppsInStateStore = conf.getInt("yarn.resourcemanager.state-store.max-completed-applications", 10000);
        if (this.maxCompletedAppsInStateStore > this.maxCompletedAppsInMemory) {
            this.maxCompletedAppsInStateStore = this.maxCompletedAppsInMemory;
        }
    }

    @VisibleForTesting
    public void logApplicationSummary(ApplicationId appId) {
        ApplicationSummary.logAppSummary((RMApp)this.rmContext.getRMApps().get(appId));
    }

    protected synchronized int getCompletedAppsListSize() {
        return this.completedApps.size();
    }

    protected synchronized void finishApplication(ApplicationId applicationId) {
        if (applicationId == null) {
            LOG.error((Object)"RMAppManager received completed appId of null, skipping");
        } else {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.rmContext.getDelegationTokenRenewer().applicationFinished(applicationId);
            }
            this.completedApps.add(applicationId);
            ++this.completedAppsInStateStore;
            this.writeAuditLog(applicationId);
        }
    }

    protected void writeAuditLog(ApplicationId appId) {
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        String operation = "UNKONWN";
        boolean success = false;
        switch (app.getState()) {
            case FAILED: {
                operation = "Application Finished - Failed";
                break;
            }
            case FINISHED: {
                operation = "Application Finished - Succeeded";
                success = true;
                break;
            }
            case KILLED: {
                operation = "Application Finished - Killed";
                success = true;
                break;
            }
        }
        if (success) {
            RMAuditLogger.logSuccess(app.getUser(), operation, "RMAppManager", app.getApplicationId());
        } else {
            StringBuilder diag = app.getDiagnostics();
            String msg = diag == null ? null : diag.toString();
            RMAuditLogger.logFailure(app.getUser(), operation, msg, "RMAppManager", "App failed with state: " + (Object)((Object)app.getState()), appId);
        }
    }

    protected synchronized void checkAppNumCompletedLimit() {
        ApplicationId removeId;
        while (this.completedAppsInStateStore > this.maxCompletedAppsInStateStore) {
            removeId = this.completedApps.get(this.completedApps.size() - this.completedAppsInStateStore);
            RMApp removeApp = (RMApp)this.rmContext.getRMApps().get(removeId);
            LOG.info((Object)("Max number of completed apps kept in state store met: maxCompletedAppsInStateStore = " + this.maxCompletedAppsInStateStore + ", removing app " + removeApp.getApplicationId() + " from state store."));
            this.rmContext.getStateStore().removeApplication(removeApp);
            --this.completedAppsInStateStore;
        }
        while (this.completedApps.size() > this.maxCompletedAppsInMemory) {
            removeId = this.completedApps.remove();
            LOG.info((Object)("Application should be expired, max number of completed apps kept in memory met: maxCompletedAppsInMemory = " + this.maxCompletedAppsInMemory + ", removing app " + removeId + " from memory: "));
            this.rmContext.getRMApps().remove(removeId);
            this.applicationACLsManager.removeApplication(removeId);
        }
    }

    protected void submitApplication(ApplicationSubmissionContext submissionContext, long submitTime, String user) throws YarnException {
        ApplicationId applicationId = submissionContext.getApplicationId();
        RMAppImpl application = this.createAndPopulateNewRMApp(submissionContext, submitTime, user);
        ApplicationId appId = submissionContext.getApplicationId();
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                this.rmContext.getDelegationTokenRenewer().addApplicationAsync(appId, this.parseCredentials(submissionContext), submissionContext.getCancelTokensWhenComplete(), application.getUser());
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to parse credentials.", (Throwable)e);
                assert (application.getState() == RMAppState.NEW);
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, e.getMessage()));
                throw RPCUtil.getRemoteException((Throwable)e);
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.START));
        }
    }

    protected void recoverApplication(ApplicationStateData appState, RMStateStore.RMState rmState) throws Exception {
        ApplicationSubmissionContext appContext = appState.getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        RMAppImpl application = this.createAndPopulateNewRMApp(appContext, appState.getSubmitTime(), appState.getUser());
        application.handle(new RMAppRecoverEvent(appId, rmState));
    }

    private RMAppImpl createAndPopulateNewRMApp(ApplicationSubmissionContext submissionContext, long submitTime, String user) throws YarnException {
        ApplicationId applicationId = submissionContext.getApplicationId();
        ResourceRequest amReq = this.validateAndCreateResourceRequest(submissionContext);
        RMAppImpl application = new RMAppImpl(applicationId, this.rmContext, this.conf, submissionContext.getApplicationName(), user, submissionContext.getQueue(), submissionContext, this.scheduler, this.masterService, submitTime, submissionContext.getApplicationType(), submissionContext.getApplicationTags(), amReq);
        if (this.rmContext.getRMApps().putIfAbsent(applicationId, application) != null) {
            String message = "Application with id " + applicationId + " is already present! Cannot add a duplicate!";
            LOG.warn((Object)message);
            throw RPCUtil.getRemoteException((String)message);
        }
        this.applicationACLsManager.addApplication(applicationId, submissionContext.getAMContainerSpec().getApplicationACLs());
        String appViewACLs = (String)submissionContext.getAMContainerSpec().getApplicationACLs().get(ApplicationAccessType.VIEW_APP);
        this.rmContext.getSystemMetricsPublisher().appACLsUpdated(application, appViewACLs, System.currentTimeMillis());
        return application;
    }

    private ResourceRequest validateAndCreateResourceRequest(ApplicationSubmissionContext submissionContext) throws InvalidResourceRequestException {
        if (!submissionContext.getUnmanagedAM()) {
            ResourceRequest amReq = submissionContext.getAMContainerResourceRequest() != null ? submissionContext.getAMContainerResourceRequest() : BuilderUtils.newResourceRequest((Priority)RMAppAttemptImpl.AM_CONTAINER_PRIORITY, (String)"*", (Resource)submissionContext.getResource(), (int)1);
            if (null == amReq.getNodeLabelExpression()) {
                amReq.setNodeLabelExpression(submissionContext.getNodeLabelExpression());
            }
            try {
                SchedulerUtils.validateResourceRequest(amReq, this.scheduler.getMaximumResourceCapability(), submissionContext.getQueue(), this.scheduler);
            }
            catch (InvalidResourceRequestException e) {
                LOG.warn((Object)("RM app submission failed in validating AM resource request for application " + submissionContext.getApplicationId()), (Throwable)e);
                throw e;
            }
            return amReq;
        }
        return null;
    }

    protected Credentials parseCredentials(ApplicationSubmissionContext application) throws IOException {
        Credentials credentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        ByteBuffer tokens = application.getAMContainerSpec().getTokens();
        if (tokens != null) {
            dibb.reset(new ByteBuffer[]{tokens});
            credentials.readTokenStorageStream((DataInputStream)dibb);
            tokens.rewind();
        }
        return credentials;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        RMStateStore store = this.rmContext.getStateStore();
        assert (store != null);
        Map<ApplicationId, ApplicationStateData> appStates = state.getApplicationState();
        LOG.info((Object)("Recovering " + appStates.size() + " applications"));
        for (ApplicationStateData appState : appStates.values()) {
            this.recoverApplication(appState, state);
        }
    }

    public void handle(RMAppManagerEvent event) {
        ApplicationId applicationId = event.getApplicationId();
        LOG.debug((Object)("RMAppManager processing event for " + applicationId + " of type " + event.getType()));
        switch ((RMAppManagerEventType)event.getType()) {
            case APP_COMPLETED: {
                this.finishApplication(applicationId);
                this.logApplicationSummary(applicationId);
                this.checkAppNumCompletedLimit();
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    static class ApplicationSummary {
        static final Log LOG = LogFactory.getLog(ApplicationSummary.class);
        static final char EQUALS = '=';
        static final char[] charsToEscape = new char[]{',', '=', '\\'};

        ApplicationSummary() {
        }

        public static SummaryBuilder createAppSummary(RMApp app) {
            String trackingUrl = "N/A";
            String host = "N/A";
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            if (attempt != null) {
                trackingUrl = attempt.getTrackingUrl();
                host = attempt.getHost();
            }
            SummaryBuilder summary = new SummaryBuilder().add("appId", app.getApplicationId()).add("name", app.getName()).add("user", app.getUser()).add("queue", app.getQueue()).add("state", app.getState()).add("trackingUrl", trackingUrl).add("appMasterHost", host).add("startTime", app.getStartTime()).add("finishTime", app.getFinishTime()).add("finalStatus", app.getFinalApplicationStatus());
            return summary;
        }

        public static void logAppSummary(RMApp app) {
            if (app != null) {
                LOG.info((Object)ApplicationSummary.createAppSummary(app));
            }
        }

        static class SummaryBuilder {
            final StringBuilder buffer = new StringBuilder();

            SummaryBuilder() {
            }

            SummaryBuilder add(String key, long value) {
                return this._add(key, Long.toString(value));
            }

            <T> SummaryBuilder add(String key, T value) {
                String escapedString = StringUtils.escapeString((String)String.valueOf(value), (char)'\\', (char[])charsToEscape).replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r");
                return this._add(key, escapedString);
            }

            SummaryBuilder add(SummaryBuilder summary) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append((CharSequence)summary.buffer);
                return this;
            }

            SummaryBuilder _add(String key, String value) {
                if (this.buffer.length() > 0) {
                    this.buffer.append(',');
                }
                this.buffer.append(key).append('=').append(value);
                return this;
            }

            public String toString() {
                return this.buffer.toString();
            }
        }
    }
}

