/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.cluster;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.provider.url.UrlFileName;
import org.apache.commons.vfs2.provider.url.UrlFileNameParser;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;

@MetaStoreElementType(name="NamedCluster", description="A NamedCluster")
public class NamedClusterImpl
implements NamedCluster {
    public static final String HDFS_SCHEME = "hdfs";
    public static final String MAPRFS_SCHEME = "maprfs";
    private VariableSpace variables = new Variables();
    @MetaStoreAttribute
    private String name;
    @MetaStoreAttribute
    private String hdfsHost;
    @MetaStoreAttribute
    private String hdfsPort;
    @MetaStoreAttribute
    private String hdfsUsername;
    @MetaStoreAttribute(password=true)
    private String hdfsPassword;
    @MetaStoreAttribute
    private String jobTrackerHost;
    @MetaStoreAttribute
    private String jobTrackerPort;
    @MetaStoreAttribute
    private String zooKeeperHost;
    @MetaStoreAttribute
    private String zooKeeperPort;
    @MetaStoreAttribute
    private String oozieUrl;
    @MetaStoreAttribute
    private boolean mapr;
    @MetaStoreAttribute
    private long lastModifiedDate = System.currentTimeMillis();

    public NamedClusterImpl() {
        this.initializeVariablesFrom(null);
    }

    public NamedClusterImpl(NamedCluster namedCluster) {
        this();
        this.replaceMeta(namedCluster);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void replaceMeta(NamedCluster nc) {
        this.setName(nc.getName());
        this.setHdfsHost(nc.getHdfsHost());
        this.setHdfsPort(nc.getHdfsPort());
        this.setHdfsUsername(nc.getHdfsUsername());
        this.setHdfsPassword(nc.getHdfsPassword());
        this.setJobTrackerHost(nc.getJobTrackerHost());
        this.setJobTrackerPort(nc.getJobTrackerPort());
        this.setZooKeeperHost(nc.getZooKeeperHost());
        this.setZooKeeperPort(nc.getZooKeeperPort());
        this.setOozieUrl(nc.getOozieUrl());
        this.setMapr(nc.isMapr());
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public NamedClusterImpl clone() {
        return new NamedClusterImpl(this);
    }

    public String processURLsubstitution(String incomingURL, IMetaStore metastore, VariableSpace variableSpace) {
        if (this.isMapr()) {
            String url = this.processURLsubstitution(incomingURL, MAPRFS_SCHEME, metastore, variableSpace);
            if (url != null && !url.startsWith(MAPRFS_SCHEME)) {
                url = "maprfs://" + url;
            }
            return url;
        }
        return this.processURLsubstitution(incomingURL, HDFS_SCHEME, metastore, variableSpace);
    }

    private String processURLsubstitution(String incomingURL, String hdfsScheme, IMetaStore metastore, VariableSpace variableSpace) {
        String outgoingURL = null;
        try {
            String clusterURL = this.generateURL(hdfsScheme, metastore, variableSpace);
            if (clusterURL == null) {
                outgoingURL = incomingURL;
            } else if (incomingURL.equals("/")) {
                outgoingURL = clusterURL;
            } else if (clusterURL != null) {
                String noVariablesURL = incomingURL.replaceAll("[${}]", "/");
                String fullyQualifiedIncomingURL = incomingURL;
                if (!incomingURL.startsWith(hdfsScheme)) {
                    fullyQualifiedIncomingURL = clusterURL + incomingURL;
                    noVariablesURL = clusterURL + incomingURL.replaceAll("[${}]", "/");
                }
                UrlFileNameParser parser = new UrlFileNameParser();
                FileName fileName = parser.parseUri(null, null, noVariablesURL);
                String root = fileName.getRootURI();
                String path = fullyQualifiedIncomingURL.substring(root.length() - 1);
                StringBuffer buffer = new StringBuffer();
                buffer.append(clusterURL);
                buffer.append(path);
                outgoingURL = buffer.toString();
            }
        }
        catch (Exception e) {
            outgoingURL = null;
        }
        return outgoingURL;
    }

    @VisibleForTesting
    String generateURL(String scheme, IMetaStore metastore, VariableSpace variableSpace) {
        String clusterURL = null;
        try {
            if (!Const.isEmpty((String)scheme) && metastore != null) {
                String ncPassword;
                if (!scheme.equals(HDFS_SCHEME)) {
                    return null;
                }
                String ncHostname = this.getHdfsHost() != null ? this.getHdfsHost() : "";
                String ncPort = this.getHdfsPort() != null ? this.getHdfsPort() : "";
                String ncUsername = this.getHdfsUsername() != null ? this.getHdfsUsername() : "";
                String string = ncPassword = this.getHdfsPassword() != null ? this.getHdfsPassword() : "";
                if (variableSpace != null) {
                    variableSpace.initializeVariablesFrom(this.getParentVariableSpace());
                    if (StringUtil.isVariable((String)ncHostname)) {
                        String string2 = ncHostname = variableSpace.getVariable(StringUtil.getVariableName((String)ncHostname)) != null ? variableSpace.environmentSubstitute(ncHostname) : null;
                    }
                    if (StringUtil.isVariable((String)ncPort)) {
                        String string3 = ncPort = variableSpace.getVariable(StringUtil.getVariableName((String)ncPort)) != null ? variableSpace.environmentSubstitute(ncPort) : null;
                    }
                    if (StringUtil.isVariable((String)ncUsername)) {
                        String string4 = ncUsername = variableSpace.getVariable(StringUtil.getVariableName((String)ncUsername)) != null ? variableSpace.environmentSubstitute(ncUsername) : null;
                    }
                    if (StringUtil.isVariable((String)ncPassword)) {
                        ncPassword = variableSpace.getVariable(StringUtil.getVariableName((String)ncPassword)) != null ? variableSpace.environmentSubstitute(ncPassword) : null;
                    }
                }
                String string5 = ncHostname = ncHostname != null ? ncHostname.trim() : "";
                if (ncPort == null) {
                    ncPort = "-1";
                } else if (Const.isEmpty((String)(ncPort = ncPort.trim()))) {
                    ncPort = "-1";
                }
                ncUsername = ncUsername != null ? ncUsername.trim() : "";
                ncPassword = ncPassword != null ? ncPassword.trim() : "";
                UrlFileName file = new UrlFileName(scheme, ncHostname, Integer.parseInt(ncPort), -1, ncUsername, ncPassword, null, null, null);
                clusterURL = file.getURI();
                if (clusterURL.endsWith("/")) {
                    clusterURL = clusterURL.substring(0, clusterURL.lastIndexOf("/"));
                }
            }
        }
        catch (Exception e) {
            clusterURL = null;
        }
        return clusterURL;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedCluster other = (NamedCluster)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String getHdfsHost() {
        return this.hdfsHost;
    }

    public void setHdfsHost(String hdfsHost) {
        this.hdfsHost = hdfsHost;
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getHdfsUsername() {
        return this.hdfsUsername;
    }

    public void setHdfsUsername(String hdfsUsername) {
        this.hdfsUsername = hdfsUsername;
    }

    public String getHdfsPassword() {
        return this.hdfsPassword;
    }

    public void setHdfsPassword(String hdfsPassword) {
        this.hdfsPassword = hdfsPassword;
    }

    public String getJobTrackerHost() {
        return this.jobTrackerHost;
    }

    public void setJobTrackerHost(String jobTrackerHost) {
        this.jobTrackerHost = jobTrackerHost;
    }

    public String getJobTrackerPort() {
        return this.jobTrackerPort;
    }

    public void setJobTrackerPort(String jobTrackerPort) {
        this.jobTrackerPort = jobTrackerPort;
    }

    public String getZooKeeperHost() {
        return this.zooKeeperHost;
    }

    public void setZooKeeperHost(String zooKeeperHost) {
        this.zooKeeperHost = zooKeeperHost;
    }

    public String getZooKeeperPort() {
        return this.zooKeeperPort;
    }

    public void setZooKeeperPort(String zooKeeperPort) {
        this.zooKeeperPort = zooKeeperPort;
    }

    public String getOozieUrl() {
        return this.oozieUrl;
    }

    public void setOozieUrl(String oozieUrl) {
        this.oozieUrl = oozieUrl;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setMapr(boolean mapr) {
        this.mapr = mapr;
    }

    public boolean isMapr() {
        return this.mapr;
    }

    public String toString() {
        return "Named cluster: " + this.getName();
    }
}

