/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.mbox;

import java.io.File;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import net.fortuna.mstor.MStorFolder;
import net.fortuna.mstor.MStorStore;
import net.fortuna.mstor.connector.AbstractProtocolConnector;
import net.fortuna.mstor.connector.mbox.MboxFolder;
import net.fortuna.mstor.connector.mbox.MetaFolder;
import net.fortuna.mstor.connector.mbox.YamlMetaFolder;
import net.fortuna.mstor.util.Configurator;

public class MboxConnector
extends AbstractProtocolConnector {
    public static final String KEY_METADATA_STRATEGY = "mstor.mbox.metadataStrategy";
    private MetadataStrategy metadataStrategy;

    public MboxConnector(URLName url, MStorStore store, Session session) {
        super(url, store);
        if (session.getProperties().getProperty(KEY_METADATA_STRATEGY, Configurator.getProperty(KEY_METADATA_STRATEGY)) != null) {
            this.metadataStrategy = MetadataStrategy.valueOf(session.getProperties().getProperty(KEY_METADATA_STRATEGY, Configurator.getProperty(KEY_METADATA_STRATEGY)).toUpperCase());
        }
    }

    public boolean connect() throws AuthenticationFailedException, MessagingException {
        return true;
    }

    public void disconnect() throws MessagingException {
    }

    public Folder getDefaultFolder() throws MessagingException {
        return this.getFolder("");
    }

    public Folder getFolder(String name) throws MessagingException {
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = new File(this.url.getFile(), name);
        }
        if (MetadataStrategy.YAML.equals((Object)this.metadataStrategy)) {
            return new MStorFolder(this.store, new YamlMetaFolder(new MboxFolder(file)));
        }
        if (MetadataStrategy.XML.equals((Object)this.metadataStrategy)) {
            return new MStorFolder(this.store, new MetaFolder(new MboxFolder(file)));
        }
        if (MetadataStrategy.NONE.equals((Object)this.metadataStrategy)) {
            return new MStorFolder(this.store, new MboxFolder(file));
        }
        throw new IllegalArgumentException("Unrecognised metadata strategy: " + (Object)((Object)this.metadataStrategy));
    }

    public Folder getFolder(URLName url) throws MessagingException {
        return this.getFolder(url.getFile());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataStrategy {
        XML,
        YAML,
        NONE;

    }
}

