/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.ParameterVerifier;
import org.apache.oozie.util.ParameterVerifierException;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.ControlNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeDef;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.xml.sax.SAXException;

public class LiteWorkflowAppParser {
    private static final String DECISION_E = "decision";
    private static final String ACTION_E = "action";
    private static final String END_E = "end";
    private static final String START_E = "start";
    private static final String JOIN_E = "join";
    private static final String FORK_E = "fork";
    private static final Object KILL_E = "kill";
    private static final String SLA_INFO = "info";
    private static final String CREDENTIALS = "credentials";
    private static final String GLOBAL = "global";
    private static final String PARAMETERS = "parameters";
    private static final String NAME_A = "name";
    private static final String CRED_A = "cred";
    private static final String USER_RETRY_MAX_A = "retry-max";
    private static final String USER_RETRY_INTERVAL_A = "retry-interval";
    private static final String TO_A = "to";
    private static final String FORK_PATH_E = "path";
    private static final String FORK_START_A = "start";
    private static final String ACTION_OK_E = "ok";
    private static final String ACTION_ERROR_E = "error";
    private static final String DECISION_SWITCH_E = "switch";
    private static final String DECISION_CASE_E = "case";
    private static final String DECISION_DEFAULT_E = "default";
    private static final String KILL_MESSAGE_E = "message";
    public static final String VALIDATE_FORK_JOIN = "oozie.validate.ForkJoin";
    public static final String WF_VALIDATE_FORK_JOIN = "oozie.wf.validate.ForkJoin";
    public static final String DEFAULT_NAME_NODE = "oozie.actions.default.name-node";
    public static final String DEFAULT_JOB_TRACKER = "oozie.actions.default.job-tracker";
    private static final String JOB_TRACKER = "job-tracker";
    private static final String NAME_NODE = "name-node";
    private static final String JOB_XML = "job-xml";
    private static final String CONFIGURATION = "configuration";
    private Schema schema;
    private Class<? extends ControlNodeHandler> controlNodeHandler;
    private Class<? extends DecisionNodeHandler> decisionHandlerClass;
    private Class<? extends ActionNodeHandler> actionHandlerClass;
    private List<String> forkList = new ArrayList<String>();
    private List<String> joinList = new ArrayList<String>();
    private StartNodeDef startNode;
    private List<NodeAndTopDecisionParent> visitedOkNodes = new ArrayList<NodeAndTopDecisionParent>();
    private List<String> visitedJoinNodes = new ArrayList<String>();
    private String defaultNameNode;
    private String defaultJobTracker;

    public LiteWorkflowAppParser(Schema schema, Class<? extends ControlNodeHandler> controlNodeHandler, Class<? extends DecisionNodeHandler> decisionHandlerClass, Class<? extends ActionNodeHandler> actionHandlerClass) throws WorkflowException {
        this.schema = schema;
        this.controlNodeHandler = controlNodeHandler;
        this.decisionHandlerClass = decisionHandlerClass;
        this.actionHandlerClass = actionHandlerClass;
        this.defaultNameNode = ConfigurationService.get(DEFAULT_NAME_NODE);
        if (this.defaultNameNode != null) {
            this.defaultNameNode = this.defaultNameNode.trim();
            if (this.defaultNameNode.isEmpty()) {
                this.defaultNameNode = null;
            }
        }
        this.defaultJobTracker = ConfigurationService.get(DEFAULT_JOB_TRACKER);
        if (this.defaultJobTracker != null) {
            this.defaultJobTracker = this.defaultJobTracker.trim();
            if (this.defaultJobTracker.isEmpty()) {
                this.defaultJobTracker = null;
            }
        }
    }

    public LiteWorkflowApp validateAndParse(Reader reader, Configuration jobConf) throws WorkflowException {
        return this.validateAndParse(reader, jobConf, null);
    }

    public LiteWorkflowApp validateAndParse(Reader reader, Configuration jobConf, Configuration configDefault) throws WorkflowException {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            String strDef = writer.toString();
            if (this.schema != null) {
                Validator validator = this.schema.newValidator();
                validator.validate(new StreamSource(new StringReader(strDef)));
            }
            Element wfDefElement = XmlUtils.parseXml(strDef);
            ParameterVerifier.verifyParameters(jobConf, wfDefElement);
            LiteWorkflowApp app = this.parse(strDef, wfDefElement, configDefault, jobConf);
            HashMap<String, VisitStatus> traversed = new HashMap<String, VisitStatus>();
            traversed.put(app.getNode(":start:").getName(), VisitStatus.VISITING);
            this.validate(app, app.getNode(":start:"), traversed);
            if (jobConf.getBoolean(WF_VALIDATE_FORK_JOIN, true) && ConfigurationService.getBoolean(VALIDATE_FORK_JOIN)) {
                this.validateForkJoin(app);
            }
            return app;
        }
        catch (ParameterVerifierException ex) {
            throw new WorkflowException(ex);
        }
        catch (JDOMException ex) {
            throw new WorkflowException(ErrorCode.E0700, new Object[]{ex.getMessage(), ex});
        }
        catch (SAXException ex) {
            throw new WorkflowException(ErrorCode.E0701, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0702, ex.getMessage(), ex);
        }
    }

    private void validateForkJoin(LiteWorkflowApp app) throws WorkflowException {
        if (this.forkList.size() != this.joinList.size()) {
            throw new WorkflowException(ErrorCode.E0730, new Object[0]);
        }
        if (!this.forkList.isEmpty()) {
            this.visitedOkNodes.clear();
            this.visitedJoinNodes.clear();
            this.validateForkJoin(this.startNode, app, new LinkedList<String>(), new LinkedList<String>(), new LinkedList<String>(), true, null);
        }
    }

    private void validateForkJoin(NodeDef node, LiteWorkflowApp app, Deque<String> forkNodes, Deque<String> joinNodes, Deque<String> path, boolean okTo, String topDecisionParent) throws WorkflowException {
        String transition;
        if (path.contains(node.getName())) {
            throw new WorkflowException(ErrorCode.E0741, node.getName(), Arrays.toString(path.toArray()));
        }
        path.push(node.getName());
        if (okTo && !(node instanceof KillNodeDef) && !(node instanceof JoinNodeDef) && !(node instanceof EndNodeDef)) {
            NodeAndTopDecisionParent natdp = this.findInVisitedOkNodes(node.getName());
            if (natdp != null) {
                if (natdp.topDecisionParent == null && topDecisionParent == null || natdp.topDecisionParent == null && topDecisionParent != null || natdp.topDecisionParent != null && topDecisionParent == null || !natdp.topDecisionParent.equals(topDecisionParent)) {
                    throw new WorkflowException(ErrorCode.E0743, node.getName());
                }
            } else {
                this.visitedOkNodes.add(new NodeAndTopDecisionParent(node.getName(), topDecisionParent));
            }
        }
        if (node instanceof StartNodeDef) {
            transition = node.getTransitions().get(0);
            NodeDef tranNode = app.getNode(transition);
            this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo, topDecisionParent);
        } else if (node instanceof ActionNodeDef) {
            transition = node.getTransitions().get(0);
            NodeDef tranNode = app.getNode(transition);
            this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo, topDecisionParent);
            transition = node.getTransitions().get(1);
            tranNode = app.getNode(transition);
            this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, false, topDecisionParent);
        } else if (node instanceof DecisionNodeDef) {
            for (String transition2 : new HashSet<String>(node.getTransitions())) {
                NodeDef tranNode = app.getNode(transition2);
                String parentDecisionNode = topDecisionParent;
                if (parentDecisionNode == null) {
                    parentDecisionNode = node.getName();
                }
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo, parentDecisionNode);
            }
        } else if (node instanceof ForkNodeDef) {
            forkNodes.push(node.getName());
            List<String> transitionsList = node.getTransitions();
            HashSet<String> transitionsSet = new HashSet<String>(transitionsList);
            if (!transitionsList.isEmpty() && transitionsList.size() != transitionsSet.size()) {
                for (int i = 0; i < transitionsList.size(); ++i) {
                    String a = transitionsList.get(i);
                    NodeDef aNode = app.getNode(a);
                    if (aNode instanceof JoinNodeDef || aNode instanceof KillNodeDef) continue;
                    for (int k = i + 1; k < transitionsList.size(); ++k) {
                        String b = transitionsList.get(k);
                        if (!a.equals(b)) continue;
                        throw new WorkflowException(ErrorCode.E0744, node.getName(), a);
                    }
                }
            }
            for (String transition3 : transitionsSet) {
                NodeDef tranNode = app.getNode(transition3);
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, okTo, topDecisionParent);
            }
            forkNodes.pop();
            if (!joinNodes.isEmpty()) {
                joinNodes.pop();
            }
        } else if (node instanceof JoinNodeDef) {
            if (forkNodes.isEmpty()) {
                throw new WorkflowException(ErrorCode.E0742, node.getName());
            }
            if (forkNodes.size() > joinNodes.size() && (joinNodes.isEmpty() || !joinNodes.peek().equals(node.getName()))) {
                joinNodes.push(node.getName());
            }
            if (!joinNodes.peek().equals(node.getName())) {
                throw new WorkflowException(ErrorCode.E0732, forkNodes.peek(), node.getName(), joinNodes.peek());
            }
            joinNodes.pop();
            String currentForkNode = forkNodes.pop();
            String transition4 = node.getTransitions().get(0);
            NodeDef tranNode = app.getNode(transition4);
            if (!okTo || this.visitedJoinNodes.contains(node.getName())) {
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, false, topDecisionParent);
            } else {
                this.visitedJoinNodes.add(node.getName());
                this.validateForkJoin(tranNode, app, forkNodes, joinNodes, path, true, topDecisionParent);
            }
            forkNodes.push(currentForkNode);
            joinNodes.push(node.getName());
        } else if (!(node instanceof KillNodeDef)) {
            if (node instanceof EndNodeDef) {
                if (!forkNodes.isEmpty()) {
                    path.pop();
                    String parent = path.peek();
                    throw new WorkflowException(ErrorCode.E0737, parent, node.getName());
                }
            } else {
                throw new WorkflowException(ErrorCode.E0740, node.getName());
            }
        }
        path.pop();
    }

    private NodeAndTopDecisionParent findInVisitedOkNodes(String name) {
        NodeAndTopDecisionParent natdp = null;
        for (NodeAndTopDecisionParent v : this.visitedOkNodes) {
            if (!v.node.equals(name)) continue;
            natdp = v;
            break;
        }
        return natdp;
    }

    private LiteWorkflowApp parse(String strDef, Element root, Configuration configDefault, Configuration jobConf) throws WorkflowException {
        Namespace ns = root.getNamespace();
        LiteWorkflowApp def = null;
        GlobalSectionData gData = null;
        for (Element eNode : root.getChildren()) {
            if (eNode.getName().equals("start")) {
                def = new LiteWorkflowApp(root.getAttributeValue(NAME_A), strDef, new StartNodeDef(this.controlNodeHandler, eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(END_E)) {
                def.addNode(new EndNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler));
                continue;
            }
            if (eNode.getName().equals(KILL_E)) {
                def.addNode(new KillNodeDef(eNode.getAttributeValue(NAME_A), eNode.getChildText(KILL_MESSAGE_E, ns), this.controlNodeHandler));
                continue;
            }
            if (eNode.getName().equals(FORK_E)) {
                ArrayList<String> paths = new ArrayList<String>();
                for (Element tran : eNode.getChildren(FORK_PATH_E, ns)) {
                    paths.add(tran.getAttributeValue("start"));
                }
                def.addNode(new ForkNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler, paths));
                continue;
            }
            if (eNode.getName().equals(JOIN_E)) {
                def.addNode(new JoinNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler, eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(DECISION_E)) {
                Element eSwitch = eNode.getChild(DECISION_SWITCH_E, ns);
                ArrayList<String> transitions = new ArrayList<String>();
                for (Element e : eSwitch.getChildren(DECISION_CASE_E, ns)) {
                    transitions.add(e.getAttributeValue(TO_A));
                }
                transitions.add(eSwitch.getChild(DECISION_DEFAULT_E, ns).getAttributeValue(TO_A));
                String switchStatement = XmlUtils.prettyPrint(eSwitch).toString();
                def.addNode(new DecisionNodeDef(eNode.getAttributeValue(NAME_A), switchStatement, this.decisionHandlerClass, (List<String>)transitions));
                continue;
            }
            if (ACTION_E.equals(eNode.getName())) {
                String[] transitions = new String[2];
                Element eActionConf = null;
                for (Element elem : eNode.getChildren()) {
                    if (ACTION_OK_E.equals(elem.getName())) {
                        transitions[0] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (ACTION_ERROR_E.equals(elem.getName())) {
                        transitions[1] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (SLA_INFO.equals(elem.getName()) || CREDENTIALS.equals(elem.getName())) continue;
                    eActionConf = elem;
                    this.handleDefaultsAndGlobal(gData, configDefault, elem);
                }
                String credStr = eNode.getAttributeValue(CRED_A);
                String userRetryMaxStr = eNode.getAttributeValue(USER_RETRY_MAX_A);
                String userRetryIntervalStr = eNode.getAttributeValue(USER_RETRY_INTERVAL_A);
                try {
                    if (!StringUtils.isEmpty((String)userRetryMaxStr)) {
                        userRetryMaxStr = ELUtils.resolveAppName(userRetryMaxStr, jobConf);
                    }
                    if (!StringUtils.isEmpty((String)userRetryIntervalStr)) {
                        userRetryIntervalStr = ELUtils.resolveAppName(userRetryIntervalStr, jobConf);
                    }
                }
                catch (Exception e) {
                    throw new WorkflowException(ErrorCode.E0703, e.getMessage());
                }
                String actionConf = XmlUtils.prettyPrint(eActionConf).toString();
                def.addNode(new ActionNodeDef(eNode.getAttributeValue(NAME_A), actionConf, this.actionHandlerClass, transitions[0], transitions[1], credStr, userRetryMaxStr, userRetryIntervalStr));
                continue;
            }
            if (SLA_INFO.equals(eNode.getName()) || CREDENTIALS.equals(eNode.getName())) continue;
            if (eNode.getName().equals(GLOBAL)) {
                gData = this.parseGlobalSection(ns, eNode);
                continue;
            }
            if (eNode.getName().equals(PARAMETERS)) continue;
            throw new WorkflowException(ErrorCode.E0703, eNode.getName());
        }
        return def;
    }

    private void validate(LiteWorkflowApp app, NodeDef node, Map<String, VisitStatus> traversed) throws WorkflowException {
        if (node instanceof StartNodeDef) {
            this.startNode = (StartNodeDef)node;
        } else {
            try {
                ParamChecker.validateActionName(node.getName());
            }
            catch (IllegalArgumentException ex) {
                throw new WorkflowException(ErrorCode.E0724, ex.getMessage());
            }
        }
        if (node instanceof ActionNodeDef) {
            try {
                boolean supportedAction;
                Element action = XmlUtils.parseXml(node.getConf());
                boolean bl = supportedAction = Services.get().get(ActionService.class).getExecutor(action.getName()) != null;
                if (!supportedAction) {
                    throw new WorkflowException(ErrorCode.E0723, node.getName(), action.getName());
                }
            }
            catch (JDOMException ex) {
                throw new RuntimeException("It should never happen, " + ex.getMessage(), ex);
            }
        }
        if (node instanceof ForkNodeDef) {
            this.forkList.add(node.getName());
        }
        if (node instanceof JoinNodeDef) {
            this.joinList.add(node.getName());
        }
        if (node instanceof EndNodeDef) {
            traversed.put(node.getName(), VisitStatus.VISITED);
            return;
        }
        if (node instanceof KillNodeDef) {
            traversed.put(node.getName(), VisitStatus.VISITED);
            return;
        }
        for (String transition : node.getTransitions()) {
            if (app.getNode(transition) == null) {
                throw new WorkflowException(ErrorCode.E0708, node.getName(), transition);
            }
            if (traversed.get(app.getNode(transition).getName()) == VisitStatus.VISITING) {
                throw new WorkflowException(ErrorCode.E0707, app.getNode(transition).getName());
            }
            if (traversed.get(app.getNode(transition).getName()) == VisitStatus.VISITED) continue;
            traversed.put(app.getNode(transition).getName(), VisitStatus.VISITING);
            this.validate(app, app.getNode(transition), traversed);
        }
        traversed.put(node.getName(), VisitStatus.VISITED);
    }

    private void addChildElement(Element parent, Namespace ns, String childName, String childValue) {
        Element child = new Element(childName, ns);
        child.setText(childValue);
        parent.addContent((Content)child);
    }

    private GlobalSectionData parseGlobalSection(Namespace ns, Element global) throws WorkflowException {
        GlobalSectionData gData = null;
        if (global != null) {
            String globalJobTracker = null;
            Element globalJobTrackerElement = global.getChild(JOB_TRACKER, ns);
            if (globalJobTrackerElement != null) {
                globalJobTracker = globalJobTrackerElement.getValue();
            }
            String globalNameNode = null;
            Element globalNameNodeElement = global.getChild(NAME_NODE, ns);
            if (globalNameNodeElement != null) {
                globalNameNode = globalNameNodeElement.getValue();
            }
            ArrayList<String> globalJobXmls = null;
            List globalJobXmlElements = global.getChildren(JOB_XML, ns);
            if (!globalJobXmlElements.isEmpty()) {
                globalJobXmls = new ArrayList<String>(globalJobXmlElements.size());
                for (Element jobXmlElement : globalJobXmlElements) {
                    globalJobXmls.add(jobXmlElement.getText());
                }
            }
            XConfiguration globalConf = null;
            Element globalConfigurationElement = global.getChild(CONFIGURATION, ns);
            if (globalConfigurationElement != null) {
                try {
                    globalConf = new XConfiguration(new StringReader(XmlUtils.prettyPrint(globalConfigurationElement).toString()));
                }
                catch (IOException ioe) {
                    throw new WorkflowException(ErrorCode.E0700, "Error while processing global section conf");
                }
            }
            gData = new GlobalSectionData(globalJobTracker, globalNameNode, globalJobXmls, globalConf);
        }
        return gData;
    }

    private void handleDefaultsAndGlobal(GlobalSectionData gData, Configuration configDefault, Element actionElement) throws WorkflowException {
        ActionExecutor ae = Services.get().get(ActionService.class).getExecutor(actionElement.getName());
        if (ae == null) {
            throw new WorkflowException(ErrorCode.E0723, actionElement.getName(), ActionService.class.getName());
        }
        Namespace actionNs = actionElement.getNamespace();
        if (ae.requiresNameNodeJobTracker()) {
            if (actionElement.getChild(NAME_NODE, actionNs) == null) {
                if (gData != null && gData.nameNode != null) {
                    this.addChildElement(actionElement, actionNs, NAME_NODE, gData.nameNode);
                } else if (this.defaultNameNode != null) {
                    this.addChildElement(actionElement, actionNs, NAME_NODE, this.defaultNameNode);
                } else {
                    throw new WorkflowException(ErrorCode.E0701, "No name-node defined");
                }
            }
            if (actionElement.getChild(JOB_TRACKER, actionNs) == null) {
                if (gData != null && gData.jobTracker != null) {
                    this.addChildElement(actionElement, actionNs, JOB_TRACKER, gData.jobTracker);
                } else if (this.defaultJobTracker != null) {
                    this.addChildElement(actionElement, actionNs, JOB_TRACKER, this.defaultJobTracker);
                } else {
                    throw new WorkflowException(ErrorCode.E0701, "No job-tracker defined");
                }
            }
        }
        if (ae.supportsConfigurationJobXML()) {
            List actionJobXmls = actionElement.getChildren(JOB_XML, actionNs);
            if (gData != null && gData.jobXmls != null) {
                for (String gJobXml : gData.jobXmls) {
                    boolean alreadyExists = false;
                    for (Element actionXml : actionJobXmls) {
                        if (!gJobXml.equals(actionXml.getText())) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    Element ejobXml = new Element(JOB_XML, actionNs);
                    ejobXml.setText(gJobXml);
                    actionElement.addContent((Content)ejobXml);
                }
            }
            try {
                Element actionConfiguration;
                XConfiguration actionConf = new XConfiguration();
                if (configDefault != null) {
                    XConfiguration.copy(configDefault, actionConf);
                }
                if (gData != null && gData.conf != null) {
                    XConfiguration.copy(gData.conf, actionConf);
                }
                if ((actionConfiguration = actionElement.getChild(CONFIGURATION, actionNs)) != null) {
                    XConfiguration.copy(new XConfiguration(new StringReader(XmlUtils.prettyPrint(actionConfiguration).toString())), actionConf);
                }
                int position = actionElement.indexOf((Content)actionConfiguration);
                actionElement.removeContent((Content)actionConfiguration);
                Element eConfXml = XmlUtils.parseXml(actionConf.toXmlString(false));
                eConfXml.detach();
                eConfXml.setNamespace(actionNs);
                if (position > 0) {
                    actionElement.addContent(position, (Content)eConfXml);
                } else {
                    actionElement.addContent((Content)eConfXml);
                }
            }
            catch (IOException e) {
                throw new WorkflowException(ErrorCode.E0700, "Error while processing action conf");
            }
            catch (JDOMException e) {
                throw new WorkflowException(ErrorCode.E0700, "Error while processing action conf");
            }
        }
    }

    private class GlobalSectionData {
        final String jobTracker;
        final String nameNode;
        final List<String> jobXmls;
        final Configuration conf;

        public GlobalSectionData(String jobTracker, String nameNode, List<String> jobXmls, Configuration conf) {
            this.jobTracker = jobTracker;
            this.nameNode = nameNode;
            this.jobXmls = jobXmls;
            this.conf = conf;
        }
    }

    class NodeAndTopDecisionParent {
        String node;
        String topDecisionParent;

        public NodeAndTopDecisionParent(String node, String topDecisionParent) {
            this.node = node;
            this.topDecisionParent = topDecisionParent;
        }
    }

    private static enum VisitStatus {
        VISITING,
        VISITED;

    }
}

