/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.RMHAServiceTarget;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMAdminCLI
extends HAAdmin {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private boolean directlyAccessNodeLabelStore = false;
    static CommonNodeLabelsManager localNodeLabelsManager = null;
    private static final String NO_LABEL_ERR_MSG = "No cluster node-labels are specified";
    private static final String NO_MAPPING_ERR_MSG = "No node-to-labels mappings are specified";
    private static final String ADD_LABEL_FORMAT_ERR_MSG = "Input format for adding node-labels is not correct, it should be labelName1[(exclusive=true/false)],LabelName2[] ..";
    protected static final Map<String, HAAdmin.UsageInfo> ADMIN_USAGE = ImmutableMap.builder().put((Object)"-refreshQueues", (Object)new HAAdmin.UsageInfo("", "Reload the queues' acls, states and scheduler specific properties. \n\t\tResourceManager will reload the mapred-queues configuration file.")).put((Object)"-refreshNodes", (Object)new HAAdmin.UsageInfo("", "Refresh the hosts information at the ResourceManager.")).put((Object)"-refreshSuperUserGroupsConfiguration", (Object)new HAAdmin.UsageInfo("", "Refresh superuser proxy groups mappings")).put((Object)"-refreshUserToGroupsMappings", (Object)new HAAdmin.UsageInfo("", "Refresh user-to-groups mappings")).put((Object)"-refreshAdminAcls", (Object)new HAAdmin.UsageInfo("", "Refresh acls for administration of ResourceManager")).put((Object)"-refreshServiceAcl", (Object)new HAAdmin.UsageInfo("", "Reload the service-level authorization policy file. \n\t\tResoureceManager will reload the authorization policy file.")).put((Object)"-getGroups", (Object)new HAAdmin.UsageInfo("[username]", "Get the groups which given user belongs to.")).put((Object)"-addToClusterNodeLabels", (Object)new HAAdmin.UsageInfo("<\"label1(exclusive=true),label2(exclusive=false),label3\">", "add to cluster node labels. Default exclusivity is true")).put((Object)"-removeFromClusterNodeLabels", (Object)new HAAdmin.UsageInfo("<label1,label2,label3> (label splitted by \",\")", "remove from cluster node labels")).put((Object)"-replaceLabelsOnNode", (Object)new HAAdmin.UsageInfo("<\"node1[:port]=label1,label2 node2[:port]=label1,label2\">", "replace labels on nodes (please note that we do not support specifying multiple labels on a single host for now.)")).put((Object)"-directlyAccessNodeLabelStore", (Object)new HAAdmin.UsageInfo("", "This is DEPRECATED, will be removed in future releases. Directly access node label store, with this option, all node label related operations will not connect RM. Instead, they will access/modify stored node labels directly. By default, it is false (access via RM). AND PLEASE NOTE: if you configured yarn.node-labels.fs-store.root-dir to a local directory (instead of NFS or HDFS), this option will only work when the command run on the machine where RM is running.")).build();

    public RMAdminCLI() {
    }

    public RMAdminCLI(Configuration conf) {
        super(conf);
    }

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    private static void appendHAUsage(StringBuilder usageBuilder) {
        for (Map.Entry cmdEntry : USAGE.entrySet()) {
            if (((String)cmdEntry.getKey()).equals("-help") || ((String)cmdEntry.getKey()).equals("-failover")) continue;
            HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)cmdEntry.getValue();
            usageBuilder.append(" [" + (String)cmdEntry.getKey() + " " + usageInfo.args + "]");
        }
    }

    private static void buildHelpMsg(String cmd, StringBuilder builder) {
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null && (usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd)) == null) {
            return;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("   " + cmd + space + usageInfo.args + ": " + usageInfo.help);
    }

    private static void buildIndividualUsageMsg(String cmd, StringBuilder builder) {
        boolean isHACommand = false;
        HAAdmin.UsageInfo usageInfo = ADMIN_USAGE.get(cmd);
        if (usageInfo == null) {
            usageInfo = (HAAdmin.UsageInfo)USAGE.get(cmd);
            if (usageInfo == null) {
                return;
            }
            isHACommand = true;
        }
        String space = usageInfo.args == "" ? "" : " ";
        builder.append("Usage: yarn rmadmin [" + cmd + space + usageInfo.args + "]\n");
        if (isHACommand) {
            builder.append(cmd + " can only be used when RM HA is enabled");
        }
    }

    private static void buildUsageMsg(StringBuilder builder, boolean isHAEnabled) {
        builder.append("Usage: yarn rmadmin\n");
        for (Map.Entry<String, HAAdmin.UsageInfo> entry : ADMIN_USAGE.entrySet()) {
            HAAdmin.UsageInfo usageInfo = entry.getValue();
            builder.append("   " + entry.getKey() + " " + usageInfo.args + "\n");
        }
        if (isHAEnabled) {
            for (Map.Entry<String, Object> entry : USAGE.entrySet()) {
                String cmdKey = entry.getKey();
                if (cmdKey.equals("-help")) continue;
                HAAdmin.UsageInfo usageInfo = (HAAdmin.UsageInfo)entry.getValue();
                builder.append("   " + cmdKey + " " + usageInfo.args + "\n");
            }
        }
        builder.append("   -help [cmd]\n");
    }

    private static void printHelp(String cmd, boolean isHAEnabled) {
        StringBuilder summary = new StringBuilder();
        summary.append("rmadmin is the command to execute YARN administrative commands.\n");
        summary.append("The full syntax is: \n\nyarn rmadmin [-refreshQueues] [-refreshNodes] [-refreshSuperUserGroupsConfiguration] [-refreshUserToGroupsMappings] [-refreshAdminAcls] [-refreshServiceAcl] [-getGroup [username]] [-addToClusterNodeLabels <\"label1(exclusive=true),label2(exclusive=false),label3\">] [-removeFromClusterNodeLabels <label1,label2,label3>] [-replaceLabelsOnNode <\"node1[:port]=label1,label2 node2[:port]=label1\">] [-directlyAccessNodeLabelStore]]");
        if (isHAEnabled) {
            RMAdminCLI.appendHAUsage(summary);
        }
        summary.append(" [-help [cmd]]");
        summary.append("\n");
        StringBuilder helpBuilder = new StringBuilder();
        System.out.println(summary);
        for (String cmdKey : ADMIN_USAGE.keySet()) {
            RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
            helpBuilder.append("\n");
        }
        if (isHAEnabled) {
            for (String cmdKey : USAGE.keySet()) {
                if (cmdKey.equals("-help") || cmdKey.equals("-failover")) continue;
                RMAdminCLI.buildHelpMsg(cmdKey, helpBuilder);
                helpBuilder.append("\n");
            }
        }
        helpBuilder.append("   -help [cmd]: Displays help for the given command or all commands if none is specified.");
        System.out.println(helpBuilder);
        System.out.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.out);
    }

    private static void printUsage(String cmd, boolean isHAEnabled) {
        StringBuilder usageBuilder = new StringBuilder();
        if (ADMIN_USAGE.containsKey(cmd) || USAGE.containsKey(cmd)) {
            RMAdminCLI.buildIndividualUsageMsg(cmd, usageBuilder);
        } else {
            RMAdminCLI.buildUsageMsg(usageBuilder, isHAEnabled);
        }
        System.err.println(usageBuilder);
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
    }

    protected ResourceManagerAdministrationProtocol createAdminProtocol() throws IOException {
        YarnConfiguration conf = new YarnConfiguration(this.getConf());
        return (ResourceManagerAdministrationProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ResourceManagerAdministrationProtocol.class);
    }

    private int refreshQueues() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshQueuesRequest request = (RefreshQueuesRequest)this.recordFactory.newRecordInstance(RefreshQueuesRequest.class);
        adminProtocol.refreshQueues(request);
        return 0;
    }

    private int refreshNodes() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshNodesRequest request = (RefreshNodesRequest)this.recordFactory.newRecordInstance(RefreshNodesRequest.class);
        adminProtocol.refreshNodes(request);
        return 0;
    }

    private int refreshUserToGroupsMappings() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshUserToGroupsMappingsRequest request = (RefreshUserToGroupsMappingsRequest)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsRequest.class);
        adminProtocol.refreshUserToGroupsMappings(request);
        return 0;
    }

    private int refreshSuperUserGroupsConfiguration() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshSuperUserGroupsConfigurationRequest request = (RefreshSuperUserGroupsConfigurationRequest)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationRequest.class);
        adminProtocol.refreshSuperUserGroupsConfiguration(request);
        return 0;
    }

    private int refreshAdminAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshAdminAclsRequest request = (RefreshAdminAclsRequest)this.recordFactory.newRecordInstance(RefreshAdminAclsRequest.class);
        adminProtocol.refreshAdminAcls(request);
        return 0;
    }

    private int refreshServiceAcls() throws IOException, YarnException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        RefreshServiceAclsRequest request = (RefreshServiceAclsRequest)this.recordFactory.newRecordInstance(RefreshServiceAclsRequest.class);
        adminProtocol.refreshServiceAcls(request);
        return 0;
    }

    private int getGroups(String[] usernames) throws IOException {
        ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
        if (usernames.length == 0) {
            usernames = new String[]{UserGroupInformation.getCurrentUser().getUserName()};
        }
        for (String username : usernames) {
            StringBuilder sb = new StringBuilder();
            sb.append(username + " :");
            for (String group : adminProtocol.getGroupsForUser(username)) {
                sb.append(" ");
                sb.append(group);
            }
            System.out.println(sb);
        }
        return 0;
    }

    protected static synchronized CommonNodeLabelsManager getNodeLabelManagerInstance(Configuration conf) {
        if (localNodeLabelsManager == null) {
            localNodeLabelsManager = new CommonNodeLabelsManager();
            localNodeLabelsManager.init(conf);
            localNodeLabelsManager.start();
        }
        return localNodeLabelsManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<NodeLabel> buildNodeLabelsFromStr(String args) {
        ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>();
        for (String p : args.split(",")) {
            if (p.trim().isEmpty()) continue;
            String labelName = p;
            boolean exclusive = true;
            int leftParenthesisIdx = p.indexOf("(");
            int rightParenthesisIdx = p.indexOf(")");
            if (leftParenthesisIdx == -1 && rightParenthesisIdx != -1 || leftParenthesisIdx != -1 && rightParenthesisIdx == -1) {
                throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
            }
            if (leftParenthesisIdx > 0 && rightParenthesisIdx > 0) {
                if (leftParenthesisIdx > rightParenthesisIdx) {
                    throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                }
                String property = p.substring(p.indexOf("(") + 1, p.indexOf(")"));
                if (property.contains("=")) {
                    String key = property.substring(0, property.indexOf("=")).trim();
                    String value = property.substring(property.indexOf("=") + 1, property.length()).trim();
                    if (!key.equals("exclusive") || !ImmutableSet.of((Object)"true", (Object)"false").contains((Object)value)) throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                    exclusive = Boolean.parseBoolean(value);
                } else if (!property.trim().isEmpty()) {
                    throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                }
            }
            if (labelName.contains("(")) {
                labelName = labelName.substring(0, labelName.indexOf("(")).trim();
            }
            nodeLabels.add(NodeLabel.newInstance((String)labelName, (boolean)exclusive));
        }
        if (!nodeLabels.isEmpty()) return nodeLabels;
        throw new IllegalArgumentException(NO_LABEL_ERR_MSG);
    }

    private Set<String> buildNodeLabelNamesFromStr(String args) {
        HashSet<String> labels = new HashSet<String>();
        for (String p : args.split(",")) {
            if (p.trim().isEmpty()) continue;
            labels.add(p.trim());
        }
        if (labels.isEmpty()) {
            throw new IllegalArgumentException(NO_LABEL_ERR_MSG);
        }
        return labels;
    }

    private int addToClusterNodeLabels(String args) throws IOException, YarnException {
        List<NodeLabel> labels = this.buildNodeLabelsFromStr(args);
        if (this.directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).addToCluserNodeLabels(labels);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            AddToClusterNodeLabelsRequest request = AddToClusterNodeLabelsRequest.newInstance(labels);
            adminProtocol.addToClusterNodeLabels(request);
        }
        return 0;
    }

    private int removeFromClusterNodeLabels(String args) throws IOException, YarnException {
        Set<String> labels = this.buildNodeLabelNamesFromStr(args);
        if (this.directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).removeFromClusterNodeLabels(labels);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            RemoveFromClusterNodeLabelsRequest request = RemoveFromClusterNodeLabelsRequest.newInstance(labels);
            adminProtocol.removeFromClusterNodeLabels(request);
        }
        return 0;
    }

    private Map<NodeId, Set<String>> buildNodeLabelsMapFromStr(String args) {
        HashMap<NodeId, Set<String>> map = new HashMap<NodeId, Set<String>>();
        for (String nodeToLabels : args.split("[ \n]")) {
            if ((nodeToLabels = nodeToLabels.trim()).isEmpty() || nodeToLabels.startsWith("#")) continue;
            String[] splits = nodeToLabels.split("=");
            int index = 0;
            if (splits.length != 2) {
                splits = nodeToLabels.split(",");
                index = 1;
            }
            String nodeIdStr = splits[0];
            if (index == 0) {
                splits = splits[1].split(",");
            }
            Preconditions.checkArgument((!nodeIdStr.trim().isEmpty() ? 1 : 0) != 0, (Object)"node name cannot be empty");
            NodeId nodeId = ConverterUtils.toNodeIdWithDefaultPort((String)nodeIdStr);
            map.put(nodeId, new HashSet());
            for (int i = index; i < splits.length; ++i) {
                if (splits[i].trim().isEmpty()) continue;
                ((Set)map.get(nodeId)).add(splits[i].trim());
            }
            int nLabels = ((Set)map.get(nodeId)).size();
            Preconditions.checkArgument((nLabels <= 1 ? 1 : 0) != 0, (String)"%d labels specified on host=%s, please note that we do not support specifying multiple labels on a single host for now.", (Object[])new Object[]{nLabels, nodeIdStr});
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException(NO_MAPPING_ERR_MSG);
        }
        return map;
    }

    private int replaceLabelsOnNodes(String args) throws IOException, YarnException {
        Map<NodeId, Set<String>> map = this.buildNodeLabelsMapFromStr(args);
        return this.replaceLabelsOnNodes(map);
    }

    private int replaceLabelsOnNodes(Map<NodeId, Set<String>> map) throws IOException, YarnException {
        if (this.directlyAccessNodeLabelStore) {
            RMAdminCLI.getNodeLabelManagerInstance(this.getConf()).replaceLabelsOnNode(map);
        } else {
            ResourceManagerAdministrationProtocol adminProtocol = this.createAdminProtocol();
            ReplaceLabelsOnNodeRequest request = ReplaceLabelsOnNodeRequest.newInstance(map);
            adminProtocol.replaceLabelsOnNode(request);
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-directlyAccessNodeLabelStore")) {
                this.directlyAccessNodeLabelStore = true;
                continue;
            }
            argsList.add(args[i]);
        }
        args = argsList.toArray(new String[0]);
        YarnConfiguration yarnConf = this.getConf() == null ? new YarnConfiguration() : new YarnConfiguration(this.getConf());
        boolean isHAEnabled = yarnConf.getBoolean("yarn.resourcemanager.ha.enabled", false);
        if (args.length < 1) {
            RMAdminCLI.printUsage("", isHAEnabled);
            return -1;
        }
        int exitCode = -1;
        int i = 0;
        String cmd = args[i++];
        exitCode = 0;
        if ("-help".equals(cmd)) {
            if (i < args.length) {
                RMAdminCLI.printUsage(args[i], isHAEnabled);
            } else {
                RMAdminCLI.printHelp("", isHAEnabled);
            }
            return exitCode;
        }
        if (USAGE.containsKey(cmd)) {
            if (isHAEnabled) {
                return super.run(args);
            }
            System.out.println("Cannot run " + cmd + " when ResourceManager HA is not enabled");
            return -1;
        }
        if (("-refreshAdminAcls".equals(cmd) || "-refreshQueues".equals(cmd) || "-refreshNodes".equals(cmd) || "-refreshServiceAcl".equals(cmd) || "-refreshUserToGroupsMappings".equals(cmd) || "-refreshSuperUserGroupsConfiguration".equals(cmd)) && args.length != 1) {
            RMAdminCLI.printUsage(cmd, isHAEnabled);
            return exitCode;
        }
        try {
            if ("-refreshQueues".equals(cmd)) {
                exitCode = this.refreshQueues();
            } else if ("-refreshNodes".equals(cmd)) {
                exitCode = this.refreshNodes();
            } else if ("-refreshUserToGroupsMappings".equals(cmd)) {
                exitCode = this.refreshUserToGroupsMappings();
            } else if ("-refreshSuperUserGroupsConfiguration".equals(cmd)) {
                exitCode = this.refreshSuperUserGroupsConfiguration();
            } else if ("-refreshAdminAcls".equals(cmd)) {
                exitCode = this.refreshAdminAcls();
            } else if ("-refreshServiceAcl".equals(cmd)) {
                exitCode = this.refreshServiceAcls();
            } else if ("-getGroups".equals(cmd)) {
                String[] usernames = Arrays.copyOfRange(args, i, args.length);
                exitCode = this.getGroups(usernames);
            } else if ("-addToClusterNodeLabels".equals(cmd)) {
                if (i >= args.length) {
                    System.err.println(NO_LABEL_ERR_MSG);
                    RMAdminCLI.printUsage("", isHAEnabled);
                    exitCode = -1;
                } else {
                    exitCode = this.addToClusterNodeLabels(args[i]);
                }
            } else if ("-removeFromClusterNodeLabels".equals(cmd)) {
                if (i >= args.length) {
                    System.err.println(NO_LABEL_ERR_MSG);
                    RMAdminCLI.printUsage("", isHAEnabled);
                    exitCode = -1;
                } else {
                    exitCode = this.removeFromClusterNodeLabels(args[i]);
                }
            } else if ("-replaceLabelsOnNode".equals(cmd)) {
                if (i >= args.length) {
                    System.err.println(NO_MAPPING_ERR_MSG);
                    RMAdminCLI.printUsage("", isHAEnabled);
                    exitCode = -1;
                } else {
                    exitCode = this.replaceLabelsOnNodes(args[i]);
                }
            } else {
                exitCode = -1;
                System.err.println(cmd.substring(1) + ": Unknown command");
                RMAdminCLI.printUsage("", isHAEnabled);
            }
        }
        catch (IllegalArgumentException arge) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + arge.getLocalizedMessage());
            RMAdminCLI.printUsage(cmd, isHAEnabled);
        }
        catch (RemoteException e) {
            exitCode = -1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                System.err.println(cmd.substring(1) + ": " + content[0]);
            }
            catch (Exception ex) {
                System.err.println(cmd.substring(1) + ": " + ex.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            exitCode = -1;
            System.err.println(cmd.substring(1) + ": " + e.getLocalizedMessage());
        }
        if (null != localNodeLabelsManager) {
            localNodeLabelsManager.stop();
        }
        return exitCode;
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = RMAdminCLI.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    private static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new YarnConfiguration(conf);
        conf.set("hadoop.security.service.user.name.key", conf.get("yarn.resourcemanager.principal", ""));
        return conf;
    }

    protected HAServiceTarget resolveTarget(String rmId) {
        Collection rmIds = HAUtil.getRMHAIds((Configuration)this.getConf());
        if (!rmIds.contains(rmId)) {
            StringBuilder msg = new StringBuilder();
            msg.append(rmId + " is not a valid serviceId. It should be one of ");
            for (String id : rmIds) {
                msg.append(id + " ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
        try {
            YarnConfiguration conf = new YarnConfiguration(this.getConf());
            conf.set("yarn.resourcemanager.ha.id", rmId);
            return new RMHAServiceTarget(conf);
        }
        catch (IllegalArgumentException iae) {
            throw new YarnRuntimeException("Could not connect to " + rmId + "; the configuration for it might be missing");
        }
        catch (IOException ioe) {
            throw new YarnRuntimeException("Could not connect to RM HA Admin for node " + rmId);
        }
    }

    protected String getUsageString() {
        return "Usage: rmadmin";
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new RMAdminCLI(), (String[])args);
        System.exit(result);
    }
}

