/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.execprocess;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execprocess.ExecProcess;
import org.pentaho.di.trans.steps.execprocess.ExecProcessData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ExecProcessMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ExecProcessMeta.class;
    private String processfield;
    private String resultfieldname;
    private String errorfieldname;
    private String exitvaluefieldname;
    private boolean failwhennotsuccess;
    public String outputLineDelimiter = "";

    public String getProcessField() {
        return this.processfield;
    }

    public void setProcessField(String processfield) {
        this.processfield = processfield;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public String getErrorFieldName() {
        return this.errorfieldname;
    }

    public void setErrorFieldName(String errorfieldname) {
        this.errorfieldname = errorfieldname;
    }

    public String getExitValueFieldName() {
        return this.exitvaluefieldname;
    }

    public void setExitValueFieldName(String exitvaluefieldname) {
        this.exitvaluefieldname = exitvaluefieldname;
    }

    public boolean isFailWhenNotSuccess() {
        return this.failwhennotsuccess;
    }

    public void setFailWhentNoSuccess(boolean failwhennotsuccess) {
        this.failwhennotsuccess = failwhennotsuccess;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ExecProcessMeta retval = (ExecProcessMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.resultfieldname = "Result output";
        this.errorfieldname = "Error output";
        this.exitvaluefieldname = "Exit value";
        this.failwhennotsuccess = false;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        String realexitvaluefieldname;
        String realerrofieldname;
        String realOutputFieldname = space.environmentSubstitute(this.resultfieldname);
        if (!Const.isEmpty((String)realOutputFieldname)) {
            ValueMetaString v = new ValueMetaString(realOutputFieldname);
            v.setLength(100, -1);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)(realerrofieldname = space.environmentSubstitute(this.errorfieldname)))) {
            ValueMetaString v = new ValueMetaString(realerrofieldname);
            v.setLength(100, -1);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)(realexitvaluefieldname = space.environmentSubstitute(this.exitvaluefieldname)))) {
            ValueMetaInteger v = new ValueMetaInteger(realexitvaluefieldname);
            v.setLength(10, 0);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"processfield", (String)this.processfield));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"errorfieldname", (String)this.errorfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"exitvaluefieldname", (String)this.exitvaluefieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"failwhennotsuccess", (boolean)this.failwhennotsuccess));
        retval.append("    " + XMLHandler.addTagValue((String)"outputlinedelimiter", (String)this.outputLineDelimiter));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.processfield = XMLHandler.getTagValue((Node)stepnode, (String)"processfield");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.errorfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"errorfieldname");
            this.exitvaluefieldname = XMLHandler.getTagValue((Node)stepnode, (String)"exitvaluefieldname");
            this.failwhennotsuccess = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"failwhennotsuccess"));
            this.outputLineDelimiter = XMLHandler.getTagValue((Node)stepnode, (String)"outputlinedelimiter");
            if (this.outputLineDelimiter == null) {
                this.outputLineDelimiter = "";
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ExecProcessMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.processfield = rep.getStepAttributeString(id_step, "processfield");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.errorfieldname = rep.getStepAttributeString(id_step, "errorfieldname");
            this.exitvaluefieldname = rep.getStepAttributeString(id_step, "exitvaluefieldname");
            this.failwhennotsuccess = rep.getStepAttributeBoolean(id_step, "failwhennotsuccess");
            this.outputLineDelimiter = rep.getStepAttributeString(id_step, "outputlinedelimiter");
            if (this.outputLineDelimiter == null) {
                this.outputLineDelimiter = "";
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ExecProcessMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "processfield", this.processfield);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "errorfieldname", this.errorfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "exitvaluefieldname", this.exitvaluefieldname);
            rep.saveStepAttribute(id_transformation, id_step, "failwhennotsuccess", this.failwhennotsuccess);
            rep.saveStepAttribute(id_transformation, id_step, "outputlinedelimiter", this.outputLineDelimiter);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ExecProcessMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.resultfieldname)) {
            error_message = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        if (Const.isEmpty((String)this.processfield)) {
            error_message = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ProcessFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ProcessFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExecProcess(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExecProcessData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return this.failwhennotsuccess;
    }

    public void setOutputLineDelimiter(String value) {
        this.outputLineDelimiter = value;
    }

    public String getOutputLineDelimiter() {
        return this.outputLineDelimiter;
    }
}

